/*===================== begin_copyright_notice ==================================

Copyright (c) 2017 Intel Corporation

Permission is hereby granted, free of charge, to any person obtaining a
copy of this software and associated documentation files (the
"Software"), to deal in the Software without restriction, including
without limitation the rights to use, copy, modify, merge, publish,
distribute, sublicense, and/or sell copies of the Software, and to
permit persons to whom the Software is furnished to do so, subject to
the following conditions:

The above copyright notice and this permission notice shall be included
in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


======================= end_copyright_notice ==================================*/

/*
 * !!! DO NOT EDIT THIS FILE !!!
 *
 * This file was automagically crafted by GED's model parser.
 */


#ifndef GED_ENUM_INTERPRETERS_H
#define GED_ENUM_INTERPRETERS_H

#include "common/ged_types_internal.h"

/*!
 * This is an enumeration of all the reinterpreted string enumerations available for queries by GED. It is a consolidated list of all
 * interpreters from all supported models.
 *
 * @note        Some interpreters may not be available on all models.
 */
typedef enum
{
    GED_REINTERPRETED_ENUM_OperandWidth,       ///< The operand width, based on its data type.

    /*!
     * The numeric type in which to display an operand, based on its data type. Relevant only for immediate operands.
     */
    GED_REINTERPRETED_ENUM_OperandNumericType,

    /*!
     *
     *                 Nibble Control. This field is used in some instructions along with QtrCtrl. See the description of
     * ExecMaskOffsetCtrl.
     *                 NibCtrl is only used for SIMD4 instructions.
     *
     */
    GED_REINTERPRETED_ENUM_NibCtrl
} GED_REINTERPRETED_ENUM;
extern const ged_unsigned_table_t EnumInterpretersTable0[3];
extern const ged_unsigned_table_t EnumInterpretersTable1[3];
extern const ged_unsigned_table_t EnumInterpretersTable2[3];
extern const ged_unsigned_table_t EnumInterpretersTable3[3];
#endif // GED_ENUM_INTERPRETERS_H
