OPTION(ITK_USE_KWSTYLE "Enable the use of KWStyle for checking coding style." OFF)

IF( ITK_USE_KWSTYLE )

OPTION(KWSTYLE_USE_VIM_FORMAT "Set KWStyle to generate errors with a VIM-compatible format." OFF)
OPTION(KWSTYLE_USE_MSVC_FORMAT "Set KWStyle to generate errors with a VisualStudio-compatible format." OFF)

FIND_PROGRAM(KWSTYLE_EXECUTABLE
NAMES KWStyle 
PATHS
/usr/local/bin
)

#
#  Define file names
#
SET(KWSTYLE_CONFIGURATION_FILE 
  ${PROJECT_BINARY_DIR}/Utilities/KWStyle/ITK.kws.xml)

SET(KWSTYLE_ITK_FILES_LIST
  ${PROJECT_BINARY_DIR}/Utilities/KWStyle/ITKFiles.txt)

SET(KWSTYLE_ITK_REVIEW_FILES_LIST
  ${PROJECT_BINARY_DIR}/Utilities/KWStyle/ITKReviewFiles.txt)

SET(KWSTYLE_ITK_OVERWRITE_FILE
  ${PROJECT_SOURCE_DIR}/Utilities/KWStyle/ITKOverwrite.txt )

#
# Configure the files
#
CONFIGURE_FILE(
  ${PROJECT_SOURCE_DIR}/Utilities/KWStyle/ITKFiles.txt.in
  ${KWSTYLE_ITK_FILES_LIST})

CONFIGURE_FILE(
  ${PROJECT_SOURCE_DIR}/Utilities/KWStyle/ITKReviewFiles.txt.in
  ${KWSTYLE_ITK_REVIEW_FILES_LIST})

CONFIGURE_FILE(
  ${PROJECT_SOURCE_DIR}/Utilities/KWStyle/ITK.kws.xml.in
  ${KWSTYLE_CONFIGURATION_FILE})


#
#  Define formatting for error messages
#
SET(KWSTYLE_EDITOR_FORMAT " ")
SET(KWSTYLE_EDITOR_FORMAT "")
IF(KWSTYLE_USE_VIM_FORMAT)
  SET(KWSTYLE_EDITOR_FORMAT -vim)
ENDIF(KWSTYLE_USE_VIM_FORMAT)

IF(KWSTYLE_USE_MSVC_FORMAT)
  SET(KWSTYLE_EDITOR_FORMAT -msvc)
ENDIF(KWSTYLE_USE_MSVC_FORMAT)

SET(KWSTYLE_ARGUMENTS_REVIEW
  -xml ${KWSTYLE_CONFIGURATION_FILE} -v -D ${KWSTYLE_ITK_REVIEW_FILES_LIST}
  -o ${KWSTYLE_ITK_OVERWRITE_FILE} ${KWSTYLE_EDITOR_FORMAT}
  )

SET(KWSTYLE_ARGUMENTS_CODE
  -xml ${KWSTYLE_CONFIGURATION_FILE} -v -D ${KWSTYLE_ITK_FILES_LIST}
  -o ${KWSTYLE_ITK_OVERWRITE_FILE} ${KWSTYLE_EDITOR_FORMAT}
  )

ADD_CUSTOM_COMMAND(
  OUTPUT ${ITK_BINARY_DIR}/KWStyleReviewReport.txt
  COMMAND ${KWSTYLE_EXECUTABLE}
  ARGS    ${KWSTYLE_ARGUMENTS_REVIEW}
  COMMENT "Coding Style Checker"
  )

ADD_CUSTOM_COMMAND(
  OUTPUT ${ITK_BINARY_DIR}/KWStyleCodeReport.txt
  COMMAND ${KWSTYLE_EXECUTABLE}
  ARGS    ${KWSTYLE_ARGUMENTS_CODE}
  COMMENT "Coding Style Checker"
  )

ADD_CUSTOM_TARGET(StyleCheckReview DEPENDS ${ITK_BINARY_DIR}/KWStyleReviewReport.txt)
ADD_CUSTOM_TARGET(StyleCheckCode DEPENDS ${ITK_BINARY_DIR}/KWStyleCodeReport.txt)

ADD_TEST(KWStyleReviewTest ${KWSTYLE_EXECUTABLE} ${KWSTYLE_ARGUMENTS_REVIEW})
ADD_TEST(KWStyleCodeTest   ${KWSTYLE_EXECUTABLE} ${KWSTYLE_ARGUMENTS_CODE})

ENDIF( ITK_USE_KWSTYLE )
