dnl
dnl CONFIGURE_PYTHON([MINIMUM-VERSION, [ACTION-IF-FOUND [, ACTION-IF-NOT-FOUND]]])
dnl \author janders@users.sf.net
dnl

AC_DEFUN(CONFIGURE_PYTHON,
[
 python_error="no"

  PYTHON_CFLAGS=""
  PYTHON_LIBS=""
  PYTHON_LIB=""
  ver="1.5"

  AC_ARG_WITH(python-version,
    [ --with-python-version=VER    The version of Python to use, 1.5 is default ],
    [
      ver="$withval"
    ])

  python_includes="/usr/include/python$ver/"
  python_libraries="/usr/lib/python$ver/config"



  AC_ARG_WITH(python-prefix,
    [  --with-python-prefix=PFX    where the root of Python is installed ],
    [
      python_includes="$withval/include"
      python_libraries="$withval/lib/config"
      python_binaries="$withval/bin"
    ])

  AC_ARG_WITH(python-includes,
    [  --with-python-includes=DIR  where the Python includes are installed ],
    [
      python_includes="$withval"
    ])

  AC_ARG_WITH(python-libraries,
    [  --with-python-libraries=DIR where the Python libraries are installed.],
    [
      python_libraries="$withval"
    ])

		AC_MSG_CHECKING([for Python includes ($python_includes)])
    AC_CACHE_VAL(python_includes_found,
    [
      if test -e "$python_includes"/Python.h; then
        PYTHON_CFLAGS="-I$python_includes"
        AC_MSG_RESULT(yes)
      else
        python_error=yes
        AC_MSG_RESULT(no)
      fi
    ])

    AC_MSG_CHECKING([for Python libraries ($python_libraries)])
    AC_CACHE_VAL(python_libraries_found,
    [
     if test -e "$python_libraries"/libpython$ver.a; then
        PYTHON_LIB="-lpython$ver"
        PYTHON_LIBS="-L$python_libraries"
        AC_MSG_RESULT(yes)
      else
        python_error=yes
        AC_MSG_RESULT(no)
      fi

    ])dnl

    if test "$python_error" = "yes"; then
      PYTHON_CFLAGS=""
      PYTHON_LIBS=""
	else
		AC_DEFINE(USE_PYTHON, "yes", [Define to embed python.])
	fi

    AC_SUBST(PYTHON_CFLAGS)
    AC_SUBST(PYTHON_LIBS)
    AC_SUBST(PYTHON_LIB)

])
