AC_DEFUN([CONFIGURE_DEBUG_CFG],
[
  AC_ARG_ENABLE(debug,
    [  --enable-debug      enable debugging mode],
    [
      CFLAGS="-D_DEBUG -pipe -g3 -Wall"
      CXXFLAGS="-D_DEBUG -pipe -g3 -Wall"
    ],[
      CFLAGS="-O2"
      CXXFLAGS="-O2"
    ])

  DMALLOC_CFLAGS=""
  DMALLOC_LIBS="-ldmalloc"
  AC_MSG_CHECKING(dmalloc cflags)
  AC_ARG_WITH(dmalloc-cflags,  [  --with-dmalloc-cflags=CFLAGS ],
    DMALLOC_CFLAGS="$withval",
  )
  AC_MSG_RESULT($DMALLOC_CFLAGS)
  AC_MSG_CHECKING(dmalloc libs)
  AC_ARG_WITH(dmalloc-libs,    [  --with-dmalloc-libs=LIBS ],
    DMALLOC_LIBS="$withval",
  )
  AC_MSG_RESULT($DMALLOC_LIBS)

  AC_ARG_ENABLE(dmalloc,
    [  --enable-dmalloc        enable dmalloc memory leak tracking],
    [
      CFLAGS="$CFLAGS -D_DEBUG_NEW"
      CXXFLAGS="$CXXFLAGS -D_DEBUG_NEW"
    ],[
      DMALLOC_CFLAGS=""
      DMALLOC_LIBS="" 
    ]) 

  AC_SUBST(DMALLOC_CFLAGS)
  AC_SUBST(DMALLOC_LIBS)
])
