/***************************************************************************
                       undostack.cpp  -  description                              
                          -------------------                                         
 begin                : Sun Dec 5 1999                                           
 copyright            : (C) 1999 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "undostack.h"
#include "i3d.h"

UndoStack *UndoStack::undo = 0;

UndoStack::UndoStack()
{
  stack = new QStack < Command > ();
  size = 50;
}

UndoStack::~UndoStack()
{
  delete stack;
}

void UndoStack::clear()
{
  stack->clear();
}

Command * UndoStack::pop()
{
  return stack->pop();
}

void UndoStack::push( Command *c )
{
  stack->push( c );

  I3D::getInstance() -> setModified( true );
}

UndoStack * UndoStack::getInstance()
{
  if ( undo == 0 )
    undo = new UndoStack();

  return undo;
}
