/***************************************************************************
                       selectionrecord.cpp  -  description                              
                          -------------------                                         
 begin                : Sat Nov 6 1999                                           
 copyright            : (C) 1999 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "selectionrecord.h"
#include <Entities/subobject.h>
#include <Entities/entity.h>
#include <objectdb.h>

/**Creates a selection Record from the given selection buffer
  */
SelectionRecord::SelectionRecord( GLuint *selectBuf, int _hits ) : hitrecords()
{
  buffer = selectBuf;
  hits = _hits;


}

SelectionRecord::~SelectionRecord()
{}

/** returns a vector of entities that have been selected of the given type.
  * type can be any entity type, such as ENTITY_MESH, ENTITY_VERTEX, etc.
  * mode can be SELECT_REPLACE, SELECT_MODIFY, or SELECT_SINGLE
  */
std::vector < Selectable * > * SelectionRecord::getSelected( int type, int mode )
{

  std::vector < Selectable * > hit_entities;
  std::vector < float > entity_depths;

  if ( mode & SELECT_REPLACE )
    ObjectDB::getInstance() ->setNoneSelected();

  /**clear out the hit records vector;
    */

  for ( int i = 0; i < ( int ) hitrecords.size(); i++ )
  {
    delete hitrecords[ i ];
  }

  hitrecords.clear();

  /* Loop through the selection buffer, creating hit records for each hit.
   */
  GLuint *ptr;
  ptr = ( GLuint * ) buffer;

  for ( int i = 0; i < hits; i++ )
  {
    HitRecord *h = new HitRecord();

    if ( h -> init( ptr ) && ( h -> getNumObjects() > 0 ) )
    {
      hitrecords.push_back( h );

      //    h -> dump();
    }

    int j = h -> getNumNames();

    j += 3;
    ptr += j;
  }

  //adjust the number of hits to the actual registered hits.
  hits = hitrecords.size();

  for ( int i = 0; i < hits; i++ )
  {
    int base_object = hitrecords[ i ] ->getBaseObject();

    Entity *e = ( Entity * ) ObjectDB::getInstance() ->get
                ( base_object );

    int etype = e->getBaseType();


    if ( etype == type )
    {
      hit_entities.push_back( e );
      entity_depths.push_back( hitrecords[ i ] ->getMin() );
    }

    std::vector < int > *objects = hitrecords[ i ] ->getAllObjects();
    //skip the first object, as it's already taken care of...
    for ( int j = 1; j < ( int ) objects->size(); j++ )
    {
      int obj = ( *objects ) [ j ];
      Selectable *se = ( Entity * ) e->getSubObject( type, obj );

      if ( se != 0 )
      {
        //cerr<<"Index = "<< obj<<endl;
        //((SubObject *)se) -> dump();
        hit_entities.push_back( se );
        entity_depths.push_back( hitrecords[ i ] ->getMin() );
      } //if
    } //for objects

  } //for i



  if ( hit_entities.size() == 0 )
    return ObjectDB::getInstance() ->getSelected();

  //if single mode, only take the top of the hits.
  if ( mode & SELECT_SINGLE )
  {
    unsigned int z = ( unsigned int ) pow( ( double ) 2, ( double ) 32 ) - 1;
    Selectable *e;

    for ( int j = 0; j < ( int ) entity_depths.size(); j++ )
    {
      if ( z > entity_depths[ j ] )
      {
        z = ( unsigned int ) entity_depths[ j ];
        e = hit_entities[ j ];
      }

    }

    hit_entities.clear();
    hit_entities.push_back( e );

  }

  //remove any copies...
  std::sort( hit_entities.begin(), hit_entities.end() );

  hit_entities.erase( std::unique( hit_entities.begin(), hit_entities.end() ), hit_entities.end() );


  if ( mode & SELECT_MODIFY )
  {
    for ( int i = 0; i < ( int ) hit_entities.size(); i++ )
      ObjectDB::getInstance() ->toggleSelected( hit_entities[ i ] );

  }

  else
  {
    for ( int i = 0; i < ( int ) hit_entities.size(); i++ )
      ObjectDB::getInstance() ->setSelected( hit_entities[ i ] );
  }


  return ObjectDB::getInstance() ->getSelected();
}

Selectable * SelectionRecord::find( std::vector < Selectable * > *v, int id )
{
  for ( int j = 0; j < ( int ) v->size(); j++ )
  {
    if ( ( *v ) [ j ] ->getID() == id )
      return ( *v ) [ j ];
  }

  return 0;

}

/**Returns a pointer to the top most entity in the
  *hit record.  This is used for single selection
  * min z and max z in the hit record range from -1 to 1;
  */
HitRecord * SelectionRecord::getTopHit()
{
  float z = 0;
  HitRecord *hr = 0;

  for ( int i = 0; i < ( int ) hitrecords.size(); i++ )
  {
    float cz = hitrecords[ i ] ->getMin() / ( 2 ^ 32 - 1 );

    if ( cz > z )
    {
      z = cz;
      hr = hitrecords[ i ];
    }

  }

  return hr;
}


/*****************************************************************************/
/**Creates a hitrecord from the current position of the selection buffer.
  *Note: this will advance the pointer!
  */
HitRecord::HitRecord() : objects()
{}

bool HitRecord::init( GLuint *ptr )
{
  num_names = *ptr;

  ptr++;

  min = *ptr;
  ptr++;
  max = *ptr;
  ptr++;


  if ( num_names == 0 )
    return false;

  for ( int j = 0; j < ( int ) num_names; j++ )
  {
    //ignores 0 if it's the top name (default)
    if ( *ptr > 0 || j != 0 )
      objects.push_back( *ptr );

    ptr++;
  }

  return true;


}

HitRecord::~HitRecord()
{}

/**Dumps the contents of the hit record to the stderr.
  */
void HitRecord::dump()
{
  cerr << "HitRecord:" << endl;
  cerr << "  number of names:" << num_names << endl;
  cerr << "  minimum Z value:" << min << endl;
  cerr << "  maximum Z value:" << max << endl;
  cerr << "  selection stack:";

  for ( int i = 0; i < ( int ) objects.size(); i++ )
    cerr << objects[ i ] << ",";

  cerr << endl;
}

