/***************************************************************************
                         i3dview.h  -  description
                            -------------------                                         
   begin                : Sat Aug 14 10:38:16 CDT 1999
                                          
   copyright            : (C) 1999 by Jon Anderson                         
   email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef I3DWORKSPACE_H
#define I3DWORKSPACE_H

#ifdef HAVE_CONFIG_H
#include <autoconfig.h>
#endif

// include files for Qt
#include <qwidget.h>
#include <qlayout.h>
#include <qtabwidget.h>
#include <qstring.h>
#include <MDI/qextmdimainfrm.h>
#include <vector> 
//local includes

#define V3D 0
#define VXY 1
#define VXZ 2
#define VYZ 3
#define VUV 4

class I3DDoc;
class GLView;
class Vector4;
class IControl;
class CreateTab;
class ModifyTab;
class HierarchyTab;

/** I3DWorkspace provides a single entry point to the current views.
  *
  * @author Jon Anderson
 * @version 5.0
  */

class I3DWorkspace : public QextMdiMainFrm //Widget
{
   Q_OBJECT

   //friend class QextMdiMainFrm;

public:

   I3DWorkspace( QWidget* parent = 0, const char* name = 0 );
   ~I3DWorkspace();

   void init();

   GLView *getGLView( int view );

   QPopupMenu *getPopupMenu()
   {
      return windowMenu();
   };

   void initDefaultViews();
   GLView * addView( int, bool );

   void loadConfig();
   void saveConfig();

   void maximize();

   IControl *getCurrentControl();
   void setCurrentControl( IControl * );

   GLView * getCurrentView();

   void revertControl();
   void refreshOptions();
   GLView *getSharedContext()
   {
      return baseview;
   };


public slots:
   void update();
   void removeView( QextMdiChildView* );

protected slots:
   virtual void activateView( QextMdiChildView *pWnd );

private:
   GLView *baseview;

   std::vector<QextMdiChildView *>views;

   bool max_size;

   IControl * m_current_control;
   IControl * m_previous_control;

};

#endif // MODELLERVIEW_H
























