/***************************************************************************
                       I3DWorkspace.cpp  -  description
                          -------------------
 begin                : Sat Aug 14 10:38:16 CDT 1999

 copyright            : (C) 1999 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qprinter.h>
#include <qpainter.h>
#include <qfont.h>

// application specific includes
#include "i3dworkspace.h"
#include "i3ddoc.h"
#include "i3d.h"

#include "Views/view3D.h"
#include "Views/viewXY.h"
#include "Views/viewXZ.h"
#include "Views/viewYZ.h"
#include "Views/viewUV.h"

#include <Modifiers/icontrol.h>
#include "Views/glmdiview.h"

#include <qtoolbar.h>
#include <algorithm>

static int num_3d_views = 0;
static int num_xy_views = 0;
static int num_xz_views = 0;
static int num_yz_views = 0;
static int num_uv_views = 0;

I3DWorkspace::I3DWorkspace( QWidget *parent, const char* name ) : QextMdiMainFrm( parent, name, 0 )
{
  /** Needs to be here in constructor.  init doesn't happen till after other
    * components initialize, which will be too late to share contexts then.
    */
  baseview = 0;

  m_current_control = 0;
  m_previous_control = 0;

  //create a glcontext that will be shared by all.
  baseview = new View3D( this, "baseview", 0 );
  baseview->hide();


  cerr << "GL Version:\n\t"
  << glGetString( GL_VENDOR ) << " : "
  << glGetString( GL_RENDERER ) << " : "
  << glGetString( GL_VERSION ) << " : " << endl;
  cerr << "Extensions:\nt" << glGetString( GL_EXTENSIONS ) << endl;

  cerr << "GLU Version:\n\t" << gluGetString( GLU_VERSION ) << endl;


}

//Maximizes the first view for starting.
void I3DWorkspace::maximize()
{
  static_cast < GLMdiView * > ( views[ 0 ] ) -> activate();
  static_cast < GLMdiView * > ( views[ 0 ] ) -> maximize();
}

void I3DWorkspace::init()
{

  setCaption( "Innovation3D" );

  max_size = true;

  initDefaultViews();

  //maximize the 3D view
  cascadeMaximized();

}

I3DWorkspace::~I3DWorkspace()
{}

void I3DWorkspace::initDefaultViews()
{
  addView( V3D, false );
  addView( VXZ, false );
  addView( VXY, false );
  addView( VYZ, false );
}

GLView * I3DWorkspace::addView( int x, bool apply_settings )
{
  GLMdiView * gmv = 0;
  GLView *gv = 0;

  QString num;


  switch ( x )
  {

    case V3D:

      if ( num_3d_views > 0 )
        num.setNum( num_3d_views );

      gmv = new GLMdiView( const_cast < char * > ( num.prepend( "3D " ).ascii() ), this );

      gv = new View3D( gmv, "3D", baseview );

      num_3d_views++;

      break;

    case VXY:
      if ( num_xy_views > 0 )
        num.setNum( num_xy_views );

      gmv = new GLMdiView( const_cast < char * > ( num.prepend( "XY (Front) " ).ascii() ), this );

      gv = new ViewXY( gmv, "XY (Front)", baseview );

      num_xy_views++;

      break;

    case VXZ:
      if ( num_xz_views > 0 )
        num.setNum( num_xz_views );

      gmv = new GLMdiView( const_cast < char * > ( num.prepend( "XZ (Top) " ).ascii() ), this );

      gv = new ViewXZ( gmv, "XZ (Top)", baseview );

      num_xz_views++;

      break;

    case VYZ:
      if ( num_yz_views > 0 )
        num.setNum( num_yz_views );

      gmv = new GLMdiView( const_cast < char * > ( num.prepend( "YZ (Side) " ).ascii() ), this );

      gv = new ViewYZ( gmv, "YZ (Side)", baseview );

      num_yz_views++;

      break;

    case VUV:
      if ( num_uv_views > 0 )
        num.setNum( num_uv_views );

      gmv = new GLMdiView( const_cast < char * > ( num.prepend( "UV " ).ascii() ), this );

      gv = new ViewUV( gmv, "UV", baseview );

      num_uv_views++;

      break;

    default:
      break;
  }

  gv->setI3DWorkspace( this );
  gmv->setView( gv );

  //connect( gmv, SIGNAL(activate()), gv, SLOT(slotActivate()) );

  //QRect r = rect();
  //mdi->addWindow(gmv, true, true, max_size, new QRect(0, 0, 600, 400));
  //addWindow(gmv, true, true, true, &r );

  //  QRect r(0, 0, 600, 400 );
  //  addWindow( gmv, true, true, true, new QRect( 0, 0, 600, 400 ) );
  addWindow( gmv );

  views.push_back( gmv );
  max_size = false;


  // if(apply_settings) //apply settings to all windows as shortcut
  //  I3D::getConfig()->applySettings();

  update();
  return gv;
}

void I3DWorkspace::removeView( QextMdiChildView *gmv )
{
  cerr << "Removing view" << endl;
  //Memory leak here.
  views.erase( std::find( views.begin(), views.end(), gmv ) );

}

void I3DWorkspace::update()
{
  for ( int i = 0; i < ( int ) views.size(); i++ )
  {
    static_cast < GLMdiView * > ( views[ i ] ) -> updateGL();
  }

}

GLView * I3DWorkspace::getGLView( int mode )
{

  for ( int i = 0; i < ( int ) views.size(); i++ )
  {
    GLView *v = static_cast < GLMdiView * > ( views[ i ] ) -> getView();

    if ( v->getViewType() == mode )
      return v;
  }

  return 0;
}

void I3DWorkspace::setCurrentControl( IControl * c )
{
  /* If we are currently in a modify mode, save it.
   */

  if ( m_current_control != 0 && m_current_control -> getControlType() == IControl::MODIFIER )
    m_previous_control = m_current_control;

  cerr << "Activating Control" << c -> getName().c_str() << endl;

  m_current_control = c;

  //force deactivation.
  if ( m_previous_control != 0 )
    m_previous_control -> deactivate();

}

void I3DWorkspace::revertControl()
{
  //force deactivation.
  if ( m_current_control != 0 )
    m_current_control -> deactivate();

  m_current_control = m_previous_control;

  //force activation
  if ( m_current_control != 0 )
    m_current_control -> activate();
}

IControl * I3DWorkspace::getCurrentControl()
{
  return m_current_control;
}

void I3DWorkspace::refreshOptions( )
{
  for ( int i = 0; i < ( int ) views.size(); i++ )
    dynamic_cast < GLMdiView * > ( views[ i ] ) -> getView() -> refreshOptions();
}

GLView * I3DWorkspace::getCurrentView()
{
  GLView * v;
  v = dynamic_cast < GLMdiView * > ( activeWindow() ) -> getView();
  return v;
}

void I3DWorkspace::activateView( QextMdiChildView *pWnd )
{
  cerr << "Activating window" << endl;
  QextMdiMainFrm::activateView( pWnd );
  cerr << "setting window view menu.." << endl;
  // I3D::getInstance() -> setViewMenu( dynamic_cast<GLView *>(pWnd) -> getViewMenu() );

}































































