/***************************************************************************
                         i3dparser.cpp  -  description
                            -------------------
   begin                : Fri Jun 7 2002
   copyright            : (C) 2002 by janders
   email                : janders@damascus.onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "i3dparser.h"
#include <qfile.h>
#include <stdlib.h>
#include <stdio.h>
#include "i3d.h"
#include "basecontroller.h"

#include <Entities/entity.h>
#include <Entities/texturematerial.h>
#include <Entities/parser.h>
#include <objectdb.h>

I3DParser::I3DParser( string filename, bool binary )
{
  m_filename = filename;
  m_binary = binary;
}

I3DParser::~I3DParser()
{}


bool I3DParser::write()
{

  QDomDocument doc( "i3d" );

  //start constructing the DOM
  QDomElement element;
  QDomElement root;

  root = doc.createElement( "i3d" );
  root.setAttribute( "version", "1" );
  doc.appendChild( root );

  element = doc.createElement( "materials" );
  root.appendChild( element );

  ObjectDB *db = ObjectDB::getInstance();

  for ( int i = 0; i < ( int ) db -> numMaterials(); i++ )
  {
    printf( "Saving Material\n" );
    Parser::getParser( TextureMaterial::TYPE ) -> write( element, db -> getMaterial( i ) );
  }

  std::vector < Selectable * > *slist = db -> getList( );

  for ( int i = 0; i < ( int ) slist -> size(); i++ )
  {
    Selectable *s = ( *slist ) [ i ];
    printf( "Saving selectable #%d - %d\n", i, s -> getType() );
    Parser::getParser( s -> getType() ) -> write( root, s );
  }

  //	printf( "%s\n", doc.toString().ascii() );
  ofstream out;

  out.open( m_filename.c_str(), ios::out );

  if ( !out )
    return false;

  out << doc.toString().ascii();

  out.close();

  return true;
}

bool I3DParser::read()
{

  //start constructing the DOM
  QDomElement element;
  QDomElement root;
  QDomElement materials;

  ObjectDB *db = ObjectDB::getInstance();


  QDomDocument doc( "i3d" );
  QFile f( m_filename.c_str() );

  if ( !f.open( IO_ReadOnly ) )
    return false;

  if ( !doc.setContent( &f ) )
  {
    f.close();
    return false;
  }

  f.close();

  // print out the element names of all elements that are a direct child
  // of the outermost element.
  root = doc.documentElement();

  printf( "Reading %s\n", root.tagName().ascii() );
  Parser *p;
  Selectable *t;
  TextureMaterial *tm;

  //read Materials
  QDomNode n = root.namedItem( "materials" ).firstChild();

  while ( !n.isNull() )
  {
    QDomElement e = n.toElement(); // try to convert the node to an element.
    if ( !e.isNull() )
    {
      printf( "Reading %s\n", e.tagName().ascii() );
      tm = static_cast < TextureMaterial * > ( Parser::getParser( e.tagName().ascii() ) -> read( e ) );
      db -> addMaterial( tm );

    }

    n = n.nextSibling();
  }

  //read everythin else.
  n = root.firstChild();

  while ( !n.isNull() )
  {

    QDomElement e = n.toElement(); // try to convert the node to an element.
    if ( !e.isNull() && ( e.tagName() != "materials" ) )
    {
      printf( "Reading %s\n", e.tagName().ascii() );
      t = static_cast < Selectable * > ( Parser::getParser( e.tagName().ascii() ) -> read( e ) );
      db -> add( t );

    }

    n = n.nextSibling();
  }


  //update the BaseController's max keyframe.
  BaseController::getInstance() -> checkMaxTime();

  return true;


}



