/***************************************************************************
                       i3ddoc.cpp  -  description
                          -------------------
 begin                : Sat Aug 14 10:38:16 CDT 1999

 copyright            : (C) 1999 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>
#include <qmessagebox.h>

// include files for KDE
#include <qapplication.h>
#include <qmessagebox.h>

// application specific includes
#include <i3ddoc.h>
#include "i3d.h"
#include "i3dworkspace.h"

#include "Entities/entitylib.h"
#include "Commands/commandlib.h"

#include "objectdb.h"

#include "FileIO/i3dstaticio.h"


I3DDoc::I3DDoc( QWidget *parent, const char* name ) : QObject( parent, name )
{
  db = ObjectDB::getInstance();

  clipboard = new std::vector < Entity * > ( 100 );

  m_filename = "";
}

I3DDoc::~I3DDoc()
{}

void I3DDoc::draw()
{
  db->draw();
}

void I3DDoc::setFilename( const char* path_name )
{
  m_filename = path_name;
}


bool I3DDoc::saveModified()
{
  //  int want_save = QMessageBox::warning(win,
  //           "Warning", "The current file has been modified.\nDo you want to save it?");
  cerr << "Not saving Modified! =)" << endl;
  return true;
}

void I3DDoc::closeDocument()
{
  deleteContents();
}

bool I3DDoc::newDocument()
{
  cerr << "New document!" << endl;
  m_filename = "";
  // delete db;
  // db = 0;
  // db = ObjectDB::getInstance();

  return true;

}

bool I3DDoc::openDocument( const char* filename, const char* format )
{
  m_filename = filename;

  cerr << "opening" << endl;
  I3DStaticIO *io = new I3DStaticIO( filename );
  io->read();

  b_modified = false;
  I3D::updateViews();
  return true;
}

bool I3DDoc::saveDocument( const char* filename, const char* format )
{

  m_filename = filename;

  cerr << "saving " << filename << endl;
  I3DStaticIO *io = new I3DStaticIO( filename );
  io->write();

  b_modified = false;
  return true;
}

void I3DDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////

}













































































































































