/***************************************************************************
                        i3d.h  -  description
                           -------------------                                         
  begin                : Sat Aug 14 10:38:16 CDT 1999
                                         
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef I3D_H
#define I3D_H


#ifdef HAVE_CONFIG_H
#include <autoconfig.h>
#endif

#include <qapplication.h>
#include <qmainwindow.h>
#include <qaccel.h>
#include <qpopupmenu.h>
#include <qtoolbutton.h>
#include <qlist.h>
#include <qstring.h>
#include <qlabel.h>
#include <map>
#include <algorithm>
#include <qintdict.h>


using namespace std;

//local includes for the I3D

class IControl;
class I3DWorkspace;
class MatEditor;
class PythonConsole;
class ObjectDB;
class PluginRegistry;
class ConfigDlg;
class Config;

/** The main application class
  */

class I3D : public QMainWindow
{
   Q_OBJECT

public:
   I3D();
   ~I3D();

   typedef map<int, IControl *, less<int> > IControlMap;
   typedef IControlMap::value_type IControlPair;

   void setViewMenu( QPopupMenu * );
   void enableCommand( int id_ );
   void disableCommand( int id_ );

   void setModified( bool b );

   void addRecentFile( const char* file );
   void openFile( const char* _cmdl );
   void saveFile( const char* _cmdl );

   void saveConfig( );

   QToolBar * getToolbar();

   /** returns a pointer to the i3d object.  This is a singleton reference method. */
   static I3D * getInstance();

   /** More static shortcuts */
   static I3DWorkspace * getWorkspace();
   static Config * getConfig();
   static MatEditor * getMatEditor();
   static PythonConsole * getScriptEditor();

   static ObjectDB * getDB();
   static PluginRegistry * getPluginRegistry();

   static void updateViews();

   static void setModeMsg( char * );
   static void setPlaceLabel( char *text );

   void set_mode_msg( char * );
   void set_place_label( char *text );

   static IControl * activateControl( int );

   IControl * activate_control( int );

protected:

   void initKeyAccel();
   void initMenuBar();
   void initToolBar();
   void initStatusBar();
   void initDatabase();
   void initView();
   void initPlugins();
   void initConfig();
   void initRecentFiles();
   void initPython();

   void reset();

   I3DWorkspace * workspace();
   Config * config();
   MatEditor * mateditor();
   PythonConsole * scripteditor();
   ObjectDB * objectdb();
   PluginRegistry * pluginregistry();

   void closeEvent( QCloseEvent * );

public slots:
   /** switch argument for slot selection by menu or toolbar ID */
   void commandCallback( int id_ );
   /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
   void statusCallback( int id_ );

   /** Slots */
   void slotFileNewWindow();
   void slotFileNew();
   void slotFileOpen();
   void slotFileOpenRecent( int id_ );
   void slotFileSave();
   void slotFileSaveAs();
   void slotFileReset();
   void slotFilePrint();
   void slotFileQuit();

   void slotEditCut();
   void slotEditCopy();
   void slotEditPaste();
   void slotObjectSelector();

   void slotMaterialEditor();
   void slotScriptEditor();

   void slotOptions();

   void slotRedo();
   void slotUndo();
   void slotAddView( int );
   void slotShowHelp();
   void slotStatusMsg( const char *text );
   void slotUpdateViews();

   void slotStatusHelpMsg( const char *text );

   QList<QString> getRecentFiles()
   {
      return recent_files;
   };

   void setRecentFiles( QList<QString> &l );

   QPopupMenu * getModifyMenu()
   {
      return modify_menu;
   };

   QPopupMenu * getCreateMenu()
   {
      return create_menu;
   };


private:
   /** the key accelerator container */
   QAccel* key_accel;

   /** file_menu contains all items of the menubar entry "File" */
   QPopupMenu *file_menu;
   QPopupMenu *layout_menu;
   QPopupMenu *operate_menu;
   QPopupMenu *create_menu;
   QPopupMenu *modify_menu;

   QPopupMenu *plugin_menu;


   /** the recent file menu containing the last five opened files */
   QPopupMenu *recent_files_menu;
   QPopupMenu *export_menu;
   QPopupMenu *import_menu;
   /** contains the recently used filenames */
   QList<QString> recent_files;
   QPopupMenu *edit_menu;
   QPopupMenu *view_menu;
   QPopupMenu *help_menu;

   I3DWorkspace *m_workspace;
   ObjectDB *m_database;

   MatEditor *m_mateditor;
   PythonConsole *m_scripter;
   Config *m_config;

   ConfigDlg *m_conf;

   PluginRegistry * m_pluginregistry;

   /** Toolbar controls used for object modelling. */
   QToolBar *tb;
   QMenuBar *mb;

   /**Singleton object for getting references to the I3DApp */
   static I3D *i3d;
   QString m_path;
   int num_toolbars;

   QIntDict<QToolButton> command_buttons;

   QLabel *lblMode;
   QLabel *lblPlace;

   IControlMap m_controls;

   int view_id;

   bool m_modified;
   QString m_filename;

};

#endif // I3D_H















































