/***************************************************************************
                         config.h  -  description
                            -------------------
   begin                : Wed May 2 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIG_H
#define CONFIG_H

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <map>
#include <string>

using namespace std;

typedef map< string, string, less<string> > StringMap;
typedef StringMap::value_type StringPair;

typedef map< string, StringMap *, less<string> > SectionMap;
typedef SectionMap::value_type Section;


/**
  * Read/Saves  a Configuration file to disk.
  * Internally, everything is strings, but are converted
  * when set or retrieved.
  *
  * Format:
  * [section1]
  * key1=value
  * key2=value
  * key4=value
  * [section2]
  * key5=value
  * key1=value
  * key2=value
  * etc...
  *@author Jon Anderson
  */

class Config
{

public:

   Config() : filename(), current_section(), config()
   {}

   ;

   bool load( string );
   bool save( string );
   bool save();

   void setSection  ( string );

   string getString ( string );
   int getInt       ( string );
   float getFloat   ( string );
   bool getBool     ( string );

   char getLowerChar( string );
   char getLowerChar( string sect, string key )
   {
      setSection( sect );
      return getLowerChar( key );
   }

   char getLowerChar( string sect, string key, string default_val );

   char getUpperChar( string );
   char getUpperChar( string sect, string key )
   {
      setSection( sect );
      return getLowerChar( key );
   }
   char getUpperChar( string sect, string key, string default_val );


   //sets the section before getting the value.
   string getString ( string sect, string key )
   {
      setSection( sect ) ;
      return getString( key );
   };

   string getString( string sect, string key, string default_val );
   int getInt ( string sect, string key )
   {
      setSection( sect ) ;
      return getInt ( key );
   };

   float getFloat ( string sect, string key )
   {
      setSection( sect ) ;
      return getFloat ( key );
   };

   bool getBool ( string sect, string key )
   {
      setSection( sect ) ;
      return getBool ( key );
   };


   void setInt   ( string, int );
   void setFloat ( string, float );
   void setString( string, string );
   void setBool  ( string, bool );
   void setString( string, string, string );
   /** Adds a default value that will be used if the key is not found. */




private:
   string filename;
   string current_section;
   SectionMap config;

};

#endif
