/***************************************************************************
                         viewXY.cpp  -  description          
                            -------------------                       
   begin                : Thu Apr 8 1999                        
   copyright            : (C) 1999 by Jonathan E. Anderson           
   email                : ande1514@tc.umn.edu                  
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "viewXY.h"
#include <Entities/texture.h>
#include <Entities/nurbssurface.h>
#include <i3d.h>

ViewXY::ViewXY( QWidget *parent, const char *name, QGLWidget *sharer )
      : GLView( parent, name, sharer )
{

   m_plane.assign( 0, 0, 1, 1 );

   camera = new Entity( 0, 0, 5, 0 );

   Vector3 axis( 1, 0, 0 );

   Quat q( axis, 90 );

   Matrix44 m( q );

   m_grid = new Grid( m );

}

ViewXY::~ViewXY()
{
}

void ViewXY::display()
{
   I3D::getDB()->draw();
}

void ViewXY::setCamera()
{
   Vector4 & pos = camera->getPosition();
   gluLookAt( 0, 0, pos.z , 0, 0, 0, 0, 1, 0 );
   glTranslatef( -pos.x, -pos.y, 0 );

}

void ViewXY::setProjection()
{
   glOrtho( -2 * zoom * wpct, 2 * zoom * wpct, -2 * zoom * hpct, 2 * zoom * hpct, -2500, 2500 );
   glGetFloatv( GL_PROJECTION_MATRIX, ( GLfloat * ) projMatrix->m );

}

void ViewXY::initView()
{
   glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
}

void ViewXY::moveCamera( float x, float y )
{
   camera->move( -x * 4 * zoom * wpct / width, y * 4 * zoom * hpct / height, 0 );
}

void ViewXY::rotateCamera( float x, float y )
{}

void ViewXY::zoomCamera( float x, float y )
{
   zoom += x * .01;

   if ( zoom < .5 )
      zoom = .5;

   resizeGL( width, height );

   updateGL();
}


void ViewXY::drawBackground()
{
   glPushAttrib( GL_TEXTURE_BIT | GL_LIGHTING_BIT | GL_POLYGON_BIT );
   glEnable( GL_TEXTURE_2D );
   glBindTexture( GL_TEXTURE_2D, background->getID() );

   glMatrixMode( GL_MODELVIEW );
   glPushMatrix();
   glLoadIdentity();

   glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );
   glDisable( GL_LIGHTING );
   glColor4f( 1, 1, 1, 1 );
   // float wt, ht;
   glTranslatef( 0, 0, -499 );

   glBegin( GL_QUADS );
   glTexCoord2f( 0, 0 );
   glVertex3f( -2 * zoom, -2 * zoom, 0 );
   glTexCoord2f( 1, 0 );
   glVertex3f( 2 * zoom, -2 * zoom, 0 );
   glTexCoord2f( 1, 1 );
   glVertex3f( 2 * zoom, 2 * zoom, 0 );
   glTexCoord2f( 0, 1 );
   glVertex3f( -2 * zoom, 2 * zoom, 0 );
   glEnd();
   glPopMatrix();

   glPopAttrib();
}

void ViewXY::drawGrid()
{
   m_grid -> draw();
}


Vector4 &ViewXY::unProjectPoint( int x, int y )
{

   Vector4 in;

   y = height - y;

   in.x = ( x - ( float ) viewport[ 0 ] ) * 2 / ( float ) viewport[ 2 ] - 1.0;
   in.y = ( y - ( float ) viewport[ 1 ] ) * 2 / ( float ) viewport[ 3 ] - 1.0;
   in.z = 0; //2*winz - 1.0;
   in.w = 1.0;
   //invert the y coord.
   // Vector4 ptScreen(x, y, .50, 1);

   Matrix44 m;
   m = *projMatrix * *modMatrix;
   m.Invert();

   tempPoint = m * in;

   tempPoint.z = 0;
   tempPoint.x /= tempPoint.w;
   tempPoint.y /= tempPoint.w;
   tempPoint.z /= tempPoint.w;

   return tempPoint;

}

void ViewXY::setWireframe2D( bool b )
{
   makeCurrent();

   if ( b )
      glPolygonMode( GL_FRONT_AND_BACK, GL_LINE );
   else
      glPolygonMode( GL_FRONT_AND_BACK, GL_FILL );

}
























































































































































































































































































































