/***************************************************************************
                         glview.cpp  -  description                                                                                    max
                            -------------------                        F
   begin                : Thu Apr 8 1999                  
   copyright            : (C) 1999 by Jonathan E. Anderson         
   email                : ande1514@tc.umn.edu                
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "glview.h"
#include <i3d.h>
#include <config.h>
#include <i3dworkspace.h>
#include <qcursor.h>
#include <Entities/texture.h>
#include <selectionrecord.h>
#include <Entities/nurbssurface.h>
#include <Entities/poly.h>
#include <Entities/face.h>
#include <qpaintdevicemetrics.h>

#include <Modifiers/modetoolbar.h>

//view configuration
float GLView::grid_size = 10;
float GLView::grid_unit = 10;
bool GLView::wireframe_3d = false;
bool GLView::wireframe_filled = false;
bool GLView::wireframe_move = false;
bool GLView::smooth_shaded = true;
bool GLView::smooth_textures = true;
bool GLView::wireframe = false;



GLView::GLView( QWidget *_parent, const char *name, QGLWidget *sharer )
      : QGLWidget( _parent, name, sharer ), m_plane(), tempPoint()
{
   cerr << "Creating GLView" << endl;
   showgrid = true;
   showaxis = true;
   menu_up = false;
   draw_background = false;
   dirty = true;
   br = bg = bb = .8;
   gr = gg = gb = .7;
   zoom = 4;

   u_repeat = 1;
   v_repeat = 1;

   selecting = false;
   twosided = false;

   //setup the 2D rendering.
   pdevice = context() ->device();
   painter = new QPainter( pdevice );

   painter->setRasterOp( XorROP );
   QPen pen;
   pen.setStyle( DashDotLine );
   pen.setColor( white );
   painter->setPen( pen );

   viewname = new QString( name );

   projMatrix = new Matrix44();
   modMatrix = new Matrix44();
   setCursor( crossCursor );

   options = new QPopupMenu();
	
	 QPopupMenu * new_view = new QPopupMenu();
	 new_view -> insertItem( "3D", this, SLOT(slotNew3D()) );
	 new_view -> insertItem( "XY - Front", this, SLOT(slotNewXY()) );
	 new_view -> insertItem( "XZ - Top", this, SLOT(slotNewXZ()) );
	 new_view -> insertItem( "YZ - Side", this, SLOT(slotNewYZ()) );
	
	 options -> insertItem( "New...", new_view );	 	 	
   options->insertItem( "Toggle Grid", this, SLOT( toggleGrid() ) );
   options->insertItem( "Toggle Axis", this, SLOT( toggleAxis() ) );
   options->insertItem( "Change Background Color", this, SLOT( changeBackgroundColor() ) );
   options->insertItem( "Set Background Texture", this, SLOT( changeBackgroundImage() ) );
   options->insertItem( "Save view as PNG", this, SLOT( saveImage() ) );
   options->insertItem( "Save view as Transparent PNG", this, SLOT( saveImageTransparent() ) );
   options->insertItem( "Print image", this, SLOT( printImage() ) );

   parentI3DWorkspace = 0;
   control = 0;

   cmode = LOCK;

   //set up the keyboard events;
   setFocusPolicy( QWidget::ClickFocus );

   setAutoBufferSwap( false );
}

GLView::~GLView()
{
   delete camera;
   delete painter;
}

void GLView::slotNew3D()
{
	I3D::getWorkspace() -> addView( V3D, true );
}
void GLView::slotNewXY()
{
	I3D::getWorkspace() -> addView( VXY, true );
}
void GLView::slotNewXZ()
{
	I3D::getWorkspace() -> addView( VXZ, true );
}
void GLView::slotNewYZ()
{
	I3D::getWorkspace() -> addView( VYZ, true );
}

void GLView::refreshOptions()
{
   Config * c = I3D::getConfig();
   c -> setSection( "Display" );
   setWireframe3D( c -> getBool( "3DWireframe" ) );
   setWireframe2D( c -> getBool( "2DWireframe" ) );

   setWireframeMove( c -> getBool( "MoveWireframe" ) );
   setSmoothShaded( c -> getBool( "SmoothShading" ) );

   setGridSpacing( c -> getInt( "GridSpacing" ) );
   setGridSize( c -> getInt( "GridSize" ) );
}

QPixmap GLView::getPixmap()
{

   makeCurrent();
   setAutoBufferSwap( false );
   updateGL();

   int num_pixels = width * height;

   unsigned char *pixels = new unsigned char[ num_pixels * 4 ];

   glReadBuffer( GL_BACK );
   glReadPixels( 0, 0, width, height, GL_RGBA, GL_UNSIGNED_BYTE, pixels );

   QPixmap p = Texture::convertBytesToPixmap( pixels, width, height );
   delete pixels;

   setAutoBufferSwap( true );
   return p;

}

void GLView::setConnections( I3DWorkspace *parent )
{
   //connect(parent, SIGNAL(refresh()), this, SLOT(refresh()));
}

void GLView::initializeGL()
{

   //do view specific intialization
   glPointSize( 3 );
   //  glShadeModel(GL_SMOOTH);
   glEnable( GL_DEPTH_TEST );

   glEnable( GL_BLEND );
   glBlendFunc( GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA );

   glClearColor( br, bg, bb, 0 );
   glInitNames();

   glDisable( GL_CULL_FACE );

   initView();
}

void GLView::paintGL()
{
   if ( selecting )
   {
      draw2D();
      return ;
   }

   GLenum error = glGetError();

   if ( error != GL_NO_ERROR )
   {
      cerr << gluErrorString( error ) << endl;
   }

   glClear( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );

   if ( draw_background )
   {
      drawBackground();
   }


   glMatrixMode( GL_MODELVIEW );
   glPushMatrix();

   setCamera();

   if ( showaxis )
      drawAxis();

   if ( showgrid )
      drawGrid();

   int *poly_mode = new int;

   glGetIntegerv( GL_POLYGON_MODE, poly_mode );

   //check the state for special line modes
   if ( *poly_mode == GL_FILL )
   {
      NurbsSurface::display_mode = GLU_FILL;
      Face::filled = true;
      Poly::filled = true;
   }

   else
   {
      NurbsSurface::display_mode = GLU_OUTLINE_POLYGON;
      Face::filled = false;
      Poly::filled = false;
   }

   delete poly_mode;

   IControl * g = currentControl();

   if ( g != 0 )
   {
      g->draw();
   }

   display();

   if( dirty )
    getMatrices();

   glPopMatrix();



   //delete strError;
   strError = const_cast<GLubyte *>( gluGetString( error ) );

   swapBuffers();

   draw2D();
}

void GLView::select( int mode )
{
   float w, h;
   float sx, sy;

   GLuint BUFFER_SIZE = 4096;
   GLuint selectBuf[ BUFFER_SIZE ];
   int hits;

   //make the set this context to be current
   makeCurrent();

   //calculate the selection square.  Need to find the center, and the 'radius'
   mouse_pressed_y = height - mouse_pressed_y;
   mouse_release_y = height - mouse_release_y;

   if ( mouse_release_y < mouse_pressed_y )
   {
      sy = mouse_release_y;
      h = mouse_pressed_y - mouse_release_y;
   }

   else
   {
      sy = mouse_pressed_y;
      h = mouse_release_y - mouse_pressed_y;
   }

   if ( mouse_release_x < mouse_pressed_x )
   {
      sx = mouse_release_x;
      w = mouse_pressed_x - mouse_release_x;
   }

   else
   {
      sx = mouse_pressed_x;
      w = mouse_release_x - mouse_pressed_x;
   }

   //the selection process.

   //get the viewport
   glGetIntegerv( GL_VIEWPORT, viewport );

   //set the selection buffer, and the render mode
   glSelectBuffer( BUFFER_SIZE, selectBuf );

   glRenderMode( GL_SELECT );

   //glInitNames();
   glPushName( 0 );

   glMatrixMode( GL_PROJECTION );

   glPushMatrix();

   glLoadIdentity();

   //create the square to pick from with the draw coords
   gluPickMatrix( sx + .5 * w, sy + .5 * h, w + 1, h + 1, viewport );

   setProjection();

   glMatrixMode( GL_MODELVIEW );

   glPushMatrix();

   glLoadIdentity();

   setCamera();

   display();

   glPopMatrix();

   glMatrixMode( GL_PROJECTION );

   glPopMatrix();

   glPopName();

   glFlush();

   hits = glRenderMode( GL_RENDER );

   int array[ hits ];

   int hit_num = 0;

   unsigned int *i = selectBuf;

   for ( int k = 0; k < hits; k++ )
   {
      int count = *i;
      i++;
      float z1, z2;
      z1 = *i;
      i++;
      z2 = *i;
      i++;

      if ( count == 0 )
         array[ k ] = -1;
      else
         for ( int j = 0; j < count; j++ )
         {
            array[ k ] = *i;
            i++;
         }

      hit_num++;
   }

   if ( currentControl() != 0 )
      currentControl() ->filterSelection( ( int * ) selectBuf, hits, mode );

}


void GLView::resizeGL( int w, int h )
{
   width = w;
   height = h;
   glMatrixMode( GL_PROJECTION );
   glLoadIdentity();

   glViewport( 0, 0, width, height );

   if ( width > height )
   {
      wpct = ( float ) width / ( float ) height;
      hpct = 1;
   }

   else
   {
      hpct = ( float ) height / ( float ) width;
      wpct = 1;
   }

   setProjection();

   glMatrixMode( GL_MODELVIEW );
   glLoadIdentity();

   //get the viewport


	dirty = true;

}

void GLView::changeBackgroundImage()
{
   QString tx;
   static QString directory = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str();
   tx = QFileDialog::getOpenFileName( directory, "Images (*.png *.xpm *.jpg *.rgb)" );

   directory = QString::null;

   if ( tx.isNull() || tx == "" )
      return ;

   setBackground( &tx );

   updateGL();

}

void GLView::changeBackgroundColor()
{
   int tr, tg, tb;
   QColor c;

   //Set up the Color Dialog
   c = QColorDialog::getColor( QColor( ( int ) br, ( int ) bg, ( int ) bb ) );



   c.rgb( &tr, &tg, &tb );
   float r = ( float ) tr / 255;
   float g = ( float ) tg / 255;
   float b = ( float ) tb / 255;
   setBackground( r, g, b );
   updateGL();

}

void GLView::printImage()
{
   QPixmap pmap;

   makeCurrent();
   updateGL();
   pmap = getPixmap( );


   QPrinter prt;

   if ( prt.setup() )
   {
      QPainter p;
      p.begin( &prt );
      p.drawPixmap( 0, 0, pmap );
      p.end();
   }

}

void GLView::saveImage()
{
   QPixmap pmap;
   QString filename;

   pmap = getPixmap( );
   static QString path = QDir::home().path();

   filename = QFileDialog::getSaveFileName( path, "*.png" );

   path = QString::null;

   if ( filename == 0 )
      return ;

   if ( filename.contains( ".png" ) < 1 )
      filename = filename + ".png";

   //pmap.setMask( pmap.createHeuristicMask() );

   pmap.save( filename, "PNG" );

   updateGL();
}

void GLView::saveImageTransparent(){
   QPixmap pmap;
   QString filename;

   pmap = getPixmap( );
   static QString path = QDir::home().path();

   filename = QFileDialog::getSaveFileName( path, "*.png" );

   path = QString::null;

   if ( filename == 0 )
      return ;

   if ( filename.contains( ".png" ) < 1 )
      filename = filename + ".png";
   //show save progress dialog here
   pmap.setMask( pmap.createHeuristicMask() );
   //update save progress dialog here
   pmap.save( filename, "PNG" );
   //finish save progress dialog here
   updateGL();
}

void GLView::draw2D()
{
   QString status( *viewname );
   painter->drawText( rect(), AlignLeft | AlignTop, status );

   if ( selecting )
   {
      //   cerr<<"Selecting = true"<<endl;
      //erase the old box
      painter->drawRect( mouse_pressed_x, mouse_pressed_y,
                         prev_mouse_move_x - mouse_pressed_x, prev_mouse_move_y - mouse_pressed_y );
      //draw the new box
      painter->drawRect( mouse_pressed_x, mouse_pressed_y,
                         mouse_move_x - mouse_pressed_x, mouse_move_y - mouse_pressed_y );
      //redraw the label.
      painter->drawText( rect(), AlignLeft | AlignTop, status );

   }

}

void GLView::drawAxis()
{
   //draw axis...
   glPushAttrib( GL_TEXTURE_BIT | GL_LIGHTING_BIT );
   glDisable( GL_TEXTURE_2D );
   glDisable( GL_LIGHTING );

   glLineWidth( 2 );

   glBegin( GL_LINES );
   glColor4f( 1, 0, 0, 1 );
   glVertex3f( -5, 0, 0 );
   glVertex3f( 5, 0, 0 );

   glColor4f( 0, 1, 0, 1 );
   glVertex3f( 0, 5, 0 );
   glVertex3f( 0, -5, 0 );

   glColor4f( 0, 0, 1, 1 );
   glVertex3f( 0, 0, 5 );
   glVertex3f( 0, 0, -5 );
   glEnd();

   //draw points marking in positive directions
   glBegin( GL_POINTS );
   glColor4f( 1, 0, 0, 1 );
   glVertex3f( 5, 0, 0 );
   glColor4f( 0, 1, 0, 1 );
   glVertex3f( 0, 5, 0 );
   glColor4f( 0, 0, 1, 1 );
   glVertex3f( 0, 0, 5 );
   glEnd();
   glLineWidth( 1 );
   glPopAttrib();
}

void GLView::drawGrid()
{}

void GLView::printString( void *font, char *string )
{
   /*  int len,i;
     
     len=(int)strlen(string);
     for(i=0;i<len;i++)
       glutBitmapCharacter(font,string[i]);
   */
}

void GLView::setBackground( QString *name )
{
   makeCurrent();
   background = new Texture( *name, 10 );
   draw_background = true;
   updateGL();
}

void GLView::showBackground( bool flag )
{
   draw_background = flag;
}

void GLView::setBackground( float r, float g, float b )
{
   makeCurrent();
   bb = b;
   br = r;
   bg = g;
   glClearColor( r, g, b, 1 );
   draw_background = false;
   updateGL();
}

void GLView::drawBackground()
{
}

void GLView::toggleAxis()
{
   showaxis = !showaxis;
   updateGL();
}

void GLView::toggleGrid()
{
   showgrid = !showgrid;
   updateGL();
}

void GLView::keyPressEvent( QKeyEvent *event )
{
    QChar c_zoom    = I3D::getConfig()->getLowerChar("FlatKeyCommands","zoom_view", "Z");
    QChar c_orbit   = I3D::getConfig()->getLowerChar("FlatKeyCommands","orbit_view", "X");
    QChar c_slide   = I3D::getConfig()->getLowerChar("FlatKeyCommands","slide_view", "C");
    QChar c_truck   = I3D::getConfig()->getLowerChar("FlatKeyCommands","truck_view", "B");
    QChar c_pan     = I3D::getConfig()->getLowerChar("FlatKeyCommands","pan_view", "V");

   if ( event->text() == c_zoom ) {
       cmode = ZOOM;
   }
   if ( event->text() == c_orbit ) {
       cmode = ORBIT;
   }
   if ( event->text() == c_slide ) {
       cmode = SLIDE;
   }
   if ( event->text() == c_truck ) {
        cmode = TRUCK;
   }
   if ( event->text() == c_pan ) {
       cmode = PAN;
   }
   /*switch ( event->key() )
   {
      case c_zoom:
         cmode = ZOOM;
         break;
      case Key_X:
         cmode = ORBIT;
         break;
      case Key_C:
         cmode = SLIDE;
         break;
      case Key_V:
         cmode = TRUCK;
         break;
      case Key_B:
         cmode = PAN;
         break;
      default:

         if ( currentControl() != 0 )
            currentControl() ->keyEvent( event );

         break;
   }*/
   if ( cmode == LOCK ) {
       currentControl() -> keyEvent( event );
   }
   /**automatically exit select mode */
   selecting = false;

   event->ignore();
}

void GLView::keyReleaseEvent( QKeyEvent *event )
{
   cmode = LOCK;
   event->ignore();
}


void GLView::mouseMoveEvent( QMouseEvent *event )
{
   prev_mouse_move_x = mouse_move_x;
   prev_mouse_move_y = mouse_move_y;

   mouse_move_x = event->x();
   mouse_move_y = event->y();



   /**updateCamera returns true if this view is currently in the camera mode
     */

   if ( !updateCamera() )
   {

      if ( currentControl() != 0 )
         currentControl() ->mouseMove( m_plane, unProjectPoint( mouse_move_x, mouse_move_y ),
                                       event->button() );
   }

   moving = true;
   updateGL();

}

void GLView::mousePressEvent( QMouseEvent *event )
{

   static_cast< GLMdiView *>( parent() ) -> setFocus();

   prev_mouse_move_x = event->x();
   prev_mouse_move_y = event->y();

   mouse_move_x = prev_mouse_move_x;
   mouse_move_y = prev_mouse_move_y;

   mouse_pressed_x = prev_mouse_move_x;
   mouse_pressed_y = prev_mouse_move_y;


   if ( cmode == LOCK )
   {

      if ( ModeToolbar::getMode() == ModeToolbar::MODE_SELECT )
      {
         selecting = true;
      }

      else
      {
         selecting = false;
      }

      if ( event->button() == ( RightButton ) )
      {
         selecting = false;

         if ( currentControl() != 0 )
         {
            context_menu = currentControl() -> getPopupMenu();
         }

         if ( context_menu == 0 )
         {
            options->popup( QWidget::mapToGlobal( QPoint( mouse_pressed_x, mouse_pressed_y ) ) );
         }

         else
         {
            int s_id = context_menu->insertSeparator();
            int c_id = context_menu->insertItem( "View Options", options );
            context_menu->exec( QWidget::mapToGlobal( QPoint( mouse_pressed_x, mouse_pressed_y ) ) );
            context_menu->removeItem( s_id );
            context_menu->removeItem( c_id );
         } //menu == 0
      }
      else
      {
         if ( currentControl() != 0 )
         {
            currentControl() ->mousePress( m_plane, unProjectPoint( mouse_pressed_x, mouse_pressed_y ), event->button() );
         }
      } //else right button

   }
   else
   {
      selecting = false;
   }


   updateGL();

}

void GLView::mouseReleaseEvent( QMouseEvent *event )
{
   // cerr<<"releasing mouse"<<endl;

   mouse_release_x = event->x();
   mouse_release_y = event->y();

   moving = false;
   selecting = false;

   if ( cmode == LOCK )
   {

      if ( ModeToolbar::getMode() == ModeToolbar::MODE_SELECT )
      {

         if ( event->state() == ( LeftButton | ControlButton ) )
            select( SELECT_MODIFY );
         else
            select( SELECT_REPLACE );
      }

      else
      {
         //    setCursor(crossCursor);

         if ( currentControl() != 0 )
            currentControl() ->mouseRelease( m_plane, unProjectPoint( mouse_release_x, mouse_release_y ),
                                             event->button() );
      }
   }

   // if(menu_up){
   // menu_up = false;
   // context_menu->removeItem(context_index);
   // context_menu->removeItem(separator_index);
   // }


   moving = false;
   dirty = true;
   updateGL();
}

Vector4 &GLView::transformPoint( Vector4 & p )
{

   p.w = 1;

   tempPoint = *modMatrix * p;
   tempPoint = *projMatrix * tempPoint;

   //need to transform to viewport here...
   tempPoint.x += 1.0;
   tempPoint.y += 1.0;

   tempPoint.x = tempPoint.x / 2 * ( ( float ) viewport[ 2 ] - ( float ) viewport[ 0 ] ) + ( float ) viewport[ 0 ];
   tempPoint.y = tempPoint.y / 2 * ( ( float ) viewport[ 3 ] - ( float ) viewport[ 1 ] ) + ( float ) viewport[ 1 ];


   return tempPoint;
}

Vector4 & GLView::unProjectPoint( int x, int y )
{
  cerr << "ERROR! CALLING INCORRECT unProjectPoint"<<endl;
   //should be re-implemented;
   Vector4 * v = new Vector4();
   return *v;
}

/** updateCamera checks the current mode of the view.  If it's in a camera mode, it
  * moves the camera appropriately
  */
bool GLView::updateCamera()
{


   if ( cmode == LOCK )
      return false;

   switch ( cmode )
   {
      case SLIDE:
         moveCamera( mouse_move_x - prev_mouse_move_x, mouse_move_y - prev_mouse_move_y );
         return true;
         break;
      case ZOOM:
         zoomCamera( mouse_move_x - prev_mouse_move_x, mouse_move_y - prev_mouse_move_y );
         return true;
         break;
      default:
         return false;
         break;
   }

   return false;
}

void GLView::setWireframeMove( bool f )
{
   wireframe_move = f;
}

void GLView::setSmoothShaded( bool f )
{
   smooth_shaded = f;
   makeCurrent();

   if ( f )
      glShadeModel( GL_SMOOTH );
   else
      glShadeModel( GL_FLAT );
}

void GLView::getMatrices()
{

  glGetFloatv( GL_MODELVIEW_MATRIX, ( GLfloat * ) modMatrix->m );
  glGetFloatv( GL_PROJECTION_MATRIX, ( GLfloat * ) projMatrix->m );
  glGetIntegerv( GL_VIEWPORT, viewport );	

  dirty = false;

}


























































































































































































































































































