/***************************************************************************
                          planarwrap.cpp  -  description
                             -------------------
    begin                : Sat Oct 14 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "planarwrap.h"
#include <Entities/face.h>
#include <Entities/vertex.h>
#include <Entities/uvcoord.h>

PlanarWrap::PlanarWrap() :UVWrap(){
}
PlanarWrap::~PlanarWrap()
{

}
Entity * PlanarWrap::clone()
{
	UVWrap *v = new PlanarWrap();
	*v = *this;
	return v;
}	
int PlanarWrap::draw(int d_options)
{
		
	glPushMatrix();
		
	Matrix44 m;
	getCompleteMatrix(&m);
	glMultMatrixf((GLfloat *)(m.m));
		glLineWidth( 2 );
	glColor4f(.5, 0, 0, 1);
	glBegin(GL_LINE_LOOP);
		glVertex3f( 0            , 0,  0            );
		glVertex3f( 1 * m_scale.x, 0,  0            );
		glVertex3f( 1 * m_scale.x, 0,  -1 * m_scale.z);
		glVertex3f( 0 * m_scale.x, 0,  -1 * m_scale.z);
	glEnd();	

	glBegin(GL_LINES);
		glColor4f(.5, 0, 0, 1);
		glVertex3f(0, 0, 0              );
		glVertex3f(0, 0, -1.5 * m_scale.z);
		glColor4f(0, .5, 0, 1);
		glVertex3f(0, 0, 0              );
		glVertex3f(1.5 * m_scale.x, 0, 0);
	glEnd();
	

		glLineWidth( 1 );
	
	glPopMatrix();

	return 0;
}

void PlanarWrap::createMapping(vector<SubObject  *> *faces)
{
	Face *f;
	int num_verts;
	Matrix44 m;
	Vector4 uv;
	Vector4 pt;	
	Vector4 pt2;
	Vector4 pt3;
	
	getCompleteMatrix( &m );
	m.Invert();
	
	for(int i=0; i<(int)faces->size(); i++){
		f = static_cast<Face *>( (*faces)[i] );
		num_verts = f->getNumVerts();
		for(int j=0; j<num_verts; j++){
			//transform the point into the planes space.
      f -> getVertPtr(j) -> getPosition( &pt2 );
			f -> getVertPtr(j) -> getTransformedPosition( &pt);
			f -> getUVPtr(j) -> getPosition( &pt3 );
			pt = m * pt;
			
			
			uv.x = pt.x;
			uv.y = - pt.z;
			
			uv.x /= m_scale.x;
			uv.y /= m_scale.z;
			
			f -> setUVCoord(j, uv);
		}
				
	}

}
