/***************************************************************************
                          psplinedlg.cpp  -  description
                             -------------------
    begin                : Wed Nov 7 2001
    copyright            : (C) 2001 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "psplinedlg.h"
#include <Entities/spline.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qmultilineedit.h>
#include <qlistbox.h>
#include <qvalidator.h>
#include <cassert>

PSplineDlg::PSplineDlg( QWidget* parent, const char* name, bool modal, WFlags fl )
      : IPSplineDlg( parent, name, modal, fl )
{
   QDoubleValidator * d = new QDoubleValidator( this );

   fldPX -> setValidator( d );
   fldPY -> setValidator( d );
   fldPZ -> setValidator( d );
   fldRX -> setValidator( d );
   fldRY -> setValidator( d );
   fldRZ -> setValidator( d );


}

/*
 *  Destroys the object and frees any allocated resources
 */
PSplineDlg::~PSplineDlg()
{
   // no need to delete child widgets, Qt does it all for us
}

/*
 * public slot
 */
void PSplineDlg::slotApply()
{
   accept();
}

/*
 * public slot
 */
void PSplineDlg::slotAccept()
{
   accept();
}

void PSplineDlg::setEnableAll( bool b )
{
   fldPX -> setEnabled( b );
   fldPY -> setEnabled( b );
   fldPZ -> setEnabled( b );
   fldRX -> setEnabled( b );
   fldRY -> setEnabled( b );
   fldRZ -> setEnabled( b );

   fldNotes -> setEnabled( b );
   fldName -> setEnabled( b );
   lstData -> setEnabled( b );

}

void PSplineDlg::setSpline( Spline * m )
{
   assert( m );
   Vector4 v = m -> getPosition();
   //set up the position.
   QString s;
   s.setNum( v.x );
   fldPX -> setText( s );
   s.setNum( v.y );
   fldPY -> setText( s );
   s.setNum( v.z );
   fldPZ -> setText( s );

   //set up the orientation.
   v = m -> getOrientation() . getEuler();
   s.setNum( v.x );
   fldRX -> setText( s );
   s.setNum( v.y );
   fldRY -> setText( s );
   s.setNum( v.z );
   fldRZ -> setText( s );

   //set up the name and notes.
   fldName -> setText( m -> getName() . c_str() );
   fldNotes -> setText( m -> getNotes() . c_str() );


   //list all the  data attached to the mesh.
   IDataMap *data = m -> getAllData();
   lstData -> clear();

   IDataMap::iterator it = data -> begin();

   while ( it != data -> end() )
   {
      IData * d = static_cast<IData *>( it -> second );
      lstData -> insertItem( d -> getTag() . c_str() );
      ++it;
   }


}

string PSplineDlg::getName()
{
   return fldName -> text() . ascii();
}

string PSplineDlg::getNotes()
{
   return fldNotes -> text() . ascii();
}

Vector4 PSplineDlg::getPosition()
{
   Vector4 v;

   v.x = atof( fldPX -> text() . ascii() );
   v.y = atof( fldPY -> text() . ascii() );
   v.z = atof( fldPZ -> text() . ascii() );

   v.w = 1;
   return v;

}

Quat PSplineDlg::getOrientation()
{
   Vector4 v;
   Quat q;
   v.x = atof( fldRX -> text() . ascii() );
   v.y = atof( fldRY -> text() . ascii() );
   v.z = atof( fldRZ -> text() . ascii() );

   v.w = 1;

   q.setEuler( v );

   return q;

}
