/***************************************************************************
                         primitiveecreator.cpp  -  description
                            -------------------
   begin                : Thu Apr 19 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "primitivecreator.h"
#include <Entities/primitive.h>
#include <i3d.h>
#include <i3dworkspace.h>
#include "cprimitivedlg.h"
#include "vertexmodifier.h"

int PrimitiveCreator::TYPE = IControl::getUID();

PrimitiveCreator::PrimitiveCreator()
{
   setName( "&Primitive..." );
   m_popup -> insertItem( "&Points", this, SLOT( slotCreatePoints() ) );
   m_popup -> insertItem( "&Triangles", this, SLOT( slotCreateTriangles() ) );
   m_popup -> insertItem( "&Quads", this, SLOT( slotCreateQuads() ) );
   m_popup -> insertItem( "T&riangle Strip", this, SLOT( slotCreateTStrip() ) );
   m_popup -> insertItem( "Q&uad Strip", this, SLOT( slotCreateQStrip() ) );
	 m_popup -> insertItem( "&Custom", this, SLOT( slotCreateCustom() ) );
   m_primitive = 0;
   m_new_mesh = false;
}

PrimitiveCreator::~PrimitiveCreator()
{
}


void PrimitiveCreator::mousePress ( Vector4 &plane, Vector4 &pt, int btn )
{
   if ( m_primitive != 0 )
   {
      cerr << "Extending primitive" << endl;

      if ( m_primitive -> getMesh() -> numVerts() == 0 )
      {

         TransactionCommand * c = new TransactionCommand();
         if( m_new_mesh )
         {
	         Command *dbc = new DBCommand( m_primitive -> getMesh(), ADD );
  	       dbc -> execute();
	         c -> addCommand( dbc );
  	     }

         Command *pc = new CheckPointCmd( m_primitive -> getMesh() );
         m_primitive -> extend( pt );

         c -> addCommand( pc );
         c -> save();

      }

      else
      {

         Command *c = new CheckPointCmd( m_primitive -> getMesh() );
         c->save();
         m_primitive -> extend( pt );

      }

   }

   else
   {
      cerr << "No primitive to extend." << endl;
   }

}

void PrimitiveCreator::keyEvent ( QKeyEvent *key )
{
   if ( key->key() == Key_Space )
   {
      //m_primitive = 0;
      I3D::getWorkspace() -> revertControl();
   }

   setStatusDone();
}

void PrimitiveCreator::activate()
{
   /* First, activate the vertex modifier, so the
    * verts will get rendered, and we'll be in vertex
    * mode when we are done.
    */ 
   //   --
   I3D::activateControl( VertexModifier::TYPE );
   I3D::setModeMsg( " Create Mode " );
   I3D::getWorkspace() -> setCurrentControl( this );

}

void PrimitiveCreator::deactivate()
{

   if ( m_primitive != 0 && m_primitive -> getMesh() -> numVerts() == 0 )
   {
			if( m_new_mesh )
	      delete m_primitive -> getMesh();
	    delete m_primitive;
   } else
   {
      m_primitive -> terminate();
   }
}

void PrimitiveCreator::slotCreatePoints()
{

   activate();
   m_primitive = new Primitive( Primitive::POINTS );
   m_primitive -> setMesh( new Mesh() );
   m_new_mesh = true;
   setStatus( "Creating points:  Click to add pts. Space to Quit" );

}

void PrimitiveCreator::slotCreateTriangles()
{

   activate();
   m_primitive = new Primitive( Primitive::TRIANGLES );
   m_primitive -> setMesh( new Mesh() );
   m_new_mesh = true;
   setStatus( "Creating triangles:  Click to add pts. Space to Quit" );
}

void PrimitiveCreator::slotCreateQuads()
{

   activate();
   m_primitive = new Primitive( Primitive::QUADS );
   m_primitive -> setMesh( new Mesh() );
   m_new_mesh = true;
   setStatus( "Creating quads:  Click to add pts. Space to Quit" );
}

void PrimitiveCreator::slotCreateTStrip()
{

   activate();
   m_primitive = new Primitive( Primitive::TRISTRIP );
   m_primitive -> setMesh( new Mesh() );
   m_new_mesh = true;
   setStatus( "Creating triangle strip:  Click to add pts. Space to Quit" );
}

void PrimitiveCreator::slotCreateQStrip()
{

   activate();
   m_primitive = new Primitive( Primitive::QUADSTRIP );
   m_primitive -> setMesh( new Mesh() );
   m_new_mesh = true;
   setStatus( "Creating quad strip:  Click to add pts. Space to Quit" );
}

void PrimitiveCreator::slotCreateCustom()
{
	activate();
	CPrimitiveDlg *dlg = new CPrimitiveDlg( 0, "Create Custome Primitive", true );
  if ( dlg -> exec() )
  {
		Mesh *m = dlg -> getMesh();
		if( m == 0 )
			m = new Mesh();
	
		addToMesh( dlg->getType(), m );
					
		m_new_mesh = false;
		setStatus( "Adding ... to mesh ..." );
	}
	
}

void PrimitiveCreator::addToMesh( int i, Mesh *m )
{
		switch( i )
		{
			case 0:
				m_primitive = new Primitive( Primitive::POINTS );
				break;
			case 1:
				m_primitive = new Primitive( Primitive::TRIANGLES );
				break;
			case 2:
				m_primitive = new Primitive( Primitive::QUADS );
				break;
			case 3:
				m_primitive = new Primitive( Primitive::TRISTRIP );
				break;
			case 4:
				m_primitive = new Primitive( Primitive::QUADSTRIP );
				break;
			default:
				m_primitive = new Primitive( Primitive::TRIANGLES );
				break;
		}
		
		m_primitive -> setMesh( m );
		
		setStatus( "Adding to mesh, hit SPACE to quit." );
		
}

