/***************************************************************************
                         objectmodifier.h  -  description
                            -------------------
   begin                : Sun Apr 22 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef OBJECTMODIFIER_H
#define OBJECTMODIFIER_H

#include "modifier.h"
#include <string>

class Mesh;

/**
  *@author Jon Anderson
  */

class ObjectModifier : public Modifier
{
      Q_OBJECT

   public:
      ObjectModifier( char * desc, int type );
      virtual ~ObjectModifier();

      virtual void copy();
      virtual void paste();
      virtual void cut();
      virtual void keyEvent( QKeyEvent * );

      virtual void startTransform();
      virtual void endTransform();


   public slots:
      void slotUnhideAll();
      void slotUnhideByType();
      void slotHideSelected();
      void slotToggleLocalAxis();

      void slotSetVisGroup( int );
      void slotResetVisGroup();
      void slotResetAllVisGroups();

      void slotSetVisGroupState( int group, bool state);

      void slotAnimatable();
      void slotStatic();
   private:
      string m_types;

      int menu_axis;
};

#endif
