/***************************************************************************
                         modetoolbar.cpp  -  description
                            -------------------
   begin                : Mon Apr 16 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "modetoolbar.h"
#include <qpixmap.h>
#include <Xpm/select.xpm>
#include <Xpm/rotate.xpm>
#include <Xpm/move.xpm>
#include <Xpm/scale_free.xpm>
#include <Xpm/scale_uniform.xpm>

#include <Xpm/x.xpm>
#include <Xpm/y.xpm>
#include <Xpm/z.xpm>
#include <Xpm/n.xpm>
#include <Xpm/na.xpm>
#include <stdlib.h>
#include <iostream>
#include <assert.h>

ModeToolbar * ModeToolbar::m_instance = 0;

ModeToolbar * ModeToolbar::getInstance()
{
   if ( m_instance == 0 )
   {
      cerr << "Creating mode bar." << endl;
      m_instance = new ModeToolbar();
   }

   return m_instance;
}
ModeToolbar::ModeToolbar() : QObject()
{
}

void ModeToolbar::init( QToolBar *b )
{

   m_toolbar = b;
   m_group = new QButtonGroup();
   m_normal_group = new QButtonGroup();

   m_group -> setExclusive( true );
   QToolButton *btn;

   btn = new QToolButton( QPixmap( ( const char ** ) ::select_xpm ),
                          "Select",
                          "",
                          0,
                          0 ,
                          m_toolbar );
   btn -> setToggleButton( true );
   btn -> toggle();

#if (QT_VERSION > 300)
  btn -> setAccel( QKeySequence( Qt::UNICODE_ACCEL + I3D::getConfig()->getLowerChar("FlatKeyCommands", "select_mode", "A" )) );
#else
  btn -> setAccel( (QChar)I3D::getConfig()->getLowerChar("FlatKeyCommands", "select_mode", "A" ) );
#endif

   m_group -> insert( btn, MODE_SELECT );

   btn = new QToolButton( QPixmap( ( const char ** ) ::rotate_xpm ),
                          "Rotate",
                          "",
                          0,
                          0,
                          m_toolbar );
   btn->setToggleButton( true );

#if (QT_VERSION > 300)
  btn -> setAccel( QKeySequence( Qt::UNICODE_ACCEL + I3D::getConfig()->getLowerChar("FlatKeyCommands", "rotate_mode", "S" )) );
#else
  btn -> setAccel( (QChar)I3D::getConfig()->getLowerChar("FlatKeyCommands", "rotate_mode", "S" ) );
#endif


   m_group -> insert( btn, MODE_ROTATE );

   btn = new QToolButton( QPixmap( ( const char ** ) ::move_xpm ),
                          "Move",
                          "",
                          0,
                          0,
                          m_toolbar );
   btn -> setToggleButton( true );

#if (QT_VERSION > 300)
  btn -> setAccel( QKeySequence( Qt::UNICODE_ACCEL + I3D::getConfig()->getLowerChar("FlatKeyCommands", "move_mode", "D" )) );
#else
  btn -> setAccel( (QChar)I3D::getConfig()->getLowerChar("FlatKeyCommands", "move_mode", "D" ) );
#endif

   m_group -> insert( btn, MODE_MOVE );

   btn = new QToolButton( QPixmap( ( const char ** ) ::scale_free_xpm ),
                          "Scale freely",
                          "",
                          0,
                          0,
                          m_toolbar );


   btn -> setToggleButton( true );

#if (QT_VERSION > 300)
  btn -> setAccel( QKeySequence( Qt::UNICODE_ACCEL + I3D::getConfig()->getLowerChar("FlatKeyCommands", "scale_mode", "F" ) ) );
#else
  btn -> setAccel( (QChar)I3D::getConfig()->getLowerChar("FlatKeyCommands", "scale_mode", "F" ) );
#endif

   m_group -> insert( btn, MODE_SCALE_FREE );

   btn = new QToolButton( QPixmap( ( const char ** ) ::scale_uniform_xpm ),
                          "Scale Uniform",
                          "",
                          0,
                          0,
                          m_toolbar );


   btn -> setToggleButton( true );


#if (QT_VERSION > 300)
  btn -> setAccel(  QKeySequence( Qt::UNICODE_ACCEL + I3D::getConfig()->getLowerChar("FlatKeyCommands", "scale_uniform_mode", "G" )) );
#else
  btn -> setAccel( (QChar)I3D::getConfig()->getLowerChar("FlatKeyCommands", "scale_uniform_mode", "G" ) );
#endif

   m_group -> insert( btn, MODE_SCALE_UNIFORM );


   m_toolbar -> addSeparator();

   btnX = new QToolButton( QPixmap( ( const char ** ) ::x_xpm ),
                           "X Axis",
                           "",
                           0,
                           0,
                           m_toolbar );
   btnX -> setToggleButton( true );
   btnX -> toggle();

   btnY = new QToolButton( QPixmap( ( const char ** ) ::y_xpm ),
                           "Y Axis",
                           "",
                           0,
                           0,
                           m_toolbar );
   btnY -> setToggleButton( true );
   btnY -> toggle();

   btnZ = new QToolButton( QPixmap( ( const char ** ) ::z_xpm ),
                           "Z Axis",
                           "",
                           0,
                           0,
                           m_toolbar );
   btnZ -> setToggleButton( true );
   btnZ -> toggle();

   m_toolbar -> addSeparator();

   btnN = new QToolButton( QPixmap( ( const char ** ) ::n_mode ),
                           "Individual Normal Axis",
                           "",
                           0,
                           0,
                           m_toolbar );

   btnN -> setToggleButton( true );
   m_normal_group -> insert( btnN, NORMAL_MODE );

   btnNa = new QToolButton( QPixmap( ( const char ** ) ::na_mode ),
                           "Average Normal Axis",
                           "",
                           0,
                           0,
                           m_toolbar );

   btnNa -> setToggleButton( true );

   m_normal_group -> insert( btnNa, AVERAGE_NORMAL_MODE );


   m_toolbar -> addSeparator();


   m_mode = new QComboBox ( m_toolbar );

   m_mode -> insertItem( "Single Select" );
   m_mode -> insertItem( "Multi Select" );

   m_group -> setButton( MODE_SELECT );
   m_mouse_mode = MODE_SELECT;
   connect( m_group, SIGNAL( clicked( int ) ), this, SLOT( select( int ) ) );
   connect( m_normal_group, SIGNAL( clicked(int) ), this, SLOT( normalMode( int ) ) );

}

ModeToolbar::~ModeToolbar()
{
}

void ModeToolbar::select( int i )
{
   cerr << "Setting mode=" << i << endl;
   m_mouse_mode = i;
}

void ModeToolbar::normalMode( int i )
{
  if ( i == NORMAL_MODE )
    btnNa -> setOn( false );

  if ( i == AVERAGE_NORMAL_MODE )
    btnN -> setOn( false );

}

bool ModeToolbar::isMultipleSelect()
{

   ModeToolbar * t = getInstance();
   assert( t );

   return !( t -> m_mode -> currentItem() == 0 );

}

int ModeToolbar::getMode()
{
   ModeToolbar * t = getInstance();
   assert( t );

   return t -> m_mouse_mode;
   /*
   ModeToolbar *t = getInstance();
   assert( t );

   QButton *b = t->m_group->selected();
   if( b == 0 ) {
     cerr << "null button selected"<<endl;
      return -1;
}

   return t -> m_group -> id( t->m_group->selected() );
   */
}

Vector4 & ModeToolbar::getAxis()
{

   ModeToolbar * t = getInstance();
   assert( t );

   t -> m_axis.assign( 0, 0, 0, 1 );

   if ( t -> btnX -> isOn() )
      t -> m_axis.x = 1;

   if ( t -> btnY -> isOn() )
      t -> m_axis.y = 1;

   if ( t -> btnZ -> isOn() )
      t -> m_axis.z = 1;

   return t -> m_axis;
}

void ModeToolbar::setNormalAxis( Vector4 & v)
{
   ModeToolbar * t = getInstance();
   assert( t );

   if ( v.x != 0 )
      t -> btnN -> setOn( true );

   if ( v.y != 0 )
      t -> btnNa -> setOn( true );

}
void ModeToolbar::toggleNormalAxis( Vector4 & v)
{

   ModeToolbar * t = getInstance();
   assert( t );

   if ( v.x != 0 )
      t -> btnN -> toggle( );

   if ( v.y != 0 )
      t -> btnNa -> toggle( );

}

Vector4 & ModeToolbar::getNormalAxis( Vector4 & v)
{

   ModeToolbar * t = getInstance();
   assert( t );

   t -> m_normal_axis.assign( -1, -1, -1, -1 );

   if ( t -> btnN -> isOn() )
      t -> m_normal_axis.x = 1;

   if ( t -> btnNa -> isOn() )
      t -> m_normal_axis.y = 1;


   return t -> m_normal_axis;
}


void ModeToolbar::setMode( int i )
{

   ModeToolbar * t = getInstance();
   assert( t );

   t -> select( i );
   t -> m_group -> setButton( i );

}

void ModeToolbar::setMultipleSelect( bool b )
{
   ModeToolbar * t = getInstance();
   assert( t );

   if ( b )
      t -> m_mode -> setCurrentItem( 1 );
   else
      t -> m_mode -> setCurrentItem( 0 );

}

void ModeToolbar::setAxis( Vector4 &v )
{
   ModeToolbar * t = getInstance();
   assert( t );

   if ( v.x != 0 )
      t -> btnX -> setOn( true );

   if ( v.y != 0 )
      t -> btnY -> setOn( true );

   if ( v.z != 0 )
      t -> btnZ -> setOn( true );

}

void ModeToolbar::toggleMultipleSelect( )
{
   setMultipleSelect( ! ModeToolbar::isMultipleSelect() );
}

void ModeToolbar::toggleAxis( Vector4 &v )
{
   ModeToolbar * t = getInstance();
   assert( t );

   if ( v.x != 0 )
      t -> btnX -> toggle( );

   if ( v.y != 0 )
      t -> btnY -> toggle( );

   if ( v.z != 0 )
      t -> btnZ -> toggle( );


}


