#include "cprimitivedlg.h"
#include <objectdb.h>
#include <Entities/mesh.h>
#include <qcombobox.h>
/* 
 *  Constructs a CPrimitiveDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
CPrimitiveDlg::CPrimitiveDlg( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : ICPrimitiveDlg( parent, name, modal, fl )
{
	m_meshes = ObjectDB::getInstance() -> getSelectables( Mesh::TYPE );
	
	for(int i=0; i< (int) m_meshes->size(); i++ )
	{
		Mesh * m = static_cast<Mesh *>( (*m_meshes)[i] );
		chMesh -> insertItem(m->getName().c_str() );
	}
}

/*  
 *  Destroys the object and frees any allocated resources
 */
CPrimitiveDlg::~CPrimitiveDlg()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void CPrimitiveDlg::slotParentChanged(int)
{
    qWarning( "CPrimitiveDlg::slotParentChanged(int) not yet implemented!" ); 
}
/* 
 * public slot
 */
void CPrimitiveDlg::slotTypeChanged(int)
{
    qWarning( "CPrimitiveDlg::slotTypeChanged(int) not yet implemented!" ); 
}

Mesh * CPrimitiveDlg::getMesh()
{
	int i = chMesh -> currentItem();
	if(i==0)
		return 0;
		
	return static_cast< Mesh *>(  (*m_meshes)[i-1] );	
}
int CPrimitiveDlg::getType()
{
	return chType -> currentItem();
}
