/***************************************************************************
                         bonecreator.cpp  -  description
                            -------------------
   begin                : Sun Apr 22 2001
   copyright            : (C) 2001 by Jon Anderson
   email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "bonecreator.h"
#include <Entities/bone.h>

#include <i3d.h>
#include <i3dworkspace.h>
#include "cbonedlg.h"
#include "bonemodifier.h"

int BoneCreator::TYPE = IControl::getUID();

BoneCreator::BoneCreator() : Creator()
{

   setName( "&Bone..." );
   m_popup -> insertItem( "Skeleton", this, SLOT( slotCreateSkeleton() ) );

   m_popup -> insertItem( "Root Bone", this, SLOT( slotCreateRoot() ) );
   m_popup -> insertItem( "Ball Bone", this, SLOT( slotCreateBall() ) );
   m_popup -> insertItem( "XY Bone", this, SLOT( slotCreateXY() ) );
   m_popup -> insertItem( "XZ Bone", this, SLOT( slotCreateXZ() ) );
   m_popup -> insertItem( "YZ Bone", this, SLOT( slotCreateYZ() ) );
   m_popup -> insertItem( "Custom Bone", this, SLOT( slotCreateCustom() ) );

   m_parent = 0;
   m_bone = 0;
   m_last_click = 0;
   m_skeleton = false;
}

BoneCreator::~BoneCreator()
{
}

void BoneCreator::mousePress ( Vector4 &plane, Vector4 &pt, int )
{

   if( m_skeleton )
   {
      extendSkeleton( pt );
      return;
   }
   if ( m_bone != 0 )
   {
      cerr << "Inserting bone" << endl;
      //insert the mesh and move to the given point.
      Command *c = new DBCommand( m_bone, ADD );
      c->execute();
      c->save();

      m_bone -> move( pt.x, pt.y, pt.z );

      //reset
      m_bone = 0;
      setStatusDone();
      I3D::getWorkspace() -> revertControl();
      updateViews();
   }

   else
   {
      cerr << "No bone to insert" << endl;
   }
}

void BoneCreator::extendSkeleton( Vector4 &pt )
{
   //first click in the chain...
   if( m_last_click == 0 )
   {
      m_last_click = new Vector4();
      *m_last_click = pt;
      return;
   }

   Bone * b;

   if( m_parent != 0 )
   {
      Matrix44 m;
      m_parent -> getEffectorMatrix( &m );
      m.Invert();
      pt = m * pt;
      b = new Bone( m_parent, pt );
   } else
   {
      Vector4 diff;
      diff = pt - *m_last_click;
      b = new Bone( 0, diff );
   }

   if( m_parent == 0 )
      b -> move( m_last_click->x, m_last_click->y, m_last_click->z );

   *m_last_click = pt;

   //this bone is now the next's parent;
   m_parent = b;
   Command *c = new DBCommand( b, ADD );
   c -> execute();
   c -> save();

}

void BoneCreator::keyEvent ( QKeyEvent * )
{
   setStatusDone();
   I3D::getWorkspace() -> revertControl();
}

void BoneCreator::activate()
{
   //first activate the BoneModifier, so when we are done
   //we'll be in bone mode.
   I3D::activateControl( BoneModifier::TYPE );
   I3D::setModeMsg( " Create Mode " );
   I3D::getWorkspace() -> setCurrentControl( this );
}

void BoneCreator::deactivate()
{
   /* User skipped out before actually adding the bone
    */

   if ( m_bone != 0 )
      delete m_bone;

   if( m_last_click != 0)
      delete m_last_click;

}

void BoneCreator::slotCreateRoot()
{
   activate();
   m_bone = new Bone( 0, 1 );
   m_bone -> setXRot( 0, 0 );
   m_bone -> setYRot( 0, 0 );
   m_bone -> setZRot( 0, 0 );

   setStatus( "Creating Root Bone: Click to create Bone." );

}

void BoneCreator::slotCreateBall()
{
   activate();
   m_bone = new Bone( 0, 1 );
   m_bone -> setXRot( -90, 90 );
   m_bone -> setYRot( 0, 0 );
   m_bone -> setZRot( -90, 90 );

   setStatus( "Creating Ball Bone: Click to create Bone." );

}

void BoneCreator::slotCreateXY()
{
   activate();
   m_bone = new Bone( 0, 1 );
   m_bone -> setXRot( 0, 0 );
   m_bone -> setYRot( 0, 0 );
   m_bone -> setZRot( -90, 90 );

   setStatus( "Creating XY Bone: Click to create Bone." );

}

void BoneCreator::slotCreateXZ()
{
   activate();
   m_bone = new Bone( 0, 1 );
   m_bone -> setXRot( 0, 0 );
   m_bone -> setYRot( -90, 90 );
   m_bone -> setZRot( 0, 0 );

   setStatus( "Creating XZ Bone: Click to create Bone." );

}

void BoneCreator::slotCreateYZ()
{
   activate();
   m_bone = new Bone( 0, 1 );
   m_bone -> setXRot( -90, 90 );
   m_bone -> setYRot( 0, 0 );
   m_bone -> setZRot( 0, 0 );

   setStatus( "Creating YZ Bone: Click to create Bone." );

}

void BoneCreator::slotCreateCustom()
{
   activate();
   setStatus( "Creating a custom bone: Click to create Bone." );

   /* Popup custom dialog here.
    */
   CBoneDlg *dlg = new CBoneDlg( 0, "Create Custom Bone", true );
   m_bone = new Bone( 0, 1 );

   dlg -> setName( m_bone -> getName() );
   dlg -> setNotes( m_bone -> getNotes() );

   if ( dlg -> exec() )
   {

     // m_bone = new Bone( 0, dlg->getLength() );
      m_bone -> setXRot( dlg->getA(), dlg->getB() );
      m_bone -> setYRot( dlg->getC(), dlg->getD() );
      m_bone -> setZRot( dlg->getE(), dlg->getF() );

      m_bone -> setStiffness( dlg->getStiffness() );

      m_bone -> setName( dlg->getName().ascii() );
      m_bone -> setNotes( dlg->getNotes().ascii() );

   }

   else
   {
      I3D::getWorkspace() -> revertControl();
      updateViews();
      setStatusDone();
   }

   delete dlg;
}

void BoneCreator::slotCreateSkeleton()
{
   activate();
   m_skeleton = true;
}

