//
// (c) Polar Pyramid                                                                                                             
// suggestions to stolken@kabelfoon.nl and/or stolk@xs4all.nl
//


// Description:
//	The Quat class represents a quaternion useful for encoding rotations/orientations
//
//      

#ifndef QUAT_H
#define QUAT_H

#include "vector3.h"
#include "vector4.h"

class Quat
{
public:
  // the quaterion data 
       
  Vector3              v;    // imaginary part
  float                w;    // real part

  // constructors

  Quat();
  Quat(const Quat &);
  Quat(float qw, const Vector3 &qv);
  Quat(const Vector3 &axis, float angle);
  Quat(float x, float y, float z, float w);
  Quat(const Vector4 &q);
  // array access

  float& operator [] (int);
  const float& operator [] (int) const;

  // Member Functions

  float             Real(void) const;
  float             X(void) const;
  float             Y(void) const;
  float             Z(void) const;
  Vector3           Imaginary(void) const;
  float            Abs(void) const;
  void              Conj(void);
  Quat              Inverse(void) const;
  void              Normalize(void);
  float            Magnitude(void) const;
  void              InsertInMatrix(float [4][4]) const;
  Vector3           GetXAxis(void) const;
  Vector3           GetYAxis(void) const;
  Vector3           GetZAxis(void) const;
  Vector4           getVector(void) const;
  Vector4           getEuler(void) const;
  Vector4 				  getAxisAngle(void) const;
  void              setEuler(Vector4 &);
  //
  // Operators
  //

  Quat operator - () const;

  Quat &operator += (const Quat &q);
  Quat &operator -= (const Quat &q);
  Quat &operator *= (const Quat &q);
  Quat &operator /= (const Quat &q);
  Quat &operator ^= (const Quat &q);
	
  Quat &operator *= (float c);
  Quat &operator /= (float c);

  Quat operator * (float) const;
  Quat operator / (float) const;

  bool operator == (const Quat& q) const;
  bool operator != (const Quat& q) const;

  // friends

  friend Quat operator * (float d, const Quat &q1);
  friend Quat Square(const Quat&);
  friend Quat Exp(const Quat&);
  friend Quat Log(const Quat&);
  friend Quat Interpolate(const Quat&,
			  const Quat&,
			  float t);

  void Dump(void) const;
};


inline const Quat operator+(const Quat &lhs, const Quat &rhs)
{
  return Quat(lhs) += rhs;
}

inline const Quat operator-(const Quat &lhs, const Quat &rhs)
{
  return Quat(lhs) -= rhs;
}

inline const Quat operator*(const Quat &lhs, const Quat &rhs)
{
  return Quat(lhs) *= rhs;
}

inline const Quat operator/(const Quat &lhs, const Quat &rhs)
{
  return Quat(lhs) /= rhs;
}

inline const Quat operator^(const Quat &lhs, const Quat &rhs)
{
  return Quat(lhs) ^= rhs;
}





#endif







