#include "configdlg.h"
#include <qfiledialog.h>
#include <i3d.h>
#include <config.h>
#include <i3dworkspace.h>

/* 
 *  Constructs a ConfigDlg which is a child of 'parent', with the 
 *  name 'name' and widget flags set to 'f' 
 *
 *  The dialog will by default be modeless, unless you set 'modal' to
 *  TRUE to construct a modal dialog.
 */
ConfigDlg::ConfigDlg( QWidget* parent,  const char* name, bool modal, WFlags fl )
    : IConfig( parent, name, modal, fl )
{
}

/*  
 *  Destroys the object and frees any allocated resources
 */
ConfigDlg::~ConfigDlg()
{
    // no need to delete child widgets, Qt does it all for us
}

/* 
 * public slot
 */
void ConfigDlg::slotCancel()
{
    reject();
}
/* 
 * public slot
 */
void ConfigDlg::slotApply()
{
  save();
  I3D::getWorkspace() -> refreshOptions();
  I3D::getInstance() -> saveConfig();
  I3D::updateViews();
}
/* 
 * public slot
 */
void ConfigDlg::slotChangePluginPath()
{
	QString ndir = QFileDialog::getExistingDirectory( fldPluginPath -> text() );

  if(ndir.isEmpty())
  	return;
  	
  fldPluginPath -> setText(ndir);

}
/* 
 * public slot
 */
void ConfigDlg::slotChangeScenePath()
{
 	QString ndir = QFileDialog::getExistingDirectory( fldScenePath -> text() );

  if(ndir.isEmpty())
  	return;
  	
  fldScenePath -> setText(ndir);

}
/* 
 * public slot
 */
void ConfigDlg::slotChangeTexturePath()
{
	QString ndir = QFileDialog::getExistingDirectory( fldTexturePath -> text() );

  if(ndir.isEmpty())
  	return;
  	
  fldTexturePath -> setText(ndir);

}
/* 
 * public slot
 */
void ConfigDlg::slotOK()
{
  slotApply();
  accept();
}

void ConfigDlg::load()
{
  Config *cfg = I3D::getConfig();

  cfg -> setSection( "Directories" );
  setPluginPath( cfg -> getString( "Plugins" ) );
  setScenePath ( cfg -> getString( "Scenes"  ) );
  setTexturePath(cfg -> getString( "Textures") );

  cfg -> setSection( "Display" );
  spnGridSize -> setValue( cfg -> getInt( "GridSize" ) );
  spnGridSpacing -> setValue( cfg -> getInt( "GridSpacing" ) );

  chWireframeMove -> setChecked( cfg -> getBool( "MoveWireframe" ) );
  ch3DWireframe   -> setChecked( cfg -> getBool( "3DWireframe"   ) );
  ch2DWireframe   -> setChecked( cfg -> getBool( "2DWireframe"   ) );
  chSmoothShading -> setChecked( cfg -> getBool( "SmoothShading" ) );


}

void ConfigDlg::save()
{
  Config *cfg = I3D::getConfig();

  cfg -> setSection( "Directories" );
  cfg -> setString( "Plugins", getPluginPath() );
  cfg -> setString( "Scenes", getScenePath() );
  cfg -> setString( "Textures", getTexturePath() );

  cfg -> setSection( "Display" );
  cfg -> setInt( "GridSize", getGridSize() );
  cfg -> setInt( "GridSpacing", getGridSpacing() );

  cfg -> setBool( "MoveWireframe", chWireframeMove -> isChecked() );
  cfg -> setBool( "3DWireframe",   ch3DWireframe   -> isChecked() );
  cfg -> setBool( "2DWireframe",   ch2DWireframe   -> isChecked() );
  cfg -> setBool( "SmoothShading", chSmoothShading -> isChecked() );

}
