/***************************************************************************
                        uvcoord.h  -  description
                           -------------------
  begin                : Wed May 31 2000
  copyright            : (C) 2000 by Jon Anderson
  email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef UVCOORD_H
#define UVCOORD_H

#include "subobject.h"

/**
  *@author Jon Anderson
  */

class UVCoord : public SubObject
{

public:
   UVCoord( Object *o );
   UVCoord( Vector4 &p, Object *o );

   ~UVCoord();

   UVCoord & operator=( UVCoord &rhs );
   void copyFrom( SubObject * );

   virtual int draw( int d_options )
   {
      return 0;
   };

   void getTransformedPosition( Vector4 *v );
   static int TYPE;

   void setPosition( float x, float y, float z )
   {
      pos.assign( x, y, z, 1 );
   };

   void setPosition( Vector4 &p )
   {
      pos = p;
   };

   Vector4 & getPosition()
   {
      return pos;
   };

   void getPosition( Vector4 * v )
   {
      *v = pos;
   };

   void move( float x, float y, float z )
   {
      pos.x += x;
      pos.y += y;
      pos.z += z ;
   };


   void getBoundingMin( Vector4 *v );
   void getBoundingMax( Vector4 *v );

protected:
   Vector4 pos;

};

#endif
