/***************************************************************************
                       uvcoord.cpp  -  description
                          -------------------
 begin                : Wed May 31 2000
 copyright            : (C) 2000 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "uvcoord.h"

int UVCoord::TYPE = Typed::getUID();

UVCoord::UVCoord( Object *o ) :
    SubObject( o ), pos( 0, 0, 0, 1 )
{
  addType( TYPE );
}

UVCoord::UVCoord( Vector4 &p, Object *o ) : SubObject( o ), pos( p )
{
  addType( TYPE );
}

UVCoord::~UVCoord()
{}

void UVCoord::getBoundingMin( Vector4 *v )
{
  *v = pos;
}

void UVCoord::getBoundingMax( Vector4 *v )
{
  *v = pos;
}

//need to copy the controller inorder for it to be animatable.
UVCoord & UVCoord::operator=( UVCoord &rhs )
{
  SubObject::operator=( rhs );

  pos = rhs.pos;

  return *this;

}

void UVCoord::copyFrom( SubObject *s )
{
  *this = * static_cast < UVCoord * > ( s );
}

/** UVCoords are 'displayed' normalized, so the transformed position
 * is this normalized position
 */
void UVCoord::getTransformedPosition( Vector4 *v )
{
  //conversion from float to int truncates...
  int urepeat = ( int ) ( pos.x + 1 );
  int vrepeat = ( int ) ( pos.y + 1 );

  v->assign( pos.x - urepeat, pos.y - vrepeat, 0, 1 );

}
