/***************************************************************************
                       texturematerial.cpp  -  description
                          -------------------
 begin                : Wed Jan 19 2000
 copyright            : (C) 2000 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "texturematerial.h"
#include <GL/gl.h>
#include "entity.h"
#include "materialparser.h"

int mat_num = 0;

int TextureMaterial::TYPE = Typed::getUID();
int MaterialParser::TYPE = Parser::setParser( TextureMaterial::TYPE, "material", new MaterialParser() );

TextureMaterial::TextureMaterial() : Typed(),
    cAmbient( 128, 128, 128 ),
    cDiffuse( 255, 255, 255 ),
    cEmission( 0, 0, 0 ),
    cSpecular( 0, 0, 0 ),
    name( "Material_" + QString().setNum( mat_num ) )
{
  shininess = 50;
  alpha = 255;
  texture = 0;
  opacity = 0;
  specularity = 0;
  displacement = 0;

  m_selected = false;

  enable_texture = false;
  //increment material counter
  mat_num++;
}

TextureMaterial::~TextureMaterial()
{}




void TextureMaterial::beginMaterial()
{
  GLfloat amb[] = {( float ) cAmbient.r / 255,
                   ( float ) cAmbient.g / 255,
                   ( float ) cAmbient.b / 255, ( float ) alpha / 255};

  GLfloat dif [] = {( float ) cDiffuse.r / 255,
                    ( float ) cDiffuse.g / 255,
                    ( float ) cDiffuse.b / 255, ( float ) alpha / 255};

  GLfloat spec[] = {( float ) cSpecular.r / 255,
                    ( float ) cSpecular.g / 255,
                    ( float ) cSpecular.b / 255, ( float ) alpha / 255};

  GLfloat em[] = {( float ) cEmission.r / 255,
                  ( float ) cEmission.g / 255,
                  ( float ) cEmission.b / 255, ( float ) alpha / 255};

  GLfloat sel[] = {1.0f, 0.0f, 0.0f, 1.0f};

  glDisable( GL_COLOR_MATERIAL );

  glMaterialf( GL_FRONT_AND_BACK, GL_SHININESS, shininess );

  glMaterialfv( GL_FRONT_AND_BACK, GL_AMBIENT, amb );

  glMaterialfv( GL_FRONT_AND_BACK, GL_SPECULAR, spec );

  glMaterialfv( GL_FRONT_AND_BACK, GL_EMISSION, em );


  //back facing polygons are translucent
  dif [ 3 ] = ( float ) alpha / 3;

  // glMaterialfv(GL_BACK, GL_DIFFUSE, dif);

  if ( enable_texture && texture != 0 )
  {
    glEnable( GL_TEXTURE_2D );
    glBindTexture( GL_TEXTURE_2D, texture->getID() );
  }

  //allow any calls to glColor4f inside the start/end pair to affect
  // the diffuse lighting.
  glEnable( GL_COLOR_MATERIAL );

  glColorMaterial( GL_FRONT_AND_BACK, GL_DIFFUSE );

  if ( m_selected )
    glColor4f( sel[ 0 ], sel[ 1 ], sel[ 2 ], sel[ 3 ] );
  else
    glColor4f( dif [ 0 ], dif [ 1 ], dif [ 2 ], dif [ 3 ] );


}



void TextureMaterial::endMaterial()
{
  if ( enable_texture && texture != 0 )
  {
    glDisable( GL_TEXTURE_2D );
  }

  glDisable( GL_COLOR_MATERIAL );
}

TextureMaterial & TextureMaterial::operator=( TextureMaterial &rhs )
{
  cAmbient = rhs.cAmbient;
  cDiffuse = rhs.cDiffuse;
  cEmission = rhs.cEmission;
  cSpecular = rhs.cSpecular;
  shininess = rhs.shininess;
  alpha = rhs.alpha;

  enable_texture = rhs.enable_texture;

  if ( rhs.texture != 0 )
    texture = new Texture( *( rhs.texture->getFilename() ), -1 );

  if ( rhs.specularity != 0 )
    specularity = new Texture( *( rhs.specularity->getFilename() ), -1 );

  if ( rhs.displacement != 0 )
    displacement = new Texture( *( rhs.displacement->getFilename() ), -1 );

  if ( rhs.opacity != 0 )
    opacity = new Texture( *( rhs.opacity->getFilename() ), -1 );

  return *this;
}

void TextureMaterial::write( ostream &out )
{
  out << "[material]" << endl;
  out << "[name]" << endl;
  out << name << endl;
  ;
  out << "[ambient]\n";
  out << cAmbient.r << " " << cAmbient.g << " " << cAmbient.b << endl;
  out << "[diffuse]\n";
  out << cDiffuse.r << " " << cDiffuse.g << " " << cDiffuse.b << endl;
  out << "[emission]\n";
  out << cEmission.r << " " << cEmission.g << " " << cEmission.b << endl;
  out << "[specular]\n";
  out << cSpecular.r << " " << cSpecular.g << " " << cSpecular.b << endl;
  out << "[shininess]\n";
  out << shininess << endl;
  out << "[opacity]\n";
  out << alpha << endl;

  out << "[colormap]\n";

  if ( texture != 0 )
    out << *( texture->getFilename() ) << endl;
  else
    out << "notexture" << endl;

  out << "[opacitymap]\n";

  if ( opacity != 0 )
    out << *( opacity->getFilename() ) << endl;
  else
    out << "notexture" << endl;

  out << "[specularitymap]\n";

  if ( specularity != 0 )
    out << *( specularity->getFilename() ) << endl;
  else
    out << "notexture" << endl;

  out << "[displacementmap]\n";

  if ( displacement != 0 )
    out << *( displacement->getFilename() ) << endl;
  else
    out << "notexture" << endl;


}

void TextureMaterial::read( istream &in )
{
  QString filename;
  QCString temp;
  char buffer[ 256 ];

  in >> buffer >> ws; //read in material tag;
  in >> buffer >> ws; //read in the name tag;
  in >> buffer >> ws;
  temp = buffer;
  name = temp;

  in >> buffer >> ws;
  in >> cAmbient.r >> cAmbient.g >> cAmbient.b >> ws;
  in >> buffer >> ws;
  in >> cDiffuse.r >> cDiffuse.g >> cDiffuse.b >> ws;
  in >> buffer >> ws;
  in >> cEmission.r >> cEmission.g >> cEmission.b >> ws;
  in >> buffer >> ws;
  in >> cSpecular.r >> cSpecular.g >> cSpecular.b >> ws;
  in >> buffer >> ws;
  in >> shininess >> ws;
  in >> buffer >> ws;
  in >> alpha >> ws;

  in >> buffer >> ws; //read in the tag
  in >> buffer >> ws;
  temp = buffer;
  filename = temp;

  if ( filename != "notexture" )
  {
    texture = new Texture( filename, -1 );
    enable_texture = true;
  }

  else
  {
    enable_texture = false;
  }

  in >> buffer >> ws; //read in the tag
  in >> buffer >> ws;
  temp = buffer;
  filename = temp;

  if ( filename != "notexture" )
    opacity = new Texture( filename, -1 );

  in >> buffer >> ws; //read in the tag

  in >> buffer >> ws;

  temp = buffer;

  filename = temp;

  if ( filename != "notexture" )
    specularity = new Texture( filename, -1 );

  in >> buffer >> ws; //read in the tag

  in >> buffer >> ws;

  temp = buffer;

  filename = temp;

  if ( filename != "notexture" )
    displacement = new Texture( filename, -1 );



}


void TextureMaterial::readSimple( istream &in )
{
  QString filename;
  QCString temp;
  char buffer[ 256 ];

  in >> buffer >> ws; //read in the name;
  temp = buffer;
  name = temp;

  in >> cAmbient.r >> cAmbient.g >> cAmbient.b >> ws;
  in >> cDiffuse.r >> cDiffuse.g >> cDiffuse.b >> ws;
  in >> cEmission.r >> cEmission.g >> cEmission.b >> ws;
  in >> cSpecular.r >> cSpecular.g >> cSpecular.b >> ws;
  in >> shininess >> ws;
  in >> alpha >> ws;

  in >> buffer >> ws;
  temp = buffer;
  filename = temp;

  if ( filename != "notexture" )
  {
    texture = new Texture( filename, -1 );
    enable_texture = true;
  }

  else
  {
    enable_texture = false;
  }

}


