/***************************************************************************
                       texture.cpp  -  description         
                          -------------------                           
 begin                : Wed Mar 10 1999                          
 copyright            : (C) 1999 by Jon Anderson                         
 email                : ande1514@tc.umn.edu                    
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "texture.h"
#include <config.h>
#include <i3dworkspace.h>
#include <Views/glview.h>
#include <qfileinfo.h>
#include <i3d.h>

extern "C"
{
#include "readtex.h"
}

Texture::Texture( QString s, int _index )
{

  I3D::getWorkspace() -> getSharedContext() ->makeCurrent();

  int width, height;

  index = _index;

  //set the file name
  file = new QString( s );

  QFileInfo finfo( *file );

  //if the file doesn't exist, look for it in the texture directory
  if ( !finfo.exists() )
  {
    QString name = finfo.fileName();
    QString dir = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str();
    dir.append( "/" );
    dir += name;
    file = new QString( name );
    s = dir;
  }


  //create a unique Texture ID
  glGenTextures( 1, &tex_id );

  glBindTexture( GL_TEXTURE_2D, tex_id );

  //create a new QImage...
  if ( s.right( 4 ) == ".rgb" ||
       s.right( 4 ) == ".RGB" )
    image = loadRgb( s );
  else
    image = new QImage( s );


  if ( image->isNull() )
  {
    QImage dummy( 256, 256, 32 );
    QColor c( 255, 0, 0 );
    dummy.fill( c.pixel() );
    *image = dummy;
  }

  else
  {
    *image = image->convertDepth( 32 ); // Make sure it has the right depth
    *image = image->mirror();           // OpenGL wants it upside down
    *image = image->swapRGB();          // OpenGL wants BGR
  }

  width = image->width();

  height = image->height();

  //Setup the OpenGL Texture

  //glTexImage2D(GL_TEXTURE_2D, 0, GL_RGB, width, height, 0, GL_RGB,
  //           GL_UNSIGNED_BYTE, (GLubyte *)(texture));
  //setup mipmaps..
  gluBuild2DMipmaps( GL_TEXTURE_2D, 3, width, height, GL_RGBA,
                     GL_UNSIGNED_BYTE, ( GLubyte * ) image->bits() );



  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT );
  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT );
  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR_MIPMAP_NEAREST ); //nearest
  glTexParameterf( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );  //nearest
  glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );         //MODULATE

  float pcnt = 1;
  //set up the drawing pixmap...
  if ( width > 64 )
  {
    pcnt = 64 / ( float ) width;
    width = 64;
    height = ( int ) ( ( float ) height * pcnt );
  }

  if ( height > 64 )
  {
    pcnt = 64 / ( float ) height;
    height = 64;
    width = ( int ) ( ( float ) width * pcnt );
  }

  pixmap = new QPixmap( width, height );
  pixmap->convertFromImage( image->smoothScale( width, height ) );
}

Texture::~Texture( void )
{
  glDeleteTextures( 1, &tex_id );
  delete pixmap;
  delete image;
}

Texture::Texture()
{
  pixmap = 0;
  image = 0;
  tex_id = 0;
}

QRgb Texture::getRGB( int x, int y )
{
  return image->pixel( x, y );
}

int Texture::getHeight()
{
  return image->height();
}

int Texture::getWidth()
{
  return image->width();
}

/**Loads the texture from an RGB file */
QImage * Texture::loadRgb( QString s )
{
  TK_RGBImageRec * image;
  QImage *img = new QImage();

  int components;


  image = tkRGBImageLoad( s.ascii() );

  if ( !image )
  {
    return 0;
  }

  components = image->components;
  //  cerr<<"Components="<<components<<endl;

  img->create( image->sizeX, image->sizeY, 32 );

  int bytes = image->sizeX * image->sizeY * components;

  //copy the image into the QImage
  int x = 0;
  int y = image->sizeY - 1;

  int r, g, b, a;

  for ( int i = 0; i < bytes; i += components )
  {
    r = image->data[ i ];
    QRgb pixel;

    switch ( components )
    {

      case 4:
        g = image->data[ i + 1 ];
        b = image->data[ i + 2 ];
        a = image->data[ i + 3 ];
        pixel = QRgb( qRgba( r, g, b, a ) );
        break;

      case 3:
        g = image->data[ i + 1 ];
        b = image->data[ i + 2 ];
        pixel = QRgb( qRgb( r, g, b ) );
        break;

      case 2:
        a = image->data[ i + 1 ];
        pixel = QRgb( qRgba( r, r, r, a ) );
        break;

      case 1:
        pixel = QRgb( qRgb( r, r, r ) );
        break;
    }

    img->setPixel( x, y, pixel );
    x += 1;

    if ( x == image->sizeX )
    {
      x = 0;
      y--;
    }
  }

  FreeImage( image );

  return img;

}

/* Converts from an RGBA tuplet
 */
QPixmap Texture::convertBytesToPixmap( unsigned char *data, int width, int height )
{
  QImage img;

  img.create( width, height, 32 );

  int bytes = width * height * 4;

  //copy the image into the QImage
  int x = 0;
  int y = height - 1;

  int r, g, b, a;

  for ( int i = 0; i < bytes; i += 4 )
  {
    r = ( int ) data[ i ]; //convert from a byte to an int.
    QRgb pixel;
    g = ( int ) data[ i + 1 ];
    b = ( int ) data[ i + 2 ];
    a = ( int ) data[ i + 3 ];
    pixel = QRgb( qRgba( r, g, b, a ) );
    img.setPixel( x, y, pixel );

    x += 1;

    if ( x == width )
    {
      x = 0;
      y--;
    }
  }

  QPixmap p;

  p.convertFromImage( img );

  return p;
}





























