/***************************************************************************
                       tesselator.cpp  -  description
                          -------------------
 begin                : Sun Jan 2 2000
 copyright            : (C) 2000 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "tesselator.h"
#include <Util/util.h>


extern "C"
{
  void vertTess( void * v );
  void beginTess( GLenum mode );
  void endTess( GLenum mode );
  void errorTess( GLenum mode );
}


static int three = 0;

vector < int > triangles;

Tesselator::~Tesselator()
{
  gluDeleteTess( tobj );
}


vector < int > & Tesselator::tesselate( vector < Vector4 > &vlist, int mode )
{
  double coord[ 3 ];

  int num = ( int ) vlist.size();

  int indexes[ num ];



  triangles.clear();

  tobj = gluNewTess();

  gluTessCallback( tobj, ( GLenum ) GLU_TESS_VERTEX, Util::gluCallback( vertTess ) );
  gluTessCallback( tobj, ( GLenum ) GLU_TESS_BEGIN, Util::gluCallback( beginTess ) );
  gluTessCallback( tobj, ( GLenum ) GLU_TESS_END, Util::gluCallback( endTess ) );
  gluTessCallback( tobj, ( GLenum ) GLU_TESS_ERROR, Util::gluCallback( errorTess ) );

  three = 0;

#if defined GLU_VERSION_1_2

  gluTessBeginPolygon( tobj, 0 );
#else

  gluBeginPolygon( tobj );
#endif // GLU_VERSION_1_2

  if ( mode == POLY_CCW )
  {
    for ( int i = 0; i < ( int ) vlist.size(); i++ )
    {
      indexes[ i ] = i;
      coord[ 0 ] = vlist[ i ].x;
      coord[ 1 ] = vlist[ i ].y;
      coord[ 2 ] = vlist[ i ].z;
      gluTessVertex( tobj, coord, &indexes[ i ] );
    }
  }

  else
  {
    int num = vlist.size();

    for ( int i = num - 1; i > -1; i-- )
    {
      indexes[ i ] = i;
      coord[ 0 ] = vlist[ i ].x;
      coord[ 1 ] = vlist[ i ].y;
      coord[ 2 ] = vlist[ i ].z;
      gluTessVertex( tobj, coord, &indexes[ i ] );
    }
  }

#if defined GLU_VERSION_1_2
  gluTessEndPolygon( tobj );

#else

  gluEndPolygon( tobj );

#endif // GLU_VERSION_1_2

  return triangles;

}


void vertTess( void *v )
{
  /* Occasionally, the tesselator throws
   * out a null. In this case, make sure
   * we discard the entire triangle.
   * The user will be able to recreate
   * it manually.
   */

  if ( v == 0 )
  {
    cerr << "Tesselator: Null vertex.. Removing triangle." << endl;

    while ( three >= 0 )
    {
      triangles.pop_back();
      three --;
    }

    return ;
  }

  int *vertex = ( int * ) v;
  triangles.push_back( *vertex );
  three++;

  if ( three == 3 )
  {
    three = 0;
  }
}

void beginTess( GLenum mode )
{}

void endTess( GLenum mode )
{}

void errorTess( GLenum mode )
{
  cerr << "Error!" << endl;
  cerr.flush();
}
