/***************************************************************************
                        surfaceconstructor.h  -  description                              
                           -------------------                                         
  begin                : Tue Nov 16 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef SURFACECONSTRUCTOR_H
#define SURFACECONSTRUCTOR_H

#include <qlist.h>
#include "isosurface.h"

/**This is the base class for surface construction methods.
 
  *@author Jon Anderson
  */

typedef struct
{
   float x, y, z;
}

XYZ;

typedef struct
{
   XYZ p[ 3 ];
}

TRIANGLE;

typedef struct
{
   XYZ p[ 8 ];
   double val[ 8 ];
}

GRIDCELL;

class SurfaceConstructor
{

public:
   SurfaceConstructor( QList<IsoSurface> *list );
   virtual ~SurfaceConstructor();
   virtual Object *getSurface( float )
   {
      return 0;
   };

protected:
   QList<IsoSurface> *slist;

};

#endif
