/***************************************************************************
                       spline.cpp  -  description                              
                          -------------------                                         
 begin                : Wed Dec 15 1999                                           
 copyright            : (C) 1999 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "spline.h"
#include "vertex.h"

int Spline::TYPE = Typed::getUID();

Spline::Spline( Entity *p ) : Object( p )
{
  closed = false;
  addType( TYPE );
}

Spline::Spline( vector < Vector4 > &_verts, Entity *p ) : Object( p )
{
  for ( int i = 0; i < ( int ) _verts.size(); i++ )
  {
    createVertex( _verts[ i ] );
  }

  //verts = _verts;
  addType( TYPE );
}

Spline::Spline( Vector4 &p, Entity *parent ) : Object( p, parent )
{
  addType( TYPE );
}

Spline::~Spline()
{}

void Spline::reverse()
{

  VertexList vlist;
  vlist = verts; //copy the pointers;

  //need to re-index verts!!!
  verts.erase( verts.begin(), verts.end() );

  for ( int i = vlist.size() - 1; i >= 0; i-- )
  {
    verts.push_back( vlist[ i ] );
    vlist[ i ] ->setIndex( ( int ) verts.size() );
  }

}

void Spline::copyFrom( Entity *rhs )
{
  *this = * static_cast < Spline * > ( rhs );
}


Spline & Spline::operator=( Spline&rhs )
{

  Object::operator=( rhs );
  closed = rhs.closed;
  return *this;
}


Entity * Spline::clone()
{
  // Spline *s = new Spline(Vector4());
  // *s = *this;

  // return s;
  return 0;

}
