/***************************************************************************
                       primitive.cpp  -  description
                          -------------------
 begin                : Fri Apr 20 2001
 copyright            : (C) 2001 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "primitive.h"
#include "vertex.h"

Primitive::Primitive( int which )
{
  m_type = which;
  m_verts_added = 0;
}

Primitive::~Primitive()
{}


void Primitive::extend( Vector4 &pt )
{
  // create a new vertex;
  Matrix44 m;

  m_mesh -> getCompleteMatrix( &m );

  m.Invert();
  pt = m * pt;

  m_mesh -> createVertex( pt );

  m_verts_added++;

  switch ( m_type )
  {

    case POINTS:
      break;

    case TRIANGLES:
      addTriangle();
      break;

    case QUADS:
      addQuad();
      break;

    case TRISTRIP:
      addTStrip();
      break;

    case QUADSTRIP:
      addQStrip();
      break;

    default:
      break;
  }

  return ;
}

void Primitive::terminate()
{

  /*
    //delete any loose hangin vertices.
    switch( m_type ) {
      case TRIANGLES:
        cleanupTriangle();
        break;
      case QUADS:
        cleanupQuad();
        break;
      case QUADSTRIP:
        cleanupQuadStrip();
        break;
      default:
        break;
    }
    */
}



void Primitive::addTriangle()
{
  int n = m_verts_added;

  if ( m_verts_added < 3 )
    return ;

  if ( ( m_verts_added % 3 ) == 0 )
  {
    //create a triangle from the last three verts
    m_mesh -> createFace( m_num_verts + n - 3, m_num_verts + n - 2, m_num_verts + n - 1 );
  }
}

void Primitive::addQuad()
{
  int n = m_verts_added;

  if ( n < 4 )
    return ;

  if ( ( m_verts_added % 4 ) == 0 )
  {
    //create a triangle from the last three verts
    m_mesh -> createFace( m_num_verts + n - 4, m_num_verts + n - 3,
                          m_num_verts + n - 2, m_num_verts + n - 1 );
  }
}

void Primitive::addTStrip()
{
  int n = m_verts_added;

  if ( n < 3 )
    return ;

  if ( n == 3 )
  {
    addTriangle();
    return ;
  }

  if ( n % 2 == 0 )
    m_mesh -> createFace( m_num_verts + n - 2, m_num_verts + n - 3, m_num_verts + n - 1 );
  else
    m_mesh -> createFace( m_num_verts + n - 3, m_num_verts + n - 2, m_num_verts + n - 1 );

}


void Primitive::addQStrip()
{
  int n = m_verts_added;

  if ( n < 4 )
    return ;

  if ( n == 4 )
  {
    addQuad();
    return ;
  }

  if ( n % 2 == 0 )
  {
    int q = n / 2;
    n = n + m_num_verts;

    if ( q % 2 == 1 )
      m_mesh -> createFace( n - 1, n - 2, n - 3, n - 4 );
    else
      m_mesh -> createFace( n - 2, n - 1, n - 4, n - 3 );
  }


}


void Primitive::cleanupTriangle()
{
  int n = m_verts_added;
  int dn = n % 3;

  if ( dn == 0 )
    return ;

  if ( dn > 0 )
    m_mesh -> getVertex( m_num_verts + n - 1 ) -> detach( true );

  if ( dn > 1 )
    m_mesh -> getVertex( m_num_verts + n - 2 ) -> detach( true );

  m_mesh -> cleanSubObjects();

}

void Primitive::cleanupQuad()
{
  int n = m_verts_added;
  int dn = n % 3;

  if ( dn == 0 )
    return ;

  if ( dn > 0 )
    m_mesh -> getVertex( m_num_verts + n - 1 ) -> detach( true );

  if ( dn > 1 )
    m_mesh -> getVertex( m_num_verts + n - 2 ) -> detach( true );

  if ( dn > 2 )
    m_mesh -> getVertex( m_num_verts + n - 3 ) -> detach( true );

  m_mesh -> cleanSubObjects();
}

void Primitive::cleanupQuadStrip()
{
  int n = m_verts_added;
  int dn = n % 2;

  if ( dn == 0 )
    return ;

  if ( dn == 1 )
    m_mesh -> getVertex( m_num_verts + n - 1 ) -> detach( true );

  m_mesh -> cleanSubObjects();

}

void Primitive::setMesh( Mesh * m )
{
  m_mesh = m;
  m_num_verts = m_mesh->numVerts();
}

