/***************************************************************************
                          parser.h  -  description
                             -------------------
    begin                : Sat Jun 8 2002
    copyright            : (C) 2002 by janders
    email                : janders@users.sf.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef PARSER_H
#define PARSER_H


#include <qdom.h>
#include <map>
#include <algorithm>
#include <string>
#include "entity.h"

class Parser;
typedef map<int, Parser *, less<int> > ParserTypeMap;
typedef ParserTypeMap::value_type ParserTypePair;

typedef map<string, Parser *, less<string> > ParserTagMap;
typedef ParserTagMap::value_type ParserTagPair;

/**
	* This is the default class for all parser objects.
  * Parsers handle all functionality for reading or writing a particular entity
  * to an XML dom structure.
  *@author janders
  */

class Parser : public Typed
{
public: 



	Parser(){};
	virtual ~Parser() {};


  virtual void write( QDomElement & element, Typed * )=0;
	virtual Typed * read( QDomElement & element )=0;

	static int setParser( int type, string tag, Parser * );
	static Parser * getParser( int type );
	static Parser * getParser( string tag );


	//keep 2 maps arount, one keyed on the Type, the other on the tag.
	static ParserTypeMap m_type_parsers;
	static ParserTagMap m_tag_parsers;

	static int getUID(){ return UID++; };
	static int UID;

	
};

#endif


