/***************************************************************************
                         objectparser.cpp  -  description
                            -------------------
   begin                : Sun Jun 9 2002
   copyright            : (C) 2002 by janders
   email                : janders@damascus.onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "objectparser.h"
#include "object.h"
#include "keyframe.h"
#include "vertex.h"


ObjectParser::ObjectParser()
{}

ObjectParser::~ObjectParser()
{}



void ObjectParser::readMeta( QDomElement &object, Object *obj )
{
  QDomElement e;
  QDomElement ve;
  QDomElement qe;


  obj -> setName( object.attributeNode( "name" ).value().ascii() );
  int id = atoi( object.attributeNode( "id" ).value() );

  e = object.namedItem( "visible" ).toElement();
  obj -> setVisible( ! e.isNull() );

  e = object.namedItem( "visibility_group" ).toElement();
  obj -> setVisibilityGroup( atoi( e.attributeNode( "id" ).value() ) );

  /*
     	read misc data here.
   */
  Vector4 v;
  Quat q;

  ve = object.namedItem( "pos" ).toElement();
  v.x = atof ( ve.attributeNode( "x" ).value() );
  v.y = atof ( ve.attributeNode( "y" ).value() );
  v.z = atof ( ve.attributeNode( "z" ).value() );

  obj -> setPosition( v );

  qe = object.namedItem( "quat" ).toElement();
  q.v.x = atof ( qe.attributeNode( "x" ).value() );
  q.v.y = atof ( qe.attributeNode( "y" ).value() );
  q.v.z = atof ( qe.attributeNode( "z" ).value() );
  q.w = atof ( qe.attributeNode( "w" ).value() );

  obj -> setOrientation( q );

  /* load animation frames.  Assumes a frame exists in equal states for both
     position and orientation
  */

  if ( ! ve.namedItem( "frame" ).isNull() )
  {
    printf( "Object is animated: reading frames...\n" );
    obj -> setAnimatable( true );

    QDomNodeList vnl = ve.elementsByTagName( "frame" );
    QDomNodeList qnl = qe.elementsByTagName( "frame" );

    for ( int i = 0; i < ( int ) vnl.length(); i++ )
    {
      e = vnl.item( i ).toElement();
      v.x = atof ( e.attributeNode( "x" ).value() );
      v.y = atof ( e.attributeNode( "y" ).value() );
      v.z = atof ( e.attributeNode( "z" ).value() );
      obj -> setPosition( v );

      e = qnl.item( i ).toElement();
      q.v.x = atof ( e.attributeNode( "x" ).value() );
      q.v.y = atof ( e.attributeNode( "y" ).value() );
      q.v.z = atof ( e.attributeNode( "z" ).value() );
      q.w = atof ( e.attributeNode( "w" ).value() );
      obj -> setOrientation( q );

      int time = atoi( e.attributeNode( "num" ).value() );
      printf( "Read frame #%d for pos and quat.\n", time );
      obj -> getController() -> saveTime( time );

    }

  }

}

void ObjectParser::writeMeta( QDomElement &object, Object *obj )
{
  QDomElement e;
  QDomElement qe;
  QDomElement pe;

  QDomDocument doc = object.ownerDocument();

  object.setAttribute( "name", obj -> getName().c_str() );
  object.setAttribute( "id", Parser::getUID() );

  if ( obj -> isVisible() )
  {
    e = doc.createElement( "visible" );
    object.appendChild( e );
  }

  //save misc IData here...
  /*

  */

  e = doc.createElement( "visibility_group" );

  object.appendChild( e );

  e.setAttribute( "id", obj -> getVisibilityGroup() );


  Vector4 pos;

  obj -> getPosition( &pos );

  pe = doc.createElement( "pos" );

  pe.setAttribute( "x", pos.x );

  pe.setAttribute( "y", pos.y );

  pe.setAttribute( "z", pos.z );

  object.appendChild( pe );


  Quat q;

  obj -> getOrientation( &q );

  qe = doc.createElement( "quat" );

  qe.setAttribute( "x", q.v.x );

  qe.setAttribute( "y", q.v.y );

  qe.setAttribute( "z", q.v.z );

  qe.setAttribute( "w", q.w );

  object.appendChild( qe );

  int time;

  if ( obj -> isAnimatable() )
  {
    Controller * c = obj -> getController();
    KeyframeIterator it = c -> keyframesBegin();

    while ( it != c -> keyframesEnd() )
    {

      Keyframe * kf = *it;
      pos = dynamic_cast < VectorChannel* > ( kf -> getChannel( Entity::POSITION_CHANNEL ) ) -> value;
      q = dynamic_cast < QuatChannel* > ( kf -> getChannel( Entity::ORIENTATION_CHANNEL ) ) -> value;
      time = kf -> getTime();

      e = doc.createElement( "frame" );
      e.setAttribute( "num", time );
      e.setAttribute( "x", pos.x );
      e.setAttribute( "y", pos.y );
      e.setAttribute( "z", pos.z );
      pe.appendChild( e );

      e = doc.createElement( "frame" );
      e.setAttribute( "num", time );
      e.setAttribute ( "x", q.v.x );
      e.setAttribute ( "y", q.v.y );
      e.setAttribute ( "z", q.v.z );
      e.setAttribute ( "w", q.w );
      qe.appendChild( e );

      ++it;
    }
  }

}

void ObjectParser::readVertices( QDomElement &verts, Object *obj, string tag )
{
  QDomElement e;
  QDomElement ve;

  QDomNodeList vnl;
  QDomNodeList fnl;

  Vector4 v;

  vnl = verts.elementsByTagName( tag.c_str() );

  for ( int i = 0; i < ( int ) vnl.length(); i++ )
  {
    Vertex *vt;
    ve = vnl.item( i ).toElement();

    v.x = atof( ve.attributeNode( "x" ).value() );
    v.y = atof( ve.attributeNode( "y" ).value() );
    v.z = atof( ve.attributeNode( "z" ).value() );

    vt = obj -> createVertex( v );

    v.x = atof( ve.attributeNode( "nx" ).value() );
    v.y = atof( ve.attributeNode( "ny" ).value() );
    v.z = atof( ve.attributeNode( "nz" ).value() );
    vt -> setNormal( v.x, v.y, v.z );

    v.x = atof( ve.attributeNode( "r" ).value() );
    v.y = atof( ve.attributeNode( "g" ).value() );
    v.z = atof( ve.attributeNode( "b" ).value() );
    v.w = atof( ve.attributeNode( "a" ).value() );

    if ( v.x > -1 ||
         v.y > -1 ||
         v.z > -1 ||
         v.w > -1 )
    {
      vt -> setColor( v.x, v.y, v.z, v.w );
    }

    if ( ! ve.namedItem( "frame" ).isNull() )
    {
      vt -> setAnimatable( true );
      Controller *c = vt -> getController();

      fnl = ve.elementsByTagName( "frame" );

      for ( int j = 0; j < ( int ) fnl.length(); j++ )
      {
        e = fnl.item( j ).toElement();
        v.x = atof( ve.attributeNode( "x" ).value() );
        v.y = atof( ve.attributeNode( "y" ).value() );
        v.z = atof( ve.attributeNode( "z" ).value() );

        vt -> setPosition( v );

        v.x = atof( ve.attributeNode( "nx" ).value() );
        v.y = atof( ve.attributeNode( "ny" ).value() );
        v.z = atof( ve.attributeNode( "nz" ).value() );
        vt -> setNormal( v.x, v.y, v.z );

        v.x = atof( ve.attributeNode( "r" ).value() );
        v.y = atof( ve.attributeNode( "g" ).value() );
        v.z = atof( ve.attributeNode( "b" ).value() );
        v.w = atof( ve.attributeNode( "a" ).value() );

        vt -> setColor( v.x, v.y, v.z, v.w );

        c -> saveTime( atoi( ve.attributeNode( "num" ).value() ) );

      }

    }

  }


}

void ObjectParser::writeVertices( QDomElement &verts, Object *obj, string tag )
{
  QDomElement e;
  QDomElement ve;

  QDomDocument doc = verts.ownerDocument();

  Vertex *vt;
  Vector4 v;

  for ( int i = 0; i < obj->numVerts(); i++ )
  {
    ve = doc.createElement( tag.c_str() );
    verts.appendChild( ve );
    vt = obj -> getVertex( i );
    v = vt -> getPosition( );

    ve.setAttribute( "id", Parser::getUID() );

    ve.setAttribute( "x", v.x );
    ve.setAttribute( "y", v.y );
    ve.setAttribute( "z", v.z );

    v = vt -> getNormal( );
    ve.setAttribute( "nx", v.x );
    ve.setAttribute( "ny", v.y );
    ve.setAttribute( "nz", v.z );

    v = vt -> getColor( );
    ve.setAttribute( "r", v.x );
    ve.setAttribute( "g", v.y );
    ve.setAttribute( "b", v.z );
    ve.setAttribute( "a", v.w );



    if ( vt -> isAnimatable() )
    {
      Controller * c = vt -> getController();
      KeyframeIterator it = c -> keyframesBegin();

      while ( it != c -> keyframesEnd() )
      {
        e = doc.createElement( "frame" );
        ve.appendChild( e );

        Keyframe *kf = *it;
        v = dynamic_cast < VectorChannel * > ( kf -> getChannel( Vertex::POSITION_CHANNEL ) ) -> value;
        e.setAttribute( "x", v.x );
        e.setAttribute( "y", v.y );
        e.setAttribute( "z", v.z );
        v = dynamic_cast < VectorChannel * > ( kf -> getChannel( Vertex::NORMAL_CHANNEL ) ) -> value;
        e.setAttribute( "nx", v.x );
        e.setAttribute( "ny", v.y );
        e.setAttribute( "nz", v.z );

        v = dynamic_cast < VectorChannel * > ( kf -> getChannel( Vertex::COLOR_CHANNEL ) ) -> value;
        e.setAttribute( "r", v.x );
        e.setAttribute( "g", v.y );
        e.setAttribute( "b", v.z );
        e.setAttribute( "a", v.w );

        e.setAttribute( "num", kf -> getTime() );

        ++it;
      }
    }

  }

}




