/***************************************************************************
                         nurbssurfaceparser.cpp  -  description
                            -------------------
   begin                : Mon Jun 10 2002
   copyright            : (C) 2002 by janders
   email                : janders@damascus.onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "nurbssurfaceparser.h"

#include "nurbssurface.h"
#include "objectdb.h"


NurbsSurfaceParser::NurbsSurfaceParser()
{}

NurbsSurfaceParser::~NurbsSurfaceParser()
{}


void NurbsSurfaceParser::write( QDomElement & parent, Typed * t )
{
  NurbsSurface * s = ( NurbsSurface * ) t ;
  QDomDocument doc = parent.ownerDocument();

  QDomElement surface;
  QDomElement e;

  surface = doc.createElement( "surface" );
  parent.appendChild( surface );

  writeMeta( surface, s );

  e = doc.createElement( "material" );
  e.setAttribute( "id", ObjectDB::getInstance() -> getMaterialIndex( s -> getTextureMaterial() ) );
  surface.appendChild( e );

  e = doc.createElement( "u_segs" );
  e.setAttribute( "val", s -> getUSegs() );
  surface.appendChild( e );

  e = doc.createElement( "v_segs" );
  e.setAttribute( "val", s -> getVSegs() );
  surface.appendChild( e );

  e = doc.createElement( "u_pts" );
  e.setAttribute( "val", s -> getNumUPoints() );
  surface.appendChild( e );

  e = doc.createElement( "v_pts" );
  e.setAttribute( "val", s -> getNumVPoints() );
  surface.appendChild( e );


  e = doc.createElement( "control_pts" );
  surface.appendChild( e );

  writeVertices( e, s, "cp" );

  e = doc.createElement( "degree_u" );
  e.setAttribute( "val", s -> getUDegree() );
  surface.appendChild( e );

  e = doc.createElement( "degree_v" );
  e.setAttribute( "val", s -> getVDegree() );
  surface.appendChild( e );


  e = doc.createElement( "knots_u" );
  writeKnots( e, s-> getUKnots() );
  surface.appendChild( e );

  e = doc.createElement( "knots_v" );
  writeKnots( e, s-> getVKnots() );
  surface.appendChild( e );

}

Typed * NurbsSurfaceParser::read( QDomElement & element )
{

  vector < float > u_knots;
  vector < float > v_knots;
  int degree_u;
  int degree_v;

  NurbsSurface *s = new NurbsSurface();
  QDomElement e;

  readMeta( element, s );

  e = element.namedItem( "material" ).toElement();
  int id = atoi( e.attributeNode( "id" ).value() );

  if ( id >= 0 )
    s -> setTextureMaterial( ObjectDB::getInstance() -> getMaterial( id ) );

  e = element.namedItem( "u_segs" ).toElement();
  int u_segs = atoi( e.attributeNode( "val" ).value() );

  e = element.namedItem( "v_segs" ).toElement();
  int v_segs = atoi( e.attributeNode( "val" ).value() );

  e = element.namedItem( "u_pts" ).toElement();
  int u_pts = atoi( e.attributeNode( "val" ).value() );

  e = element.namedItem( "v_pts" ).toElement();
  int v_pts = atoi( e.attributeNode( "val" ).value() );

  e = element.namedItem( "control_pts" ).toElement();

  readVertices( e, s, "cp" );

  e = element.namedItem( "degree_u" ).toElement();

  degree_u = atoi( e.attributeNode( "val" ).value() );

  e = element.namedItem( "degree_v" ).toElement();

  degree_v = atoi( e.attributeNode( "val" ).value() );

  e = element.namedItem( "knots_u" ).toElement();

  u_knots = readKnots( e );

  e = element.namedItem( "knots_v" ).toElement();

  v_knots = readKnots( e );

  s -> setUSegs( u_segs );
  s -> setVSegs( v_segs );

  //create a surface here...
  s->createSurface(u_pts, v_pts, u_knots, v_knots, degree_u, degree_v );


  return s;

}
