/***************************************************************************
                        NurbsSurface.h  -  description
                           -------------------                                         
  begin                : Thu Nov 18 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef NURBSSURFACE_H
#define NURBSSURFACE_H

#include "object.h"
#include <nurbs++/nurbsS.h>

/**This class is  a Nurbs surface.  Surfaces can be created in three ways,
  *sweeping an existing curve, lathing an existing curve, or by creating a patch.
  *@author Jon Anderson
  */

class NurbsCurve;

class Mesh;

class CtrlPt;

class NurbsSurface : public Object
{

public:
   NurbsSurface( Entity *parent = 0 );
   virtual ~NurbsSurface();

   virtual void copyFrom( Entity * );

   virtual void weld( int, int, int )
   {}

   ;

   virtual Object * slice( int type, vector<int> &solist )
   {
      return 0;
   };

   virtual void connect( int type, vector<int> & )
   {}

   ;

   CtrlPt * createCtrlPt( float, float, float );

   /**Draw the surface */
   virtual int draw( int d_options = 0 );

   void sweep( NurbsCurve &p, NurbsCurve &c, NurbsCurve &sc, int k = 5 );
   void revolve( NurbsCurve &p, Vector4 &c, float degrees = 360 );
   void revolve( NurbsCurve &c, Vector4 &a, Vector4 &p, float degrees );
   void makeTorus( Vector4 p );
   void makeSphere( Vector4 p );
   void makePlane( Vector4 p, int plane, int u, int v );
   void makeCap( NurbsCurve &c );

   void skinU( PLib::NurbsCurveArrayf &a, int d );
   void skinV( PLib::NurbsCurveArrayf &a, int d );


   PLib::NurbsSurfacef getSurface()
   {
      return surface;
   };

   void setMaterial( Material * );
   void setUpControlPoints();
   void moveControlPoint( CtrlPt *, float x, float y, float z );
   void drawControlPolygon();
   Mesh * getMesh( int du = 15, int dv = 15 );

   NurbsSurface & operator=( NurbsSurface &rhs );
   virtual Entity * clone();

   int getVSegs()
   {
      return vsegs;
   };

   int getUSegs()
   {
      return usegs;
   };

   void setVSegs( int i );

   void setUSegs( int i );

   int getUDegree()
   {
      return udegree;
   };

   int getVDegree()
   {
      return vdegree;
   };

   vector<float> getUKnots();
   vector<float> getVKnots();

   int getNumUPoints();
   int getNumVPoints();

   void createSurface( vector<Vector4> &pts, int upts, int vpts, vector<float> &uknots, vector<float> &vknots, int udegree, int vdegree );
   void createSurface( int upts, int vpts, vector<float> &uknots, vector<float> &vknots, int udegree, int vdegree );
   void recomputeSurface();

   static int display_mode;
   static int TYPE;

protected:
   /** The nurbs curve */
   PLib::NurbsSurfacef surface;

   /** A vector of control points for the curve */
   Vector_Point3Df points;
   PLib::Point3Df *p;
   PLib::Point3Df *n;



   /**The glu Nurbs renderer used to draw the curve */
   GLUnurbsObj *theNurbs;
   void setDirtyBox( bool flag );
   Material *material;
   int usegs;
   int vsegs;
   int udegree;
   int vdegree;

   bool recompute;

};

#endif
