/***************************************************************************
                       light.cpp  -  description                
                          -------------------                   
 begin                : Sun Apr 25 1999                    
 copyright            : (C) 1999 by Jonathan E. Anderson            
 email                : ande1514@tc.umn.edu               
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include "light.h"

int Light::TYPE = Typed::getUID();

GLenum Light::lights[ 7 ] = { GL_LIGHT1,
                              GL_LIGHT2,
                              GL_LIGHT3,
                              GL_LIGHT4,
                              GL_LIGHT5,
                              GL_LIGHT6,
                              GL_LIGHT7 };

int Light::_num = 0;

Light::Light( Vector4 &p, Entity *_parent )
    : Entity( p, _parent )
{
  initLight();
}

Light::Light( Entity *_parent )
    : Entity( _parent )
{
  initLight();
}

Light::~Light()
{}

void Light::initLight()
{

  addType( TYPE );

  light_id = lights[ _num ];
  _num++;

  m = new TextureMaterial();


  refreshLight();


}

void Light::refreshLight()
{
  GLfloat v[ 4 ];

  glLightfv( light_id, GL_AMBIENT, m-> cAmbient.toVector( v ) );
  glLightfv( light_id, GL_DIFFUSE, m-> cDiffuse.toVector( v ) );
  glLightfv( light_id, GL_SPECULAR, m->cSpecular.toVector( v ) );

}

int Light::draw( int d_options )
{
  glPushMatrix();

  Matrix44 m;
  getCompleteMatrix( &m );
  glMultMatrixf( ( GLfloat * ) ( m.m ) );

  glPushAttrib( GL_LIGHTING_BIT );
  glDisable( GL_LIGHTING );

  GLfloat lpos[] = {0, 0, 0, 0};

  glLightfv( light_id, GL_POSITION, lpos );


  if ( selected )
  {
    //   drawPivotPoint();
    //   drawBoundingBox();
  }

  glPushName( getID() );

  //draw the light here.
  glColor4f( 1, 1, 0, 1 );
  glutSolidCube( 1 );



  glPopName();
  glPopAttrib();
  glPopMatrix();


  return 0;


}

