/***************************************************************************
                        keyframe.h  -  description                              
                           -------------------                                         
  begin                : Sat Aug 14 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef KEYFRAME_H
#define KEYFRAME_H

#include <map>

//Math
#include "channels.h"
#include <Math/vector4.h>
#include <Math/quat.h>

using namespace std;

typedef map<int, Channel *, less<int> > ChannelMap;
typedef ChannelMap::value_type ChannelPair;
typedef ChannelMap::iterator ChannelIterator;

/**A Keyframe is a snapshot of the state of the entity for a time.
 *It basically provides as as fast as possible lookup of a collection
 *of attributes, such as position, orientation
 *color, texture coords, texture maps, etc...
 *@author Jonathan E. Anderson
 */

class Keyframe
{

public:

   Keyframe( int time );
   ~Keyframe();

   void addChannel( int channel_type, Channel * );
   Channel * getChannel( int channel_type );

   void interpolate( float pct, Keyframe *r, Keyframe *dst );

   void setTime( int t )
   {
      m_time = t;
   };

   int getTime()
   {
      return m_time;
   };

   ChannelIterator channelsBegin()
   {
      return m_channels.begin();
   };

   ChannelIterator channelsEnd()
   {
      return m_channels.end();
   };


   void save();
   void open();

   bool operator<( Keyframe &f );
   bool operator<=( Keyframe &f );
   bool operator==( Keyframe &f );
   Keyframe & operator=( Keyframe &f );

private:
   void copy( Keyframe &s );


private:
   ChannelMap m_channels;
   int m_time;


};


#endif













