/***************************************************************************
                        isosurface.h  -  description                              
                           -------------------                                         
  begin                : Thu Nov 11 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef ISOSURFACE_H
#define ISOSURFACE_H

#include "entity.h"

class Object;



/** This is the base class for all IsoSurfaces.  All an IsoSurface must do i
  * re-implant the draw method to draw the baseline function, and the
  * isIn() function to determine if a specific point is inside the surface.
  * The actual polygon surface is gotten by calling getSurface() which
  * returns a Object.
  * @author Jon Anderson
  */

class IsoSurface : public Entity
{

public:
   IsoSurface( float x, float y, float z, Entity *parent = 0 );
   virtual ~IsoSurface();
   Object * getSurface();
   virtual int draw( int d_options = 0 )
   {
      return 0;
   };

   virtual bool isIn( float x, float y, float z )
   {
      return false;
   };

   virtual float getField( float r )
   {
      return 0;
   };

   // bool isIn(Vertex *v);

protected:

};

#endif
