/***************************************************************************
                       heightmap.cpp  -  description
                          -------------------
 begin                : Fri Mar 31 2000
 copyright            : (C) 2000 by Jon Anderson
 email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "heightmap.h"
#include "vertex.h"
#include "face.h"
#include <config.h>
#include <i3d.h>


#include <qfiledialog.h>

HeightMap::HeightMap( float x, float y, float z, float hx, float hy, float hz )
    : Mesh( x, y, z )
{

  x_steps = ( int ) ( 256 / hx );


  //scale height to be in range of 5;
  y_size = ( int ) hy;
  z_steps = ( int ) ( 256 / hz );

  loadHeightMap();
  normalize();
}

HeightMap::HeightMap( QImage &i, float x, float y, float z, float hx, float hy, float hz )
{
  x_steps = ( int ) ( 256 / hx );


  //scale height to be in range of 5;
  y_size = ( int ) hy;
  z_steps = ( int ) ( 256 / hz );

  init( i );
  normalize();
}

HeightMap::~HeightMap()
{}

void HeightMap::loadHeightMap()
{
  static QString directory = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str();
  QString name = QFileDialog::getOpenFileName( directory, "Images (*.png *.xpm *.jpg *.rgb)" );

  directory = QString::null;

  QImage image( name );

  if ( image.isNull() )
  {
    QImage dummy( 256, 256, 32 );
    QColor c( 0, 0, 0 );
    dummy.fill( c.pixel() );
    image = dummy;
  }

  // int w = image.width();

  init( image );
}

void HeightMap::init( QImage &image )
{
  //construct verts...
  QRgb p;
  float mx, my, mz;

  int vx = 0, vz = 0;

  image = image.convertDepth( 32 );
  image = image.smoothScale( 256, 256 );

  int h = image.height();

  for ( int i = 0; i < 256; i += x_steps )
  {
    mx = ( float ) ( ( float ) i / 256 * 10 ) - 5;
    vz = 0;

    for ( int j = 0; j < 256; j += z_steps )
    {
      p = image.pixel( i, j );
      my = qGray( p );
      my = ( my / h ) * y_size;
      //scale x and z to inside of 10;
      mz = ( float ) ( ( float ) j / 256 * 10 ) - 5;
      createVertex( mx, my, mz );
      vz++;
    }

    vx++;
  }

  //construct quads...
  for ( int i = 0; i < vx - 1; i++ )
  {
    for ( int j = 0; j < vz - 1; j++ )
    {
      createFace( i * vx + j,
                  i * vx + j + 1,
                  ( i + 1 ) * vx + ( j + 1 ),
                  ( i + 1 ) * vx + j );
    }

  }


}


