/***************************************************************************
                       face.h  -  description                              
                          -------------------                                         
 begin                : Wed Dec 15 1999                                           
 copyright            : (C) 1999 by Jon Anderson                         
 email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef FACE_H
#define FACE_H

//#include "object.h"

#include <GL/gl.h>
#include "subobject.h"


class Mesh;

class Edge;

class Vertex;

class UVCoord;

class Object;
/**An Face is planar polygon used to create a mesh.
  *Faces can be either triangles, quads, polygons (default).
  *
  *Faces maintain a list of the verts that it contains.
  *Faces contain logic to extrude themselves, as well as divide themselves.
  *
  *Adding a vert to a Tri->Quad->Poly.
  *Poly's are not triangulated.  The user can do that manually by
  *connecting verts.
  *@author Jon Anderson
  */


class Face : public SubObject
{

public:

   Face( Object *o = 0 );
   virtual ~Face();

   void init( std::vector<int> & );
   void init( std::vector<int> & , std::vector<int> &);

   void subdivideE( int, int );
   void subdivideEV( int, int v );

   /**Extrude the face along the given vector */
   void extrude( Vector4 &v );
   /**Extrude the face along the normal */
   /** Interactive extrusion is down by extruding the face 0 units
     * and then moving the face in the desired direction.
     */
   void extrude();

   void subdivideTriangles(); //

   bool isOrientated( int v1, int v2 );

   bool triangulate();

   std::vector<int> getFaceAsTris();

   int splitByVerts( int v1, int v2 );

   void merge( int s1 );

   bool reEdge();

   bool adjacentVerts( int v1, int v2 );

   /**Get the normal from the face */
   Vector4 getNormal( int i = 0 );

   /**Draw the face */
   virtual int draw( int d_options = 0 ); //
   void drawFace( int mode );
   void drawSelectedFace();

   int getEdgeAfter( int v );
   int getEdgeBefore( int v );

   Vector4 getUVCenter();

   std::vector<int> * getUVs()
   {
      return & uvlist;
   };

   void setVerts( vector<int> &v )
   {
      vlist = v;
   };


   void addVertex( int ov1, int ov2, int nv );


   void rotateOrder( int index );


   /** Moves the face the given amount along it's normal */
   virtual void move( float amount );
   virtual void move( float x, float y, float z )
   {
      SubObject::move( x, y, z );
   };

   void normalize();

   Face & operator=( Face &rhs );
   Face * clone();
   void copyFrom( SubObject * );

   void setUVCoord( int, Vector4 & );
   void setUVCoord( int i, float u, float v );
   void normalizeUVs( bool u = false, bool v = false );
   void reverse();


public:
   static bool filled;
   static int TYPE;

protected:

   bool usetest;
   Vector4 testColor;
   Vector4 normal;


};

#endif
