/***************************************************************************
                        controller.h  -  description                              
                           -------------------                                         
  begin                : Sat Aug 14 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#ifndef CONTROLLER_H
#define CONTROLLER_H

//QT includes
//#include "qsortedlist.h"
#include <Math/matrix44.h>
#include <Math/vector3.h>
#include <Math/vector4.h>

#include <vector>
#include <list>
#include <string>

class Animatable;

class Keyframe;

using namespace std;


typedef list<Keyframe *> KeyframeList;
typedef KeyframeList::iterator KeyframeIterator;



/**
 *@author Jon Anderson
 */

class Controller
{

public:
   Controller();

   virtual ~Controller();

   void setAnimatable( Animatable *a )
   {
      ent = a;
   };

   //      void saveKeyframe( int time, Keyframe * );
   //  Keyframe & getKeyFrame( int time );

   int getID()
   {
      return ID;
   };

   void setDirty( bool flag )
   {
      dirty = flag;
   };

   bool isDirty()
   {
      return dirty;
   };

   void toggleDirty()
   {
      dirty = !dirty;
   };

   Controller & operator=( Controller &rhs );

   void saveTime( int time );
   void loadTime( int time );
   void deleteTime( int _time );
   void incrementTime();
   int getMaxTime( ) { return max_time; };


		KeyframeIterator  keyframesBegin() { return m_frames.begin(); };
		KeyframeIterator  keyframesEnd() { return m_frames.end(); };

private:
   Animatable *ent;
   KeyframeList m_frames;

   Keyframe *tmp;
   Keyframe *prev;
   Keyframe *next;

   int time;
   int max_time;

   bool dirty;
   int ID;
   int type;
};

#endif




















