/***************************************************************************
                        boundingbox.h  -  description
                           -------------------
  begin                : Tue Jan 4 2000
  copyright            : (C) 2000 by Jon Anderson
  email                : janderson@onelink.com
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef BOUNDINGBOX_H
#define BOUNDINGBOX_H

#include <GL/gl.h>
#include <Math/vector4.h>

/**This is a Gizmo used to display a bounding box.
  *@author Jon Anderson
  */

class BoundingBox
{

public:
   BoundingBox();
   void setBounds( Vector4 &_min, Vector4 &_max );
   void draw( int d_options = 0 );
   void getMin( Vector4 *p )
   {
      *p = min;
   };

   void getMax( Vector4 *p )
   {
      *p = max;
   };

   void move( Vector4 & );
   void rotate( Vector4 & );
   void scale( Vector4 & );

   void setColor( Vector4 & );
   void getColor( Vector4 *p )
   {
      *p = m_color;
   };

   ~BoundingBox();


   bool contains( Vector4 &p );

protected:
   Vector4 min;
   Vector4 max;
   float y3;
   float x3;
   float z3;

   Vector4 m_color;
};

#endif
