/***************************************************************************
                        bone.h  -  description
                           -------------------                                         
  begin                : Wed Sep 29 1999                                           
  copyright            : (C) 1999 by Jon Anderson                         
  email                : janderson@onelink.com                                     
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef BONE_H
#define BONE_H

#include "object.h"
#include <vector>
#include <list>
#include <algorithm>
#include <map>
#include <GL/glu.h>

#include "boundingbox.h"

class Vertex;

class Object;

/**
  * @author Jon Anderson
  */

class Bone : public Object
{

public:


   enum { MODE_NORMAL, MODE_IK, MODE_ENVELOPE, MODE_LIMITS };

   Bone( Entity *p, float length );
   Bone( Entity *p, Vector4 &effector );

   ~Bone();


   void setupGeometry();

   void init( Entity *p );

   virtual int draw( int d_options = 0 );

   void drawLimits();
   void drawAffected();

   virtual void setParent( Entity * );

   void moveIK( float x, float y, float z );

   void loadKeyframe( Keyframe * );
   void saveKeyframe( Keyframe * );

   void scale( float, float , float, float, float, float );
   void scaleEnvelope( float, float , float );
   void scaleLimits( float, float, float );
   void moveEnvelope( float, float, float );

   void move( float x, float y, float z );
   void rotate( float amount, float x, float y, float z, float px, float py, float pz );

   void getEffectorMatrix( Matrix44 * );
   Vector4 & getEffector()
   {
      return m_effector;
   };

   Vector4 getEffectorSpace( Vector4 & );
   Vector4 getBoneSpace( Vector4 & );

   void getBoundingMin( Vector4 * );
   void getBoundingMax( Vector4 * );

   void addAffected( Vertex * v );

   void getCompleteMatrix( Matrix44 * );

   void setStiffness( float i )
   {
      m_stiffness = i;
   };

   float getStiffness()
   {
      return m_stiffness;
   };

   void setLength( float i )
   {
     // m_effector.y = i;
     // setEnvelope( m_envelope );
   };

   float getLength()
   {
      return m_effector.y;
   };

   Vector4 & getXRot()
   {
      return vXRot;
   };

   Vector4 & getYRot()
   {
      return vYRot;
   };

   Vector4 & getZRot()
   {
      return vZRot;
   };

   void setXRot( float mn, float mx )
   {
      vXRot.x = mx;
      vXRot.y = mn;
   };

   void setYRot( float mn, float mx )
   {
      vYRot.x = mx;
      vYRot.y = mn;
   };

   void setZRot( float mn, float mx )
   {
      vZRot.x = mx;
      vZRot.y = mn;
   };

   void addChild( Bone *b );
   void removeChild( Bone *b );

   Bone * getRoot();
   void setRoot( Bone * );


   std::vector<Vertex *> * getAffected()
   {
      return & m_affected;
   };

   void checkDOF();

   void setEnvelope( Vector4 & );
   Vector4 & getEnvelope()
   {
      return m_envelope;
   };

   void saveAffectedAndOffsets( bool propagate = true );
   void saveAffectedOffsets( bool propagate = true );

   //void resetAffectedOffsets( bool propagate=true );

   // void grabAffectedVerts();
   void saveAffected( bool propagate = true );
   void resetAffected( bool propagate = true );

   void deformAffected();
   void applyDeformations();

   void clearVertBoneMapping();

   void getAffectedWorldSpace( Vertex *v, Vector4 *p );
   // Vector4 getAffectedWorldSpace( Vertex *v );


   static int TYPE;

   static void setMode( int i )
   {
      mode = i;
   };

   static int getMode( )
   {
      return mode;
   };

   static bool draw_envelope;
   static bool draw_affected;
   static bool draw_limits;

   virtual Entity * clone()
   {
      return 0;
   };

private:

   static int mode;

   Vector4 m_effector;

   Vector4 m_envelope;

   /**List of verts associated with this bone*/
   std::vector<Vertex *> m_affected;

   std::vector<Vector4 *> m_affected_offsets;

   Vector4 m_geometry[4];
   Vector4 m_normals[6];


   /**List of children of this bone */
   list<Bone *> m_children;

   Bone * m_root;

   float m_stiffness;

   //x = max, y = min;
   Vector4 vXRot;
   Vector4 vYRot;
   Vector4 vZRot;

   BoundingBox m_box;

   static GLUquadricObj *qobj;





};


#endif //bone.h
