/***************************************************************************
                          mateditor.cpp  -  description
                             -------------------
    begin                : Tue Jan 18 2000
    copyright            : (C) 2000 by Jon Anderson
    email                : janderson@onelink.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "mateditor.h"
#include <Views/matpreview.h>
#include <Views/glpreview.h>
#include <Entities/texturematerial.h>
#include <qcolordialog.h>
#include <qfiledialog.h>
#include <i3dworkspace.h>
#include <i3ddoc.h>
#include <i3dparser.h>
#include <i3d.h>
#include <objectdb.h>
#include <Entities/entitylib.h>
#include <fstream>
#include <config.h>

MatEditor::MatEditor(QWidget *parent, const char *name) : QDialog(parent,name,false)
{
	initDialog();
}

MatEditor::~MatEditor(){
}

void MatEditor::init()
{
	chkTexture->setEnabled(false);
	btnAmbient->setPalette ( QPalette( QColor(40, 40, 40)   ) );
	btnDiffuse->setPalette ( QPalette( QColor(255, 255, 255)) );
	btnEmission->setPalette( QPalette( QColor(0, 0, 0)      ) );
	btnSpecular->setPalette( QPalette( QColor(0, 0, 0)      ) );
	
	prvw = new GLPreview(glPreview, "preview", (QGLWidget *)I3D::getWorkspace()->getSharedContext());
	prvw->setGeometry(0, 0, 128, 128);
	prvw->setPreviewType(PREVIEW_SPHERE);
	chType->setCurrentItem(2);
	prvw->show();
	
	
	connect(btnAmbient, SIGNAL(clicked()), SLOT(slotChangeAmbient()));
	connect(btnDiffuse, SIGNAL(clicked()), SLOT(slotChangeDiffuse()));
	connect(btnSpecular, SIGNAL(clicked()), SLOT(slotChangeSpecular()));
	connect(btnEmission, SIGNAL(clicked()), SLOT(slotChangeEmission()));
	connect(btnNew, SIGNAL(clicked()), SLOT(slotNewMaterial()));
	connect(btnClose, SIGNAL(clicked()), SLOT(accept()));
	connect(tblPreview, SIGNAL(highlighted(int)), SLOT(slotSelected(int)));
	connect(btnBrowse, SIGNAL(clicked()), SLOT(slotChangeTexture()));
	connect(btnApply, SIGNAL(clicked()), SLOT(slotApplyMaterial()));
	connect(btnCopy, SIGNAL(clicked()), SLOT(slotCopyMaterial()));
	connect(btnDelete, SIGNAL(clicked()), SLOT(slotDeleteMaterial()));
	connect(btnSave, SIGNAL(clicked()), SLOT(slotSave()));
	connect(btnLoad, SIGNAL(clicked()), SLOT(slotLoad()));
	
	connect(sldrAlpha, SIGNAL(sliderReleased()), SLOT(slotChangeAlpha()));
	connect(sldrShininess, SIGNAL(sliderReleased()), SLOT(slotChangeShininess()));	
	
	connect(chType, SIGNAL(activated(int)), SLOT(slotChangePreviewType(int)));
	
	currentMat = 0;//prvw->getMaterial();
	currentIndex = -1;
	
}


void MatEditor::slotChangeAmbient()
{
  if(currentMat == 0)
  	return;
  	
  QColor c = QColorDialog::getColor(QColor(255, 255, 255));
  btnAmbient->setPalette(QPalette(c));
  currentMat->cAmbient = c;

  prvw->updateGL();
  tblPreview->changeItem(prvw->getPixmap(  ), currentIndex);
//  prvw->getMaterial()->setAmbient(c);

}
void MatEditor::slotChangeDiffuse()
{
   if(currentMat == 0)
  	return;

  QColor c = QColorDialog::getColor(QColor(255, 255, 255));
  btnDiffuse->setPalette(QPalette(c));
  currentMat->cDiffuse = c;
  prvw->updateGL();

  tblPreview->changeItem(prvw->getPixmap(  ), currentIndex);
}
void MatEditor::slotChangeTexture()
{
   if(currentMat == 0)
  	return;

  static QString directory = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str();
  QString name = QFileDialog::getOpenFileName(directory, "Images (*.png *.xpm *.jpg *.rgb)");

  directory = QString::null;

   if(name.isNull())
      return;
   fldTextureName->setText(name);

   QFileInfo fileInfo(name);
	 prvw->makeCurrent();
   Texture *t = new Texture(name, 0);
   currentMat->texture = t;
   currentMat->enable_texture=true;
   prvw->updateGL();
   tblPreview->changeItem(prvw->getPixmap(  ), currentIndex);
	
}
void MatEditor::slotChangeSpecular()
{
   if(currentMat == 0)
  	return;

  QColor c = QColorDialog::getColor(QColor(255, 255, 255));
  btnSpecular->setPalette(QPalette(c));
  currentMat->cSpecular = c;
  prvw->updateGL();
  tblPreview->changeItem(prvw->getPixmap(  ), currentIndex);
}
void MatEditor::slotChangeAlpha()
{
   if(currentMat == 0)
  	return;

  currentMat->alpha = sldrAlpha->value();
  prvw->updateGL();
  tblPreview->changeItem(prvw->getPixmap(  ), currentIndex);
}
void MatEditor::slotChangeShininess()
{
   if(currentMat == 0)
  	return;
	currentMat->shininess = sldrShininess->value();
  prvw->updateGL();
  tblPreview->changeItem(prvw->getPixmap(  ), currentIndex);
}


void MatEditor::slotChangeEmission()
{
   if(currentMat == 0)
  	return;

  QColor c = QColorDialog::getColor(QColor(255, 255, 255));
  btnEmission->setPalette(QPalette(c));
  currentMat->cEmission = c;
  prvw->updateGL();

  tblPreview->changeItem(prvw->getPixmap(  ), currentIndex);

}
void MatEditor::slotChangePreviewType(int type)
{
	switch(type){
		case 0:
			prvw->setPreviewType(PREVIEW_CUBE);
			break;
		case 1:
			prvw->setPreviewType(PREVIEW_CYLINDER);
			break;
		case 2:
			prvw->setPreviewType(PREVIEW_SPHERE);
			break;
		case 3:
			prvw->setPreviewType(PREVIEW_TEAPOT);
			break;
	}
	
	prvw->updateGL();			
	if(currentIndex != -1)
		tblPreview->changeItem(prvw->getPixmap(  ), currentIndex);	
}

void MatEditor::slotNewMaterial()
{

 TextureMaterial *t = new TextureMaterial();	
 currentMat = t;

 QColor specular(currentMat->cSpecular.r, currentMat->cSpecular.g, currentMat->cSpecular.b);
 QColor ambient (currentMat->cAmbient.r,  currentMat->cAmbient.g,  currentMat->cAmbient.b );
 QColor diffuse (currentMat->cDiffuse.r,  currentMat->cDiffuse.g,  currentMat->cDiffuse.b );
 QColor emission(currentMat->cEmission.r, currentMat->cEmission.g, currentMat->cEmission.b);

 btnSpecular->setPalette(QPalette(specular));
 btnAmbient->setPalette (QPalette(ambient) );
 btnDiffuse->setPalette (QPalette(diffuse) );
 btnEmission->setPalette(QPalette(emission));

 sldrAlpha->setValue(currentMat->alpha);
 sldrShininess->setValue(currentMat->shininess);

 prvw->setMaterial(currentMat);
 prvw->updateGL();

 tblPreview->insertItem(prvw->getPixmap(  ));

 ObjectDB::getInstance()->addMaterial( t );
 currentIndex = ObjectDB::getInstance()->numMaterials()-1;

 fldTextureName->setText("");
 fldName->setText(currentMat->name.c_str());

}

void MatEditor::slotSelected(int index)
{
	if(index < 0)
		return;

 currentMat = ObjectDB::getInstance()->getMaterial(index) ;
 currentIndex = index;


 QColor specular(currentMat->cSpecular.r, currentMat->cSpecular.g, currentMat->cSpecular.b);
 QColor ambient (currentMat->cAmbient.r,  currentMat->cAmbient.g,  currentMat->cAmbient.b );
 QColor diffuse (currentMat->cDiffuse.r,  currentMat->cDiffuse.g,  currentMat->cDiffuse.b );
 QColor emission(currentMat->cEmission.r, currentMat->cEmission.g, currentMat->cEmission.b);


 btnSpecular->setPalette(QPalette(specular));
 btnAmbient->setPalette (QPalette(ambient) );
 btnDiffuse->setPalette (QPalette(diffuse) );
 btnEmission->setPalette(QPalette(emission));

 sldrAlpha->setValue(currentMat->alpha);
 sldrShininess->setValue(currentMat->shininess);

 fldName->setText(currentMat->name.c_str());

 if(currentMat->texture != 0)
 	fldTextureName->setText(*(currentMat->texture->getFilename()));
 else
 	fldTextureName->setText("");

 prvw->setMaterial(currentMat);
 prvw->updateGL();
}

void MatEditor::slotApplyMaterial()
{
 if(currentMat==0)
 	return;

 //apply only the material...
 std::vector<Selectable *> *v = ObjectDB::getInstance()->getSelected();
	for(int i=0; i<(int)v->size(); i++){	
	 	if((*v)[i]->isA(Mesh::TYPE) ) {
	 	//	Mesh *m = dynamic_cast<Mesh *>( ((*v)[i]) );
	 		Mesh *m = (Mesh *) (*v)[i];
	    m->setTextureMaterial(currentMat);
	// 	else
	 	}	
	 	if((*v)[i]->isA(NurbsSurface::TYPE)){
	 		NurbsSurface *sf = (NurbsSurface *)(*v)[i];
	 		sf->setTextureMaterial(currentMat);
	 	}
  }

}
void MatEditor::slotCopyMaterial()
{
  if(currentMat == 0)
  	return;


 TextureMaterial *t = new TextureMaterial();	
 *t = *currentMat; //copy

 currentMat = t; //set current Material

 prvw->setMaterial(currentMat);
 prvw->updateGL();

 tblPreview->insertItem(prvw->getPixmap(  ) );

 ObjectDB::getInstance()->addMaterial( t );

 currentIndex = ObjectDB::getInstance()->numMaterials()-1;

 if(t->texture != 0)
	 fldTextureName->setText(*(t->texture->getFilename()));	

 fldName->setText(t->name.c_str());	
}

void MatEditor::slotDeleteMaterial()
{
	if(currentMat == 0)
		return;

//	ObjectDB::getInstance()->removeMaterial( currentMat );

 tblPreview->removeItem(currentIndex);


}

void MatEditor::slotSave()
{
	I3DParser parser( "/home/janders/test.xml", false );

	parser.write();


/*
   static QString directory = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str() ;
  QString name = QFileDialog::getSaveFileName(directory, "*.i3m");

  directory = QString::null;

   if ( name.isNull() )
   	return;
   	
   if(name.right(4) != ".i3m")
   	name += ".i3m";
   	
  ofstream out(name, ios::out);
  if(!out)
		return;
	
  for(int i=0; i<(int)materials.size(); i++){
   materials[i]->write(out);
  }

  out.close();
*/
}

void MatEditor::slotLoad()
{

/*
  static QString directory = I3D::getConfig() -> getString( "Directories", "Textures" ).c_str();
  QString name = QFileDialog::getOpenFileName(directory, "*.i3m");

  directory = QString::null;

  if ( name.isNull() )
   	return;

  ifstream in(name, ios::in);
  if(!in)
		return;
			
	prvw->makeCurrent();
	while(!in.eof()){
		TextureMaterial *t = new TextureMaterial();
		t->read(in);
		currentMat = t;
		prvw->setMaterial(currentMat);
    prvw->updateGL();
    tblPreview->insertItem(prvw->getPixmap(  ));
    materials.push_back( t );
	}
 currentIndex = materials.size()-1;

 if(currentMat->texture !=0)
	 fldTextureName->setText(*(currentMat->texture->getFilename()));

 fldName->setText(currentMat->name.c_str());
*/

}

int MatEditor::addMaterial(TextureMaterial *t)
{
	currentMat = t;
	prvw->setMaterial(currentMat);
	prvw->updateGL();
  tblPreview->insertItem(prvw->getPixmap(  ));
	ObjectDB::getInstance()->addMaterial( t );

  currentIndex = ObjectDB::getInstance()->numMaterials()-1;
  return currentIndex;

}



/**Refreshes all the pixmap views*/
void MatEditor::refresh()
{
	cerr << "Refreshing previews"<<endl;
	tblPreview->clear();
	
	for(int i=0; i<(int)ObjectDB::getInstance()->numMaterials(); i++){
		prvw->setMaterial(ObjectDB::getInstance()->getMaterial(i));
		prvw->updateGL();
 	  tblPreview->insertItem( prvw->getPixmap(  ) );
	}

}

/**Over ride show to refresh views after showing*/
void MatEditor::show()
{
 QDialog::show();
 refresh();
 cerr<< "Refreshed views"<<endl;
}
	
	

	
