/***************************************************************************
                          transactioncommand.cpp  -  description
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "transactioncommand.h"
#include "../redostack.h"
#include "../undostack.h"
#include <iostream>




TransactionCommand::TransactionCommand():Command()
{
  size = 0;
}
TransactionCommand::~TransactionCommand()
{

}
int TransactionCommand::count()
{
 	return size;
}
void TransactionCommand::addCommand(Command *c)
{
	clist.push_back(c);
	size++;
}

void TransactionCommand::removeCommand(Command *c)
{
	clist.remove(c);
	size--;
}

bool TransactionCommand::execute()
{
 	list<Command *>::iterator iter;
 	
 	for(iter= clist.begin(); iter!=clist.end(); iter++){
		(*iter)->execute();
	}
		
	return true;
}

bool TransactionCommand::undo()
{
	//traverse the list backward.
 	list<Command *>::iterator iter;
 	
 	iter = clist.end();
 	while(iter != clist.begin()){
		iter--;
		(*iter)->undo();
	}

	return true;
}


