/***************************************************************************
                          listcommand.h  -  description                              
                             -------------------                                         
    begin                : Sun Dec 5 1999                                           
    copyright            : (C) 1999 by Jon Anderson                         
    email                : janderson@onelink.com                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef LISTCOMMAND_H
#define LISTCOMMAND_H

#include "command.h"
#include <Entities/entity.h>
#include <stdlib.h>
#include <iostream>

#include<vector>
#include<algorithm>


//typedef ListCommand<Entity> ListCommandE;
//typedef ListCommand<Face> ListCommandF;


//#define ListCommand ListCommand<Entity>

/** ListCommand performs actions on lists of entities.  At the time, this is simply
  * limited to adding, removing, and clearing the list.
  *@author Jon Anderson
  */

#define CLEAR  0
#define ADD 1
#define REMOVE 2



class ListCommand : public Command {
public: 
	ListCommand(Selectable *s, std::vector<Selectable *> *elist, int command);
	~ListCommand();
	
	bool execute();
	bool undo();	
	

protected: // Protected attributes

  std::vector<Selectable * > m_oldContents;
  std::vector<Selectable * > *m_list;

  Selectable * m_item;

  int command;
};

#endif
