/*
 * indicator-network - user interface for connman
 * Copyright 2010 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "manager-proxy.h"

#include "marshal.h"

typedef struct _ManagerProxyPrivate ManagerProxyPrivate;

struct _ManagerProxyPrivate
{
  gint padding;
};

/* Signals */
enum {
  ICON_CHANGED,
  LAST_SIGNAL,
};

static guint signals[LAST_SIGNAL] = { 0 };

#define GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), MANAGER_PROXY_TYPE, \
						     ManagerProxyPrivate))

G_DEFINE_TYPE (ManagerProxy, manager_proxy, G_TYPE_OBJECT);

static void manager_proxy_dispose(GObject *object)
{
  G_OBJECT_CLASS(manager_proxy_parent_class)->dispose(object);
}

static void manager_proxy_finalize(GObject *object)
{
  G_OBJECT_CLASS(manager_proxy_parent_class)->finalize(object);
}

static void manager_proxy_class_init(ManagerProxyClass *klass)
{
  GObjectClass *object_class = G_OBJECT_CLASS(klass);

  g_type_class_add_private(object_class, sizeof(ManagerProxyPrivate));

  object_class->dispose = manager_proxy_dispose;
  object_class->finalize = manager_proxy_finalize;

  g_assert(klass != NULL);

  signals[ICON_CHANGED] = g_signal_new("icon-changed",
				       G_TYPE_FROM_CLASS(klass),
				       G_SIGNAL_RUN_LAST,
				       0, NULL, NULL,
				       _marshal_VOID__STRING,
				       G_TYPE_NONE, 1,
				       G_TYPE_STRING);
}

static void manager_proxy_init (ManagerProxy *self)
{
}

void manager_proxy_set_icon(ManagerProxy* self, const gchar *icon_name)
{
}

void manager_proxy_get_icon(ManagerProxy* self,
				   gchar **icon_name)
{
}

void manager_proxy_set_accessible_desc(ManagerProxy* self, const gchar *accessible_desc)
{
}

void manager_proxy_request_scan (ManagerProxy* self)
{
}

gboolean manager_proxy_set_debug(ManagerProxy* self, gint level,
				 GError **error)
{
  return TRUE;
}

ManagerProxy *manager_proxy_new(Manager *manager)
{
  return g_object_new(MANAGER_PROXY_TYPE, NULL);
}
