/* libconnman-vala.c generated by valac 0.11.6, the Vala compiler
 * generated from libconnman-vala.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2011 Canonical Ltd.
 *
 * Authors:
 * Kalle Valo <kalle.valo@canonical.com>
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <connman-manager.h>
#include <stdlib.h>
#include <string.h>
#include <connman-service.h>
#include <stdio.h>
#include <connman-ipv4.h>
#include <readline/readline.h>
#include <readline/history.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_async_queue_unref0(var) ((var == NULL) ? NULL : (var = (g_async_queue_unref (var), NULL)))


extern ConnmanManager* manager;
ConnmanManager* manager = NULL;
extern GMainLoop* loop;
GMainLoop* loop = NULL;
extern GAsyncQueue* cmd_queue;
GAsyncQueue* cmd_queue = NULL;

void quit (void);
void list (void);
static ConnmanService** _vala_array_dup1 (ConnmanService** self, int length);
void default_service (void);
void status (void);
void show (gchar** args, int args_length1);
void edit_passphrase (ConnmanService* service, gchar** args, int args_length1);
void edit_nameservers (ConnmanService* service, gchar** args, int args_length1);
static gchar** _vala_array_dup2 (gchar** self, int length);
void edit_domains (ConnmanService* service, gchar** args, int args_length1);
static gchar** _vala_array_dup3 (gchar** self, int length);
void edit_ipv4 (ConnmanService* service, gchar** args, int args_length1);
void edit (gchar** args, int args_length1);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup4 (gchar** self, int length);
void tech (gchar** args, int args_length1);
ConnmanTechnologyType str2tech (const gchar* s);
void enable (gchar** args, int args_length1);
void disable (gchar** args, int args_length1);
void offline (gchar** args, int args_length1);
gboolean cmd_handler (void);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup5 (gchar** self, int length);
void* input_handler (void);
static gboolean _cmd_handler_gsource_func (gpointer self);
gint _vala_main (void);
static gpointer _input_handler_gthread_func (gpointer self);
static void _lambda0_ (GObject* s, GParamSpec* p);
static void __lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda1_ (GObject* s, GParamSpec* p);
static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda2_ (GObject* s, GParamSpec* p);
static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda3_ (GObject* s, GParamSpec* p);
static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda4_ (GObject* s, GParamSpec* p);
static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _lambda5_ (GObject* s, GParamSpec* p);
static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


void quit (void) {
	g_main_loop_quit (loop);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static ConnmanService** _vala_array_dup1 (ConnmanService** self, int length) {
	ConnmanService** result;
	int i;
	result = g_new0 (ConnmanService*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = _g_object_ref0 (self[i]);
	}
	return result;
}


void list (void) {
	ConnmanService** _tmp0_;
	ConnmanService** _tmp1_ = NULL;
	ConnmanService** _tmp2_;
	ConnmanService** _tmp3_;
	ConnmanService** services;
	gint services_length1;
	gint _services_size_;
	_tmp1_ = _tmp0_ = connman_manager_get_services (manager);
	_tmp2_ = (_tmp3_ = _tmp1_, (_tmp3_ == NULL) ? ((gpointer) _tmp3_) : _vala_array_dup1 (_tmp3_, _vala_array_length (_tmp0_)));
	services = _tmp2_;
	services_length1 = _vala_array_length (_tmp0_);
	_services_size_ = _vala_array_length (_tmp0_);
	{
		ConnmanService** service_collection;
		int service_collection_length1;
		int service_it;
		service_collection = services;
		service_collection_length1 = services_length1;
		for (service_it = 0; service_it < services_length1; service_it = service_it + 1) {
			ConnmanService* _tmp4_;
			ConnmanService* service;
			_tmp4_ = _g_object_ref0 (service_collection[service_it]);
			service = _tmp4_;
			{
				const gchar* _tmp5_ = NULL;
				const gchar* _tmp6_ = NULL;
				_tmp5_ = connman_service_get_name (service);
				_tmp6_ = connman_service_get_path (service);
				fprintf (stdout, "%s\t%s\n", _tmp5_, _tmp6_);
				_g_object_unref0 (service);
			}
		}
	}
	fprintf (stdout, "%d services\n", services_length1);
	services = (_vala_array_free (services, services_length1, (GDestroyNotify) g_object_unref), NULL);
}


void default_service (void) {
	ConnmanService* _tmp0_ = NULL;
	ConnmanService* service;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = connman_manager_get_default_service (manager);
	service = _tmp0_;
	_tmp1_ = connman_service_get_name (service);
	fprintf (stdout, "%s", _tmp1_);
	_g_object_unref0 (service);
}


void status (void) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	_tmp1_ = connman_manager_get_connected (manager);
	if (_tmp1_) {
		_tmp0_ = "connected";
	} else {
		_tmp0_ = "disconnected";
	}
	fprintf (stdout, "%s\n", _tmp0_);
}


void show (gchar** args, int args_length1) {
	gchar* _tmp0_;
	gchar* path;
	ConnmanService* _tmp1_ = NULL;
	ConnmanService* _tmp2_;
	ConnmanService* service;
	ConnmanServiceType _tmp3_;
	ConnmanServiceType type;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	guint _tmp6_;
	ConnmanIPv4* _tmp17_ = NULL;
	ConnmanIPv4* _tmp18_;
	ConnmanIPv4* ipv4;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	ConnmanIPv4* _tmp23_ = NULL;
	ConnmanIPv4* _tmp24_;
	ConnmanIPv4* _tmp25_;
	const gchar* _tmp26_ = NULL;
	const gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	const gchar* _tmp29_ = NULL;
	gchar** _tmp30_;
	gchar** _tmp31_ = NULL;
	gchar* _tmp32_ = NULL;
	gchar* _tmp33_;
	gchar** _tmp34_;
	gchar** _tmp35_ = NULL;
	gchar* _tmp36_ = NULL;
	gchar* _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_ = NULL;
	gchar* _tmp40_ = NULL;
	gchar* _tmp41_;
	gchar** _tmp42_;
	gchar** _tmp43_ = NULL;
	gchar* _tmp44_ = NULL;
	gchar* _tmp45_;
	const gchar* _tmp46_ = NULL;
	const gchar* _tmp47_ = NULL;
	gboolean _tmp48_;
	const gchar* _tmp49_ = NULL;
	gboolean _tmp50_;
	const gchar* _tmp51_ = NULL;
	gboolean _tmp52_;
	if (args_length1 != 1) {
		fprintf (stdout, "Invalid number of arguments: %d\n", args_length1);
		return;
	}
	_tmp0_ = g_strdup (args[0]);
	path = _tmp0_;
	_tmp1_ = connman_manager_get_service (manager, path);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	service = _tmp2_;
	if (service == NULL) {
		fprintf (stdout, "service %s not found", path);
		_g_object_unref0 (service);
		_g_free0 (path);
		return;
	}
	_tmp3_ = connman_service_get_service_type (service);
	type = _tmp3_;
	_tmp4_ = connman_service_get_path (service);
	fprintf (stdout, "[ %s ]\n", _tmp4_);
	_tmp5_ = connman_service_get_name (service);
	fprintf (stdout, "  Name = %s\n", _tmp5_);
	_tmp6_ = connman_service_get_state (service);
	fprintf (stdout, "  State = %u\n", _tmp6_);
	if (type == CONNMAN_SERVICE_TYPE_ETHERNET) {
		fprintf (stdout, "  Type = Ethernet\n");
	} else {
		if (type == CONNMAN_SERVICE_TYPE_WIFI) {
			guint _tmp7_;
			guint _tmp8_;
			const gchar* _tmp9_ = NULL;
			const gchar* _tmp10_ = NULL;
			gboolean _tmp11_;
			fprintf (stdout, "  Type = Wifi\n");
			_tmp7_ = connman_service_get_security (service);
			fprintf (stdout, "  Security = %u\n", _tmp7_);
			_tmp8_ = connman_service_get_strength (service);
			fprintf (stdout, "  Strength = %u\n", _tmp8_);
			_tmp9_ = connman_service_get_passphrase (service);
			fprintf (stdout, "  Passphrase = %s\n", _tmp9_);
			_tmp11_ = connman_service_get_passphrase_required (service);
			if (_tmp11_) {
				_tmp10_ = "true";
			} else {
				_tmp10_ = "false";
			}
			fprintf (stdout, "  PassphraseRequired = %s\n", _tmp10_);
		} else {
			if (type == CONNMAN_SERVICE_TYPE_CELLULAR) {
				const gchar* _tmp12_ = NULL;
				gboolean _tmp13_;
				const gchar* _tmp14_ = NULL;
				const gchar* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				fprintf (stdout, "  Type = Cellular\n");
				_tmp13_ = connman_service_get_setup_required (service);
				if (_tmp13_) {
					_tmp12_ = "true";
				} else {
					_tmp12_ = "false";
				}
				fprintf (stdout, "  SetupRequired = %s\n", _tmp12_);
				_tmp14_ = connman_service_get_apn (service);
				fprintf (stdout, "  APN = %s\n", _tmp14_);
				_tmp15_ = connman_service_get_mcc (service);
				fprintf (stdout, "  MCC = %s\n", _tmp15_);
				_tmp16_ = connman_service_get_mnc (service);
				fprintf (stdout, "  MNC = %s\n", _tmp16_);
			}
		}
	}
	_tmp17_ = connman_service_get_ipv4 (service);
	_tmp18_ = _g_object_ref0 (_tmp17_);
	ipv4 = _tmp18_;
	_tmp19_ = connman_ipv4_get_method_as_string (ipv4);
	_tmp20_ = connman_ipv4_get_address (ipv4);
	_tmp21_ = connman_ipv4_get_netmask (ipv4);
	_tmp22_ = connman_ipv4_get_gateway (ipv4);
	fprintf (stdout, "  IPv4 = { Method=%s Address=%s Netmask=%s Gateway=%s\n }\n", _tmp19_, _tmp20_, _tmp21_, _tmp22_);
	_tmp23_ = connman_service_get_ipv4_configuration (service);
	_tmp24_ = _g_object_ref0 (_tmp23_);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (ipv4);
	ipv4 = _tmp25_;
	_tmp26_ = connman_ipv4_get_method_as_string (ipv4);
	_tmp27_ = connman_ipv4_get_address (ipv4);
	_tmp28_ = connman_ipv4_get_netmask (ipv4);
	_tmp29_ = connman_ipv4_get_gateway (ipv4);
	fprintf (stdout, "  IPv4.Configuration = " "{ Method=%s Address=%s Netmask=%s Gateway=%s\n }\n", _tmp26_, _tmp27_, _tmp28_, _tmp29_);
	_tmp31_ = _tmp30_ = connman_service_get_nameservers (service);
	_tmp32_ = g_strjoinv (" ", _tmp31_);
	_tmp33_ = _tmp32_;
	fprintf (stdout, "  Nameservers = %s\n", _tmp33_);
	_g_free0 (_tmp33_);
	_tmp35_ = _tmp34_ = connman_service_get_nameservers_configuration (service);
	_tmp36_ = g_strjoinv (" ", _tmp35_);
	_tmp37_ = _tmp36_;
	fprintf (stdout, "  Nameservers.Configuration = %s\n", _tmp37_);
	_g_free0 (_tmp37_);
	_tmp39_ = _tmp38_ = connman_service_get_domains (service);
	_tmp40_ = g_strjoinv (" ", _tmp39_);
	_tmp41_ = _tmp40_;
	fprintf (stdout, "  Domains = %s\n", _tmp41_);
	_g_free0 (_tmp41_);
	_tmp43_ = _tmp42_ = connman_service_get_domains_configuration (service);
	_tmp44_ = g_strjoinv (" ", _tmp43_);
	_tmp45_ = _tmp44_;
	fprintf (stdout, "  Domains.Configuration = %s\n", _tmp45_);
	_g_free0 (_tmp45_);
	_tmp46_ = connman_service_get_error (service);
	fprintf (stdout, "  Error = %s\n", _tmp46_);
	_tmp48_ = connman_service_get_autoconnect (service);
	if (_tmp48_) {
		_tmp47_ = "true";
	} else {
		_tmp47_ = "false";
	}
	fprintf (stdout, "  AutoConnect = %s\n", _tmp47_);
	_tmp50_ = connman_service_get_favorite (service);
	if (_tmp50_) {
		_tmp49_ = "true";
	} else {
		_tmp49_ = "false";
	}
	fprintf (stdout, "  Favorite = %s\n", _tmp49_);
	_tmp52_ = connman_service_get_immutable (service);
	if (_tmp52_) {
		_tmp51_ = "true";
	} else {
		_tmp51_ = "false";
	}
	fprintf (stdout, "  Immutable = %s\n", _tmp51_);
	_g_object_unref0 (ipv4);
	_g_object_unref0 (service);
	_g_free0 (path);
}


void edit_passphrase (ConnmanService* service, gchar** args, int args_length1) {
	gchar* _tmp0_;
	gchar* passphrase;
	g_return_if_fail (service != NULL);
	if (args_length1 != 1) {
		fprintf (stdout, "Invalid number of arguments: %d\n", args_length1);
		return;
	}
	_tmp0_ = g_strdup (args[0]);
	passphrase = _tmp0_;
	connman_service_set_passphrase (service, passphrase);
	_g_free0 (passphrase);
}


static gchar** _vala_array_dup2 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void edit_nameservers (ConnmanService* service, gchar** args, int args_length1) {
	gchar** nameservers = NULL;
	gint nameservers_length1 = 0;
	gint _nameservers_size_ = 0;
	g_return_if_fail (service != NULL);
	if (args_length1 < 1) {
		fprintf (stdout, "Invalid number of arguments: %d\n", args_length1);
		nameservers = (_vala_array_free (nameservers, nameservers_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	if (g_strcmp0 (args[0], "auto") != 0) {
		gchar** _tmp0_;
		gchar** _tmp1_;
		gchar** _tmp2_;
		_tmp0_ = (_tmp1_ = args, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup2 (_tmp1_, args_length1));
		_tmp2_ = _tmp0_;
		nameservers = (_vala_array_free (nameservers, nameservers_length1, (GDestroyNotify) g_free), NULL);
		nameservers_length1 = args_length1;
		_nameservers_size_ = nameservers_length1;
		nameservers = _tmp2_;
	} else {
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		_tmp4_ = _tmp3_;
		nameservers = (_vala_array_free (nameservers, nameservers_length1, (GDestroyNotify) g_free), NULL);
		nameservers_length1 = 0;
		_nameservers_size_ = nameservers_length1;
		nameservers = _tmp4_;
	}
	connman_service_set_nameservers_configuration (service, nameservers);
	nameservers = (_vala_array_free (nameservers, nameservers_length1, (GDestroyNotify) g_free), NULL);
}


static gchar** _vala_array_dup3 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void edit_domains (ConnmanService* service, gchar** args, int args_length1) {
	gchar** domains = NULL;
	gint domains_length1 = 0;
	gint _domains_size_ = 0;
	g_return_if_fail (service != NULL);
	if (args_length1 < 1) {
		fprintf (stdout, "Invalid number of arguments: %d\n", args_length1);
		domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
		return;
	}
	if (g_strcmp0 (args[0], "auto") != 0) {
		gchar** _tmp0_;
		gchar** _tmp1_;
		gchar** _tmp2_;
		_tmp0_ = (_tmp1_ = args, (_tmp1_ == NULL) ? ((gpointer) _tmp1_) : _vala_array_dup3 (_tmp1_, args_length1));
		_tmp2_ = _tmp0_;
		domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
		domains_length1 = args_length1;
		_domains_size_ = domains_length1;
		domains = _tmp2_;
	} else {
		gchar** _tmp3_ = NULL;
		gchar** _tmp4_;
		_tmp3_ = g_new0 (gchar*, 0 + 1);
		_tmp4_ = _tmp3_;
		domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
		domains_length1 = 0;
		_domains_size_ = domains_length1;
		domains = _tmp4_;
	}
	connman_service_set_domains_configuration (service, domains);
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
}


void edit_ipv4 (ConnmanService* service, gchar** args, int args_length1) {
	gchar* method = NULL;
	gchar* address = NULL;
	gchar* netmask = NULL;
	gchar* gateway = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GQuark _tmp3_;
	static GQuark _tmp3__label0 = 0;
	static GQuark _tmp3__label1 = 0;
	static GQuark _tmp3__label2 = 0;
	ConnmanIPv4* _tmp16_ = NULL;
	ConnmanIPv4* ipv4;
	GError * _inner_error_ = NULL;
	g_return_if_fail (service != NULL);
	if (args_length1 < 1) {
		fprintf (stdout, "Invalid number of arguments: %d\n", args_length1);
		_g_free0 (gateway);
		_g_free0 (netmask);
		_g_free0 (address);
		_g_free0 (method);
		return;
	}
	_tmp0_ = g_strdup (args[0]);
	_tmp1_ = _tmp0_;
	_g_free0 (method);
	method = _tmp1_;
	_tmp2_ = method;
	_tmp3_ = (NULL == _tmp2_) ? 0 : g_quark_from_string (_tmp2_);
	if ((_tmp3_ == ((0 != _tmp3__label0) ? _tmp3__label0 : (_tmp3__label0 = g_quark_from_static_string ("dhcp")))) || (_tmp3_ == ((0 != _tmp3__label1) ? _tmp3__label1 : (_tmp3__label1 = g_quark_from_static_string ("off"))))) {
		switch (0) {
			default:
			{
				gchar* _tmp4_;
				gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				_tmp4_ = g_strdup ("");
				_tmp5_ = _tmp4_;
				_g_free0 (address);
				address = _tmp5_;
				_tmp6_ = g_strdup ("");
				_tmp7_ = _tmp6_;
				_g_free0 (netmask);
				netmask = _tmp7_;
				_tmp8_ = g_strdup ("");
				_tmp9_ = _tmp8_;
				_g_free0 (gateway);
				gateway = _tmp9_;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp3__label2) ? _tmp3__label2 : (_tmp3__label2 = g_quark_from_static_string ("manual")))) {
		switch (0) {
			default:
			{
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				if (args_length1 < 4) {
					fprintf (stdout, "Invalid number of ipv4 arguments: %d\n", args_length1);
					_g_free0 (gateway);
					_g_free0 (netmask);
					_g_free0 (address);
					_g_free0 (method);
					return;
				}
				_tmp10_ = g_strdup (args[1]);
				_tmp11_ = _tmp10_;
				_g_free0 (address);
				address = _tmp11_;
				_tmp12_ = g_strdup (args[2]);
				_tmp13_ = _tmp12_;
				_g_free0 (netmask);
				netmask = _tmp13_;
				_tmp14_ = g_strdup (args[3]);
				_tmp15_ = _tmp14_;
				_g_free0 (gateway);
				gateway = _tmp15_;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				fprintf (stdout, "Unknown ipv4 method: %s\n", method);
				_g_free0 (gateway);
				_g_free0 (netmask);
				_g_free0 (address);
				_g_free0 (method);
				return;
			}
		}
	}
	_tmp16_ = connman_ipv4_new_with_strings (method, address, netmask, gateway, &_inner_error_);
	ipv4 = _tmp16_;
	if (_inner_error_ != NULL) {
		goto __catch0_g_error;
	}
	connman_service_set_ipv4_configuration (service, ipv4);
	_g_object_unref0 (ipv4);
	goto __finally0;
	__catch0_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stdout, "Failed to set ipv4 address: %s", e->message);
		_g_error_free0 (e);
		_g_free0 (gateway);
		_g_free0 (netmask);
		_g_free0 (address);
		_g_free0 (method);
		return;
	}
	__finally0:
	if (_inner_error_ != NULL) {
		_g_free0 (gateway);
		_g_free0 (netmask);
		_g_free0 (address);
		_g_free0 (method);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (gateway);
	_g_free0 (netmask);
	_g_free0 (address);
	_g_free0 (method);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


void edit (gchar** args, int args_length1) {
	gchar* _tmp0_;
	gchar* path;
	gchar* _tmp1_;
	gchar* property;
	gchar** _tmp2_ = NULL;
	gchar** edit_args;
	gint edit_args_length1;
	gint _edit_args_size_;
	ConnmanService* _tmp7_ = NULL;
	ConnmanService* _tmp8_;
	ConnmanService* service;
	const gchar* _tmp9_;
	GQuark _tmp10_;
	static GQuark _tmp10__label0 = 0;
	static GQuark _tmp10__label1 = 0;
	static GQuark _tmp10__label2 = 0;
	static GQuark _tmp10__label3 = 0;
	if (args_length1 < 2) {
		fprintf (stdout, "Invalid number of arguments: %d\n", args_length1);
		return;
	}
	_tmp0_ = g_strdup (args[0]);
	path = _tmp0_;
	_tmp1_ = g_strdup (args[1]);
	property = _tmp1_;
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	edit_args = _tmp2_;
	edit_args_length1 = 0;
	_edit_args_size_ = 0;
	if (args_length1 == 3) {
		gchar* _tmp3_;
		_tmp3_ = g_strdup (args[2]);
		_vala_array_add1 (&edit_args, &edit_args_length1, &_edit_args_size_, _tmp3_);
	} else {
		if (args_length1 > 3) {
			gchar** _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			_tmp4_ = (_tmp5_ = args + 2, (_tmp5_ == NULL) ? ((gpointer) _tmp5_) : _vala_array_dup4 (_tmp5_, args_length1 - 2));
			_tmp6_ = _tmp4_;
			edit_args = (_vala_array_free (edit_args, edit_args_length1, (GDestroyNotify) g_free), NULL);
			edit_args_length1 = args_length1 - 2;
			_edit_args_size_ = edit_args_length1;
			edit_args = _tmp6_;
		}
	}
	_tmp7_ = connman_manager_get_service (manager, path);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	service = _tmp8_;
	if (service == NULL) {
		fprintf (stdout, "service %s not found", path);
		_g_object_unref0 (service);
		edit_args = (_vala_array_free (edit_args, edit_args_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (property);
		_g_free0 (path);
		return;
	}
	_tmp9_ = property;
	_tmp10_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
	if (_tmp10_ == ((0 != _tmp10__label0) ? _tmp10__label0 : (_tmp10__label0 = g_quark_from_static_string ("passphrase")))) {
		switch (0) {
			default:
			{
				edit_passphrase (service, edit_args, edit_args_length1);
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label1) ? _tmp10__label1 : (_tmp10__label1 = g_quark_from_static_string ("nameservers")))) {
		switch (0) {
			default:
			{
				edit_nameservers (service, edit_args, edit_args_length1);
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label2) ? _tmp10__label2 : (_tmp10__label2 = g_quark_from_static_string ("domains")))) {
		switch (0) {
			default:
			{
				edit_domains (service, edit_args, edit_args_length1);
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label3) ? _tmp10__label3 : (_tmp10__label3 = g_quark_from_static_string ("ipv4")))) {
		switch (0) {
			default:
			{
				edit_ipv4 (service, edit_args, edit_args_length1);
				break;
			}
		}
	}
	_g_object_unref0 (service);
	edit_args = (_vala_array_free (edit_args, edit_args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (property);
	_g_free0 (path);
}


void tech (gchar** args, int args_length1) {
	ConnmanTechnologyState _tmp0_;
	ConnmanTechnologyState _tmp1_;
	ConnmanTechnologyState _tmp2_;
	ConnmanTechnologyState _tmp3_;
	_tmp0_ = connman_manager_get_wifi_state (manager);
	fprintf (stdout, "  wifi %d\n", (gint) _tmp0_);
	_tmp1_ = connman_manager_get_ethernet_state (manager);
	fprintf (stdout, "  ethernet %d\n", (gint) _tmp1_);
	_tmp2_ = connman_manager_get_cellular_state (manager);
	fprintf (stdout, "  cellular %d\n", (gint) _tmp2_);
	_tmp3_ = connman_manager_get_bluetooth_state (manager);
	fprintf (stdout, "  bluetooth %d\n", (gint) _tmp3_);
}


ConnmanTechnologyType str2tech (const gchar* s) {
	ConnmanTechnologyType result = 0;
	const gchar* _tmp0_;
	GQuark _tmp1_;
	static GQuark _tmp1__label0 = 0;
	static GQuark _tmp1__label1 = 0;
	static GQuark _tmp1__label2 = 0;
	static GQuark _tmp1__label3 = 0;
	g_return_val_if_fail (s != NULL, 0);
	_tmp0_ = s;
	_tmp1_ = (NULL == _tmp0_) ? 0 : g_quark_from_string (_tmp0_);
	if (_tmp1_ == ((0 != _tmp1__label0) ? _tmp1__label0 : (_tmp1__label0 = g_quark_from_static_string ("wifi")))) {
		switch (0) {
			default:
			{
				result = CONNMAN_TECHNOLOGY_TYPE_WIFI;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label1) ? _tmp1__label1 : (_tmp1__label1 = g_quark_from_static_string ("ethernet")))) {
		switch (0) {
			default:
			{
				result = CONNMAN_TECHNOLOGY_TYPE_ETHERNET;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label2) ? _tmp1__label2 : (_tmp1__label2 = g_quark_from_static_string ("cellular")))) {
		switch (0) {
			default:
			{
				result = CONNMAN_TECHNOLOGY_TYPE_CELLULAR;
				return result;
			}
		}
	} else if (_tmp1_ == ((0 != _tmp1__label3) ? _tmp1__label3 : (_tmp1__label3 = g_quark_from_static_string ("bluetooth")))) {
		switch (0) {
			default:
			{
				result = CONNMAN_TECHNOLOGY_TYPE_BLUETOOTH;
				return result;
			}
		}
	} else {
		switch (0) {
			default:
			{
				fprintf (stdout, "Unknown tech: %s\n", s);
				result = CONNMAN_TECHNOLOGY_TYPE_UNKNOWN;
				return result;
			}
		}
	}
}


void enable (gchar** args, int args_length1) {
	ConnmanTechnologyType _tmp0_;
	ConnmanTechnologyType tech;
	if (args_length1 != 1) {
		fprintf (stdout, "Invalid number of arguments for enable: %d\n", args_length1);
		return;
	}
	_tmp0_ = str2tech (args[0]);
	tech = _tmp0_;
	connman_manager_enable_technology (manager, tech, NULL, NULL, NULL);
}


void disable (gchar** args, int args_length1) {
	ConnmanTechnologyType _tmp0_;
	ConnmanTechnologyType tech;
	if (args_length1 != 1) {
		fprintf (stdout, "Invalid number of arguments for enable: %d\n", args_length1);
		return;
	}
	_tmp0_ = str2tech (args[0]);
	tech = _tmp0_;
	connman_manager_disable_technology (manager, tech, NULL, NULL, NULL);
}


void offline (gchar** args, int args_length1) {
	gchar* _tmp0_;
	gchar* mode;
	gboolean value = FALSE;
	const gchar* _tmp1_;
	GQuark _tmp2_;
	static GQuark _tmp2__label0 = 0;
	static GQuark _tmp2__label1 = 0;
	if (args_length1 != 1) {
		fprintf (stdout, "Invalid number of arguments for offline: %d\n", args_length1);
		return;
	}
	_tmp0_ = g_strdup (args[0]);
	mode = _tmp0_;
	_tmp1_ = mode;
	_tmp2_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp2_ == ((0 != _tmp2__label0) ? _tmp2__label0 : (_tmp2__label0 = g_quark_from_static_string ("on")))) {
		switch (0) {
			default:
			{
				value = TRUE;
				break;
			}
		}
	} else if (_tmp2_ == ((0 != _tmp2__label1) ? _tmp2__label1 : (_tmp2__label1 = g_quark_from_static_string ("off")))) {
		switch (0) {
			default:
			{
				value = FALSE;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				fprintf (stdout, "Unknown mode for offline: %s\n", mode);
				_g_free0 (mode);
				return;
			}
		}
	}
	connman_manager_set_offline_mode (manager, value);
	_g_free0 (mode);
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar** _vala_array_dup5 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		result[i] = g_strdup (self[i]);
	}
	return result;
}


gboolean cmd_handler (void) {
	gboolean result = FALSE;
	gpointer _tmp0_ = NULL;
	gchar* line;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gchar* _tmp3_;
	gchar* cmd;
	gchar** _tmp4_ = NULL;
	gchar** args;
	gint args_length1;
	gint _args_size_;
	const gchar* _tmp9_;
	GQuark _tmp10_;
	static GQuark _tmp10__label0 = 0;
	static GQuark _tmp10__label1 = 0;
	static GQuark _tmp10__label2 = 0;
	static GQuark _tmp10__label3 = 0;
	static GQuark _tmp10__label4 = 0;
	static GQuark _tmp10__label5 = 0;
	static GQuark _tmp10__label6 = 0;
	static GQuark _tmp10__label7 = 0;
	static GQuark _tmp10__label8 = 0;
	static GQuark _tmp10__label9 = 0;
	static GQuark _tmp10__label10 = 0;
	_tmp0_ = g_async_queue_pop (cmd_queue);
	line = (gchar*) _tmp0_;
	_tmp2_ = _tmp1_ = g_strsplit (line, " ", 0);
	tokens = _tmp2_;
	tokens_length1 = _vala_array_length (_tmp1_);
	_tokens_size_ = _vala_array_length (_tmp1_);
	_tmp3_ = g_strdup (tokens[0]);
	cmd = _tmp3_;
	_tmp4_ = g_new0 (gchar*, 0 + 1);
	args = _tmp4_;
	args_length1 = 0;
	_args_size_ = 0;
	if (tokens_length1 == 2) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (tokens[1]);
		_vala_array_add2 (&args, &args_length1, &_args_size_, _tmp5_);
	}
	if (tokens_length1 > 2) {
		gchar** _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		_tmp6_ = (_tmp7_ = tokens + 1, (_tmp7_ == NULL) ? ((gpointer) _tmp7_) : _vala_array_dup5 (_tmp7_, tokens_length1 - 1));
		_tmp8_ = _tmp6_;
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		args_length1 = tokens_length1 - 1;
		_args_size_ = args_length1;
		args = _tmp8_;
	}
	_tmp9_ = cmd;
	_tmp10_ = (NULL == _tmp9_) ? 0 : g_quark_from_string (_tmp9_);
	if ((_tmp10_ == ((0 != _tmp10__label0) ? _tmp10__label0 : (_tmp10__label0 = g_quark_from_static_string ("quit")))) || (_tmp10_ == ((0 != _tmp10__label1) ? _tmp10__label1 : (_tmp10__label1 = g_quark_from_static_string ("q"))))) {
		switch (0) {
			default:
			{
				quit ();
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label2) ? _tmp10__label2 : (_tmp10__label2 = g_quark_from_static_string ("list")))) {
		switch (0) {
			default:
			{
				list ();
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label3) ? _tmp10__label3 : (_tmp10__label3 = g_quark_from_static_string ("default-service")))) {
		switch (0) {
			default:
			{
				default_service ();
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label4) ? _tmp10__label4 : (_tmp10__label4 = g_quark_from_static_string ("status")))) {
		switch (0) {
			default:
			{
				status ();
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label5) ? _tmp10__label5 : (_tmp10__label5 = g_quark_from_static_string ("show")))) {
		switch (0) {
			default:
			{
				show (args, args_length1);
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label6) ? _tmp10__label6 : (_tmp10__label6 = g_quark_from_static_string ("edit")))) {
		switch (0) {
			default:
			{
				edit (args, args_length1);
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label7) ? _tmp10__label7 : (_tmp10__label7 = g_quark_from_static_string ("tech")))) {
		switch (0) {
			default:
			{
				tech (args, args_length1);
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label8) ? _tmp10__label8 : (_tmp10__label8 = g_quark_from_static_string ("enable")))) {
		switch (0) {
			default:
			{
				enable (args, args_length1);
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label9) ? _tmp10__label9 : (_tmp10__label9 = g_quark_from_static_string ("disable")))) {
		switch (0) {
			default:
			{
				disable (args, args_length1);
				break;
			}
		}
	} else if (_tmp10_ == ((0 != _tmp10__label10) ? _tmp10__label10 : (_tmp10__label10 = g_quark_from_static_string ("offline")))) {
		switch (0) {
			default:
			{
				offline (args, args_length1);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				fprintf (stdout, "Unknown command: %s\n", cmd);
				break;
			}
		}
	}
	result = FALSE;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (cmd);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (line);
	return result;
}


static gchar* __readline (const gchar* prompt) {
	gchar* result = NULL;
	void* _tmp0_ = NULL;
	void* cstr;
	gchar* _tmp1_ = NULL;
	gchar* str;
	_tmp0_ = readline (prompt);
	cstr = _tmp0_;
	if (cstr == NULL) {
		result = NULL;
		return result;
	}
	_tmp1_ = g_strdup ((const gchar*) cstr);
	str = _tmp1_;
	free (cstr);
	result = str;
	return result;
}


static gboolean _cmd_handler_gsource_func (gpointer self) {
	gboolean result;
	result = cmd_handler ();
	return result;
}


void* input_handler (void) {
	void* result = NULL;
	gboolean quit;
	quit = FALSE;
	while (TRUE) {
		gchar* _tmp0_ = NULL;
		gchar* line;
		gchar* _tmp3_;
		if (!(!quit)) {
			break;
		}
		_tmp0_ = __readline ("> ");
		line = _tmp0_;
		if (g_strcmp0 (line, "") == 0) {
			_g_free0 (line);
			continue;
		} else {
			if (line == NULL) {
				gchar* _tmp1_;
				gchar* _tmp2_;
				fprintf (stdout, "Stream closed\n");
				_tmp1_ = g_strdup ("quit");
				_tmp2_ = _tmp1_;
				_g_free0 (line);
				line = _tmp2_;
			}
		}
		add_history (line);
		_tmp3_ = g_strdup (line);
		g_async_queue_push (cmd_queue, _tmp3_);
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _cmd_handler_gsource_func, NULL, NULL);
		_g_free0 (line);
	}
	result = NULL;
	return result;
}


static gpointer _input_handler_gthread_func (gpointer self) {
	gpointer result;
	result = input_handler ();
	return result;
}


static void _lambda0_ (GObject* s, GParamSpec* p) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = connman_manager_get_connected (manager);
	if (_tmp1_) {
		_tmp0_ = "connected";
	} else {
		_tmp0_ = "disconnected";
	}
	fprintf (stdout, "%s\n", _tmp0_);
}


static void __lambda0__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda0_ (_sender, pspec);
}


static void _lambda1_ (GObject* s, GParamSpec* p) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_wifi_state (manager);
	fprintf (stdout, "wifi-state %d\n", (gint) _tmp0_);
}


static void __lambda1__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda1_ (_sender, pspec);
}


static void _lambda2_ (GObject* s, GParamSpec* p) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_ethernet_state (manager);
	fprintf (stdout, "ethernet-state %d\n", (gint) _tmp0_);
}


static void __lambda2__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda2_ (_sender, pspec);
}


static void _lambda3_ (GObject* s, GParamSpec* p) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_cellular_state (manager);
	fprintf (stdout, "cellular-state %d\n", (gint) _tmp0_);
}


static void __lambda3__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda3_ (_sender, pspec);
}


static void _lambda4_ (GObject* s, GParamSpec* p) {
	ConnmanTechnologyState _tmp0_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = connman_manager_get_bluetooth_state (manager);
	fprintf (stdout, "bluetooth-state %d\n", (gint) _tmp0_);
}


static void __lambda4__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda4_ (_sender, pspec);
}


static void _lambda5_ (GObject* s, GParamSpec* p) {
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_;
	g_return_if_fail (s != NULL);
	g_return_if_fail (p != NULL);
	_tmp1_ = connman_manager_get_offline_mode (manager);
	if (_tmp1_) {
		_tmp0_ = "on";
	} else {
		_tmp0_ = "off";
	}
	fprintf (stdout, "offline-mode %s\n", _tmp0_);
}


static void __lambda5__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda5_ (_sender, pspec);
}


gint _vala_main (void) {
	gint result = 0;
	ConnmanManager* _tmp0_ = NULL;
	ConnmanManager* _tmp1_;
	GMainLoop* _tmp2_ = NULL;
	GMainLoop* _tmp3_;
	GAsyncQueue* _tmp4_ = NULL;
	GAsyncQueue* _tmp5_;
	gboolean _tmp6_;
	GError * _inner_error_ = NULL;
	_tmp0_ = connman_manager_new ();
	_tmp1_ = _tmp0_;
	_g_object_unref0 (manager);
	manager = _tmp1_;
	_tmp2_ = g_main_loop_new (NULL, FALSE);
	_tmp3_ = _tmp2_;
	_g_main_loop_unref0 (loop);
	loop = _tmp3_;
	_tmp4_ = g_async_queue_new ();
	_tmp5_ = _tmp4_;
	_g_async_queue_unref0 (cmd_queue);
	cmd_queue = _tmp5_;
	_tmp6_ = g_thread_supported ();
	if (!_tmp6_) {
		fprintf (stderr, "Cannot run without threads.\n");
		result = 1;
		return result;
	}
	g_thread_create (_input_handler_gthread_func, NULL, FALSE, &_inner_error_);
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_THREAD_ERROR) {
			goto __catch1_g_thread_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	goto __finally1;
	__catch1_g_thread_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Failed to create thread.\n");
		result = 1;
		_g_error_free0 (e);
		return result;
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return 0;
	}
	g_signal_connect ((GObject*) manager, "notify::connected", (GCallback) __lambda0__g_object_notify, NULL);
	g_signal_connect ((GObject*) manager, "notify::wifi-state", (GCallback) __lambda1__g_object_notify, NULL);
	g_signal_connect ((GObject*) manager, "notify::ethernet-state", (GCallback) __lambda2__g_object_notify, NULL);
	g_signal_connect ((GObject*) manager, "notify::cellular-state", (GCallback) __lambda3__g_object_notify, NULL);
	g_signal_connect ((GObject*) manager, "notify::bluetooth-state", (GCallback) __lambda4__g_object_notify, NULL);
	g_signal_connect ((GObject*) manager, "notify::offline-mode", (GCallback) __lambda5__g_object_notify, NULL);
	g_main_loop_run (loop);
	result = 0;
	return result;
}


int main (int argc, char ** argv) {
	g_type_init ();
	return _vala_main ();
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



