/* toggleswitch.c generated by valac 0.11.6, the Vala compiler
 * generated from toggleswitch.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <atk/atk.h>
#include <gdk/gdk.h>
#include <cairo.h>


#define TYPE_TOGGLE_SWITCH (toggle_switch_get_type ())
#define TOGGLE_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TOGGLE_SWITCH, ToggleSwitch))
#define TOGGLE_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TOGGLE_SWITCH, ToggleSwitchClass))
#define IS_TOGGLE_SWITCH(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TOGGLE_SWITCH))
#define IS_TOGGLE_SWITCH_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TOGGLE_SWITCH))
#define TOGGLE_SWITCH_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TOGGLE_SWITCH, ToggleSwitchClass))

typedef struct _ToggleSwitch ToggleSwitch;
typedef struct _ToggleSwitchClass ToggleSwitchClass;
typedef struct _ToggleSwitchPrivate ToggleSwitchPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _ToggleSwitch {
	GtkEventBox parent_instance;
	ToggleSwitchPrivate * priv;
	gboolean active;
};

struct _ToggleSwitchClass {
	GtkEventBoxClass parent_class;
};

struct _ToggleSwitchPrivate {
	gdouble LINE_HEIGHT_RATIO;
	gdouble LINE_SPACING_RATIO;
	gdouble CORNER_RADIUS;
	gdouble TEXT_XPAD;
	gdouble TEXT_YPAD;
	gchar** values;
	gint values_length1;
	gint _values_size_;
	PangoLayout* layout;
	AtkObject* atk;
};


static gpointer toggle_switch_parent_class = NULL;

GType toggle_switch_get_type (void) G_GNUC_CONST;
#define TOGGLE_SWITCH_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_TOGGLE_SWITCH, ToggleSwitchPrivate))
enum  {
	TOGGLE_SWITCH_DUMMY_PROPERTY
};
ToggleSwitch* toggle_switch_new (void);
ToggleSwitch* toggle_switch_construct (GType object_type);
static void toggle_switch_on_style_set (ToggleSwitch* self, GtkStyle* style);
static void _toggle_switch_on_style_set_gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self);
static gboolean toggle_switch_on_expose_event (ToggleSwitch* self, GdkEventExpose* event);
static gboolean _toggle_switch_on_expose_event_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self);
static gboolean toggle_switch_on_press (ToggleSwitch* self, GdkEventButton* event);
static gboolean _toggle_switch_on_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean toggle_switch_on_release (ToggleSwitch* self, GdkEventButton* event);
static gboolean _toggle_switch_on_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static gboolean toggle_switch_on_key_release (ToggleSwitch* self, GdkEventKey* event);
static gboolean _toggle_switch_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static gboolean toggle_switch_on_enter (ToggleSwitch* self, GdkEventCrossing* event);
static gboolean _toggle_switch_on_enter_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean toggle_switch_on_leave (ToggleSwitch* self, GdkEventCrossing* event);
static gboolean _toggle_switch_on_leave_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self);
static gboolean toggle_switch_on_motion_notify_event (ToggleSwitch* self, GdkEventMotion* event);
static gboolean _toggle_switch_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self);
static void toggle_switch_calculate_size (ToggleSwitch* self, gint* width, gint* height);
static void toggle_switch_update_atk (ToggleSwitch* self);
static void toggle_switch_draw_widget (ToggleSwitch* self);
static void toggle_switch_draw_background (ToggleSwitch* self, cairo_t* cr);
static void toggle_switch_draw_text (ToggleSwitch* self);
static void toggle_switch_draw_slider (ToggleSwitch* self, cairo_t* cr);
static void toggle_switch_draw_flat_rounded_rectangle (ToggleSwitch* self, cairo_t* cr, gdouble x, gdouble y, gdouble w, gdouble h, GdkColor* stroke, GdkColor* fill);
static void toggle_switch_draw_rounded_rectangle (ToggleSwitch* self, cairo_t* cr, gdouble x, gdouble y, gdouble w, gdouble h, GdkColor* stroke, GdkColor* fill1, GdkColor* fill2);
static void toggle_switch_draw_vertical_lines (ToggleSwitch* self, cairo_t* cr, gint x, gint y, gint width, gint height);
static void toggle_switch_draw_centered_text (ToggleSwitch* self, const gchar* text, const gchar* gravity);
#define PI 3.1415926535897931
#define PI_OVER_180 0.017453292519943295
gboolean toggle_switch_get_active (ToggleSwitch* self);
void toggle_switch_set_active (ToggleSwitch* self, gboolean active);
static void toggle_switch_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _toggle_switch_on_style_set_gtk_widget_style_set (GtkWidget* _sender, GtkStyle* previous_style, gpointer self) {
	toggle_switch_on_style_set (self, previous_style);
}


static gboolean _toggle_switch_on_expose_event_gtk_widget_expose_event (GtkWidget* _sender, GdkEventExpose* event, gpointer self) {
	gboolean result;
	result = toggle_switch_on_expose_event (self, event);
	return result;
}


static gboolean _toggle_switch_on_press_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = toggle_switch_on_press (self, event);
	return result;
}


static gboolean _toggle_switch_on_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = toggle_switch_on_release (self, event);
	return result;
}


static gboolean _toggle_switch_on_key_release_gtk_widget_key_release_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = toggle_switch_on_key_release (self, event);
	return result;
}


static gboolean _toggle_switch_on_enter_gtk_widget_enter_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = toggle_switch_on_enter (self, event);
	return result;
}


static gboolean _toggle_switch_on_leave_gtk_widget_leave_notify_event (GtkWidget* _sender, GdkEventCrossing* event, gpointer self) {
	gboolean result;
	result = toggle_switch_on_leave (self, event);
	return result;
}


static gboolean _toggle_switch_on_motion_notify_event_gtk_widget_motion_notify_event (GtkWidget* _sender, GdkEventMotion* event, gpointer self) {
	gboolean result;
	result = toggle_switch_on_motion_notify_event (self, event);
	return result;
}


ToggleSwitch* toggle_switch_construct (GType object_type) {
	ToggleSwitch * self = NULL;
	gint calc_width = 0;
	gint calc_height = 0;
	gint _tmp0_;
	gint _tmp1_;
	self = (ToggleSwitch*) g_object_new (object_type, NULL);
	gtk_event_box_set_visible_window ((GtkEventBox*) self, FALSE);
	gtk_widget_set_app_paintable ((GtkWidget*) self, TRUE);
	gtk_widget_set_double_buffered ((GtkWidget*) self, FALSE);
	gtk_widget_set_can_focus ((GtkWidget*) self, TRUE);
	gtk_widget_set_events ((GtkWidget*) self, (gint) ((((GDK_KEY_PRESS_MASK | GDK_ENTER_NOTIFY_MASK) | GDK_LEAVE_NOTIFY_MASK) | GDK_BUTTON_PRESS_MASK) | GDK_BUTTON_RELEASE_MASK));
	g_signal_connect_object ((GtkWidget*) self, "style-set", (GCallback) _toggle_switch_on_style_set_gtk_widget_style_set, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "expose-event", (GCallback) _toggle_switch_on_expose_event_gtk_widget_expose_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _toggle_switch_on_press_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _toggle_switch_on_release_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-release-event", (GCallback) _toggle_switch_on_key_release_gtk_widget_key_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "enter-notify-event", (GCallback) _toggle_switch_on_enter_gtk_widget_enter_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _toggle_switch_on_leave_gtk_widget_leave_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _toggle_switch_on_motion_notify_event_gtk_widget_motion_notify_event, self, 0);
	toggle_switch_calculate_size (self, &_tmp0_, &_tmp1_);
	calc_width = _tmp0_;
	calc_height = _tmp1_;
	gtk_widget_set_size_request ((GtkWidget*) self, calc_width, calc_height);
	toggle_switch_update_atk (self);
	return self;
}


ToggleSwitch* toggle_switch_new (void) {
	return toggle_switch_construct (TYPE_TOGGLE_SWITCH);
}


static void toggle_switch_calculate_size (ToggleSwitch* self, gint* width, gint* height) {
	gint _width = 0;
	gint _height = 0;
	PangoLayout* _tmp0_ = NULL;
	PangoLayout* _tmp1_;
	PangoRectangle extents = {0};
	PangoRectangle _tmp2_ = {0};
	gint text_width;
	gint text_height;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->layout);
	self->priv->layout = _tmp1_;
	pango_layout_set_text (self->priv->layout, self->priv->values[0], -1);
	pango_layout_get_pixel_extents (self->priv->layout, NULL, &_tmp2_);
	extents = _tmp2_;
	text_width = extents.width;
	text_height = extents.height;
	_width = (gint) ((text_width + ((text_width * self->priv->TEXT_XPAD) * 2)) * 2);
	_height = (gint) (text_height + ((text_height * self->priv->TEXT_YPAD) * 2));
	if (width) {
		*width = _width;
	}
	if (height) {
		*height = _height;
	}
}


static void toggle_switch_draw_widget (ToggleSwitch* self) {
	cairo_t* _tmp0_ = NULL;
	cairo_t* cr;
	g_return_if_fail (self != NULL);
	_tmp0_ = gdk_cairo_create ((GdkDrawable*) ((GtkWidget*) self)->window);
	cr = _tmp0_;
	toggle_switch_draw_background (self, cr);
	toggle_switch_draw_text (self);
	toggle_switch_draw_slider (self, cr);
	_cairo_destroy0 (cr);
}


static void toggle_switch_draw_background (ToggleSwitch* self, cairo_t* cr) {
	gint x;
	gint y;
	gint width;
	gint height;
	guchar state;
	GtkStyle* _tmp0_ = NULL;
	GdkColor bg_fill;
	GtkStyle* _tmp1_ = NULL;
	GdkColor bg_stroke;
	GtkStyle* _tmp2_ = NULL;
	GdkColor left_fill;
	GtkStyle* _tmp3_ = NULL;
	GdkColor left_stroke;
	GtkStyle* _tmp4_ = NULL;
	GdkColor right_fill;
	GtkStyle* _tmp5_ = NULL;
	GdkColor right_stroke;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	x = ((GtkWidget*) self)->allocation.x;
	y = ((GtkWidget*) self)->allocation.y;
	width = ((GtkWidget*) self)->allocation.width;
	height = ((GtkWidget*) self)->allocation.height;
	state = ((GtkWidget*) self)->state;
	if ((((GtkWidget*) self)->state == GTK_STATE_PRELIGHT) | (((GtkWidget*) self)->state == GTK_STATE_ACTIVE)) {
		state = (guchar) GTK_STATE_NORMAL;
	}
	_tmp0_ = gtk_widget_get_style ((GtkWidget*) self);
	bg_fill = _tmp0_->base[state];
	_tmp1_ = gtk_widget_get_style ((GtkWidget*) self);
	bg_stroke = _tmp1_->dark[state];
	_tmp2_ = gtk_widget_get_style ((GtkWidget*) self);
	left_fill = _tmp2_->light[GTK_STATE_SELECTED];
	_tmp3_ = gtk_widget_get_style ((GtkWidget*) self);
	left_stroke = _tmp3_->mid[GTK_STATE_SELECTED];
	_tmp4_ = gtk_widget_get_style ((GtkWidget*) self);
	right_fill = _tmp4_->base[state];
	_tmp5_ = gtk_widget_get_style ((GtkWidget*) self);
	right_stroke = _tmp5_->dark[state];
	toggle_switch_draw_flat_rounded_rectangle (self, cr, (gdouble) x, (gdouble) y, (gdouble) width, (gdouble) height, &bg_stroke, &bg_fill);
	toggle_switch_draw_flat_rounded_rectangle (self, cr, (gdouble) x, (gdouble) y, (gdouble) (width / 2), (gdouble) height, &left_stroke, &left_fill);
	toggle_switch_draw_flat_rounded_rectangle (self, cr, (gdouble) (x + (width / 2)), (gdouble) y, (gdouble) (width / 2), (gdouble) height, &right_stroke, &right_fill);
}


static void toggle_switch_draw_slider (ToggleSwitch* self, cairo_t* cr) {
	gint x;
	gint y;
	gint width;
	gint height;
	gint x_offset;
	GtkStyle* _tmp0_ = NULL;
	GdkColor stroke;
	GdkColor fill1_rectangle = {0};
	GdkColor fill2_rectangle = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	x = ((GtkWidget*) self)->allocation.x;
	y = ((GtkWidget*) self)->allocation.y;
	width = ((GtkWidget*) self)->allocation.width;
	height = ((GtkWidget*) self)->allocation.height;
	x_offset = 0;
	if (self->active) {
		x_offset = width / 2;
	}
	_tmp0_ = gtk_widget_get_style ((GtkWidget*) self);
	stroke = _tmp0_->dark[((GtkWidget*) self)->state];
	if (((GtkWidget*) self)->state == GTK_STATE_INSENSITIVE) {
		GtkStyle* _tmp1_ = NULL;
		GtkStyle* _tmp2_ = NULL;
		_tmp1_ = gtk_widget_get_style ((GtkWidget*) self);
		fill1_rectangle = _tmp1_->bg[((GtkWidget*) self)->state];
		_tmp2_ = gtk_widget_get_style ((GtkWidget*) self);
		fill2_rectangle = _tmp2_->bg[((GtkWidget*) self)->state];
	} else {
		GtkStyle* _tmp3_ = NULL;
		GtkStyle* _tmp4_ = NULL;
		_tmp3_ = gtk_widget_get_style ((GtkWidget*) self);
		fill1_rectangle = _tmp3_->light[((GtkWidget*) self)->state];
		_tmp4_ = gtk_widget_get_style ((GtkWidget*) self);
		fill2_rectangle = _tmp4_->mid[((GtkWidget*) self)->state];
	}
	toggle_switch_draw_rounded_rectangle (self, cr, (gdouble) (x + x_offset), (gdouble) y, (gdouble) (width / 2), (gdouble) height, &stroke, &fill1_rectangle, &fill2_rectangle);
	toggle_switch_draw_vertical_lines (self, cr, x + x_offset, y, width, height);
}


static void toggle_switch_draw_vertical_lines (ToggleSwitch* self, cairo_t* cr, gint x, gint y, gint width, gint height) {
	GtkStyle* _tmp0_ = NULL;
	GdkColor fill_line_dark;
	GtkStyle* _tmp1_ = NULL;
	GdkColor fill_line_light;
	gdouble line_height;
	gint line_spacing;
	gint x_offset;
	gdouble y_offset;
	gdouble c_spacing;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	_tmp0_ = gtk_widget_get_style ((GtkWidget*) self);
	fill_line_dark = _tmp0_->dark[((GtkWidget*) self)->state];
	_tmp1_ = gtk_widget_get_style ((GtkWidget*) self);
	fill_line_light = _tmp1_->light[((GtkWidget*) self)->state];
	line_height = ((gint) height) * self->priv->LINE_HEIGHT_RATIO;
	line_spacing = (gint) (self->priv->LINE_SPACING_RATIO * (width / 2));
	x_offset = (((width / 2) - (6 + (line_spacing * 2))) / 2) + 2;
	y_offset = (height - line_height) / 2;
	c_spacing = (gdouble) 0;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp2_;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					i++;
				}
				_tmp2_ = FALSE;
				if (!(i < 3)) {
					break;
				}
				cairo_rectangle (cr, ((x + x_offset) + c_spacing) + 1, y + y_offset, (gdouble) 1, line_height);
				cairo_set_source_rgb (cr, ((gdouble) fill_line_dark.red) / 65535.0, ((gdouble) fill_line_dark.green) / 65535.0, ((gdouble) fill_line_dark.blue) / 65535.0);
				cairo_fill (cr);
				cairo_rectangle (cr, (x + x_offset) + c_spacing, y + y_offset, (gdouble) 1, line_height);
				cairo_set_source_rgb (cr, ((gdouble) fill_line_light.red) / 65535.0, ((gdouble) fill_line_light.green) / 65535.0, ((gdouble) fill_line_light.blue) / 65535.0);
				cairo_fill (cr);
				c_spacing = c_spacing + ((gdouble) line_spacing);
			}
		}
	}
}


static void toggle_switch_draw_text (ToggleSwitch* self) {
	g_return_if_fail (self != NULL);
	toggle_switch_draw_centered_text (self, self->priv->values[0], "left");
	toggle_switch_draw_centered_text (self, self->priv->values[1], "right");
}


static void toggle_switch_draw_centered_text (ToggleSwitch* self, const gchar* text, const gchar* gravity) {
	gint x;
	gint y;
	gint width;
	gint height;
	gint x_offset = 0;
	gint y_offset = 0;
	PangoRectangle extents = {0};
	PangoRectangle _tmp2_ = {0};
	gint text_width;
	gint text_height;
	GtkStyle* _tmp3_ = NULL;
	GtkStyle* _tmp4_;
	GtkStateType _tmp5_;
	GdkRectangle _tmp6_ = {0};
	GdkRectangle _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (text != NULL);
	g_return_if_fail (gravity != NULL);
	if (self->priv->layout == NULL) {
		PangoLayout* _tmp0_ = NULL;
		PangoLayout* _tmp1_;
		_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, NULL);
		_tmp1_ = _tmp0_;
		_g_object_unref0 (self->priv->layout);
		self->priv->layout = _tmp1_;
	}
	x = ((GtkWidget*) self)->allocation.x;
	y = ((GtkWidget*) self)->allocation.y;
	width = ((GtkWidget*) self)->allocation.width;
	height = ((GtkWidget*) self)->allocation.height;
	pango_layout_set_text (self->priv->layout, text, -1);
	pango_layout_get_pixel_extents (self->priv->layout, NULL, &_tmp2_);
	extents = _tmp2_;
	text_width = extents.width;
	text_height = extents.height;
	x_offset = ((width / 2) - text_width) / 2;
	if (g_strcmp0 (gravity, "right") == 0) {
		x_offset = x_offset + (width / 2);
	}
	y_offset = (height - text_height) / 2;
	_tmp3_ = gtk_widget_get_style ((GtkWidget*) self);
	_tmp5_ = gtk_widget_get_state ((GtkWidget*) self);
	GTK_STYLE_GET_CLASS (_tmp4_ = _tmp3_)->draw_layout (_tmp4_, ((GtkWidget*) self)->window, _tmp5_, TRUE, (_tmp7_ = (_tmp6_.x = x, _tmp6_.y = y, _tmp6_.width = width, _tmp6_.height = height, _tmp6_), &_tmp7_), (GtkWidget*) self, "", x + x_offset, y + y_offset, self->priv->layout);
}


static void toggle_switch_draw_rounded_rectangle (ToggleSwitch* self, cairo_t* cr, gdouble x, gdouble y, gdouble w, gdouble h, GdkColor* stroke, GdkColor* fill1, GdkColor* fill2) {
	gdouble r;
	cairo_pattern_t* _tmp0_ = NULL;
	cairo_pattern_t* linear;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	r = self->priv->CORNER_RADIUS;
	cairo_new_sub_path (cr);
	cairo_arc (cr, r + x, r + y, r, PI, 270 * PI_OVER_180);
	cairo_arc (cr, (x + w) - r, r + y, r, 270 * PI_OVER_180, (gdouble) 0);
	cairo_arc (cr, (x + w) - r, (y + h) - r, r, (gdouble) 0, 90 * PI_OVER_180);
	cairo_arc (cr, r + x, (y + h) - r, r, 90 * PI_OVER_180, PI);
	cairo_close_path (cr);
	cairo_set_source_rgb (cr, ((gdouble) (*stroke).red) / 65535.0, ((gdouble) (*stroke).green) / 65535.0, ((gdouble) (*stroke).blue) / 65535.0);
	cairo_stroke_preserve (cr);
	_tmp0_ = cairo_pattern_create_linear (x, y, x, y + h);
	linear = _tmp0_;
	cairo_pattern_add_color_stop_rgba (linear, 0.00, ((gdouble) (*fill1).red) / 65535.0, ((gdouble) (*fill1).green) / 65535.0, ((gdouble) (*fill1).blue) / 65535.0, (gdouble) 1);
	cairo_pattern_add_color_stop_rgba (linear, 0.8, ((gdouble) (*fill2).red) / 65535.0, ((gdouble) (*fill2).green) / 65535.0, ((gdouble) (*fill2).blue) / 65535.0, (gdouble) 1);
	cairo_set_source (cr, linear);
	cairo_fill (cr);
	_cairo_pattern_destroy0 (linear);
}


static void toggle_switch_draw_flat_rounded_rectangle (ToggleSwitch* self, cairo_t* cr, gdouble x, gdouble y, gdouble w, gdouble h, GdkColor* stroke, GdkColor* fill) {
	gdouble r;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	r = self->priv->CORNER_RADIUS;
	cairo_new_sub_path (cr);
	cairo_arc (cr, r + x, r + y, r, PI, 270 * PI_OVER_180);
	cairo_arc (cr, (x + w) - r, r + y, r, 270 * PI_OVER_180, (gdouble) 0);
	cairo_arc (cr, (x + w) - r, (y + h) - r, r, (gdouble) 0, 90 * PI_OVER_180);
	cairo_arc (cr, r + x, (y + h) - r, r, 90 * PI_OVER_180, PI);
	cairo_close_path (cr);
	cairo_set_source_rgb (cr, ((gdouble) (*stroke).red) / 65535.0, ((gdouble) (*stroke).green) / 65535.0, ((gdouble) (*stroke).blue) / 65535.0);
	cairo_stroke_preserve (cr);
	cairo_set_source_rgb (cr, ((gdouble) (*fill).red) / 65535.0, ((gdouble) (*fill).green) / 65535.0, ((gdouble) (*fill).blue) / 65535.0);
	cairo_fill (cr);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void toggle_switch_update_atk (ToggleSwitch* self) {
	g_return_if_fail (self != NULL);
	if (self->priv->atk == NULL) {
		AtkObject* _tmp0_ = NULL;
		AtkObject* _tmp1_;
		AtkObject* _tmp2_;
		_tmp0_ = gtk_widget_get_accessible ((GtkWidget*) self);
		_tmp1_ = _g_object_ref0 (_tmp0_);
		_tmp2_ = _tmp1_;
		_g_object_unref0 (self->priv->atk);
		self->priv->atk = _tmp2_;
		atk_object_set_role (self->priv->atk, ATK_ROLE_CHECK_BOX);
	}
	if (self->active) {
		atk_object_set_name (self->priv->atk, self->priv->values[0]);
	} else {
		atk_object_set_name (self->priv->atk, self->priv->values[1]);
	}
}


static void toggle_switch_on_style_set (ToggleSwitch* self, GtkStyle* style) {
	gint calc_width = 0;
	gint calc_height = 0;
	gint _tmp0_;
	gint _tmp1_;
	g_return_if_fail (self != NULL);
	toggle_switch_calculate_size (self, &_tmp0_, &_tmp1_);
	calc_width = _tmp0_;
	calc_height = _tmp1_;
	gtk_widget_set_size_request ((GtkWidget*) self, calc_width, calc_height);
}


static gboolean toggle_switch_on_expose_event (ToggleSwitch* self, GdkEventExpose* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	toggle_switch_draw_widget (self);
	result = TRUE;
	return result;
}


static gboolean toggle_switch_on_press (ToggleSwitch* self, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_set_state ((GtkWidget*) self, GTK_STATE_ACTIVE);
	gtk_widget_grab_focus ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean toggle_switch_on_release (ToggleSwitch* self, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_set_state ((GtkWidget*) self, GTK_STATE_PRELIGHT);
	self->active = !self->active;
	g_signal_emit_by_name (self, "toggled");
	result = FALSE;
	return result;
}


static gboolean toggle_switch_on_motion_notify_event (ToggleSwitch* self, GdkEventMotion* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}


static gboolean toggle_switch_on_key_release (ToggleSwitch* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((g_object_get ((GtkWidget*) self, "has-focus", &_tmp0_, NULL), _tmp0_)) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		_tmp1_ = gdk_keyval_name ((*event).keyval);
		_tmp2_ = gdk_keyval_name ((*event).keyval);
		if ((g_strcmp0 (_tmp1_, "Return") == 0) | (g_strcmp0 (_tmp2_, "Enter") == 0)) {
			g_signal_emit_by_name (self, "toggled");
		}
	}
	result = FALSE;
	return result;
}


static gboolean toggle_switch_on_enter (ToggleSwitch* self, GdkEventCrossing* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_set_state ((GtkWidget*) self, GTK_STATE_PRELIGHT);
	result = FALSE;
	return result;
}


static gboolean toggle_switch_on_leave (ToggleSwitch* self, GdkEventCrossing* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_widget_set_state ((GtkWidget*) self, GTK_STATE_NORMAL);
	result = FALSE;
	return result;
}


gboolean toggle_switch_get_active (ToggleSwitch* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->active;
	return result;
}


void toggle_switch_set_active (ToggleSwitch* self, gboolean active) {
	g_return_if_fail (self != NULL);
	self->active = active;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void toggle_switch_class_init (ToggleSwitchClass * klass) {
	toggle_switch_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ToggleSwitchPrivate));
	G_OBJECT_CLASS (klass)->finalize = toggle_switch_finalize;
	g_signal_new ("clicked", TYPE_TOGGLE_SWITCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("toggled", TYPE_TOGGLE_SWITCH, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void toggle_switch_instance_init (ToggleSwitch * self) {
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_ = NULL;
	self->priv = TOGGLE_SWITCH_GET_PRIVATE (self);
	self->priv->LINE_HEIGHT_RATIO = 9.0 / 25.0;
	self->priv->LINE_SPACING_RATIO = 5.0 / 38.0;
	self->priv->CORNER_RADIUS = 3.0;
	self->priv->TEXT_XPAD = 0.4;
	self->priv->TEXT_YPAD = 0.35;
	_tmp0_ = g_strdup ("ON");
	_tmp1_ = g_strdup ("OFF");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	self->priv->values = _tmp2_;
	self->priv->values_length1 = 2;
	self->priv->_values_size_ = self->priv->values_length1;
	self->priv->layout = NULL;
	self->priv->atk = NULL;
	self->active = FALSE;
}


static void toggle_switch_finalize (GObject* obj) {
	ToggleSwitch * self;
	self = TOGGLE_SWITCH (obj);
	self->priv->values = (_vala_array_free (self->priv->values, self->priv->values_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->layout);
	_g_object_unref0 (self->priv->atk);
	G_OBJECT_CLASS (toggle_switch_parent_class)->finalize (obj);
}


GType toggle_switch_get_type (void) {
	static volatile gsize toggle_switch_type_id__volatile = 0;
	if (g_once_init_enter (&toggle_switch_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ToggleSwitchClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) toggle_switch_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ToggleSwitch), 0, (GInstanceInitFunc) toggle_switch_instance_init, NULL };
		GType toggle_switch_type_id;
		toggle_switch_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "ToggleSwitch", &g_define_type_info, 0);
		g_once_init_leave (&toggle_switch_type_id__volatile, toggle_switch_type_id);
	}
	return toggle_switch_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



