/* edit-connection.c generated by valac 0.11.6, the Vala compiler
 * generated from edit-connection.vala, do not modify */

/*
 * indicator-network - user interface for connman
 * Copyright 2010-2011 Canonical Ltd.
 *
 * Authors:
 * Andrew Higginson
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <connman-service.h>
#include <gtk/gtk.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <connman-ipv6.h>
#include <connman-ipv4.h>
#include <stdio.h>


#define TYPE_NOTEBOOK_PAGE (notebook_page_get_type ())

#define TYPE_EDIT_CONNECTION_DIALOG (edit_connection_dialog_get_type ())
#define EDIT_CONNECTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialog))
#define EDIT_CONNECTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialogClass))
#define IS_EDIT_CONNECTION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_EDIT_CONNECTION_DIALOG))
#define IS_EDIT_CONNECTION_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_EDIT_CONNECTION_DIALOG))
#define EDIT_CONNECTION_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialogClass))

typedef struct _EditConnectionDialog EditConnectionDialog;
typedef struct _EditConnectionDialogClass EditConnectionDialogClass;
typedef struct _EditConnectionDialogPrivate EditConnectionDialogPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	NOTEBOOK_PAGE_PAGE_MAIN = 0,
	NOTEBOOK_PAGE_PAGE_WIRELESS = 1,
	NOTEBOOK_PAGE_PAGE_CELLULAR = 2,
	NOTEBOOK_PAGE_PAGE_IPV4 = 3,
	NOTEBOOK_PAGE_PAGE_IPV6 = 4,
	NOTEBOOK_PAGE_PAGE_DNS = 5
} NotebookPage;

struct _EditConnectionDialog {
	GObject parent_instance;
	EditConnectionDialogPrivate * priv;
};

struct _EditConnectionDialogClass {
	GObjectClass parent_class;
};

struct _EditConnectionDialogPrivate {
	ConnmanService* connection;
	GtkBuilder* builder;
	GtkWindow* dialog;
	GtkTable* table_main;
	GtkButton* button_save;
	GtkButton* button_cancel;
	GtkLabel* label_name;
	GtkCheckButton* checkbutton_autoconnect;
	GtkLabel* label_mode;
	GtkLabel* label_security;
	GtkEntry* entry_passphrase;
	GtkComboBox* combobox_ipv4_method;
	GtkEntry* entry_ipv4_address;
	GtkEntry* entry_ipv4_netmask;
	GtkEntry* entry_ipv4_gateway;
	GtkTreeIter ipv4_off_iter;
	GtkTreeIter ipv4_manual_iter;
	GtkTreeIter ipv4_dhcp_iter;
	GtkComboBox* combobox_ipv6_method;
	GtkEntry* entry_ipv6_address;
	GtkEntry* entry_ipv6_prefix_length;
	GtkEntry* entry_ipv6_gateway;
	GtkTreeIter ipv6_off_iter;
	GtkTreeIter ipv6_manual_iter;
	GtkTreeIter ipv6_auto_iter;
	GtkEntry* entry_nameservers;
	GtkEntry* entry_domains;
	GtkNotebook* notebook_sections;
	GeeArrayList* pages;
	gchar** hint_labels;
	gint hint_labels_length1;
	gint _hint_labels_size_;
};

struct _Block3Data {
	int _ref_count_;
	EditConnectionDialog * self;
	GtkWidget* hint_label_widget;
};


static gpointer edit_connection_dialog_parent_class = NULL;

GType notebook_page_get_type (void) G_GNUC_CONST;
GType edit_connection_dialog_get_type (void) G_GNUC_CONST;
#define EDIT_CONNECTION_DIALOG_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_EDIT_CONNECTION_DIALOG, EditConnectionDialogPrivate))
enum  {
	EDIT_CONNECTION_DIALOG_DUMMY_PROPERTY
};
EditConnectionDialog* edit_connection_dialog_new (ConnmanService* connection, const gchar* datadir);
EditConnectionDialog* edit_connection_dialog_construct (GType object_type, ConnmanService* connection, const gchar* datadir);
static void edit_connection_dialog_select_pages (EditConnectionDialog* self);
GtkBuilder* utils_gui_new_builder (const gchar* path);
static void edit_connection_dialog_get_widgets (EditConnectionDialog* self);
static void edit_connection_dialog_create_extra_widgets (EditConnectionDialog* self);
static void edit_connection_dialog_connect_signals (EditConnectionDialog* self);
static void edit_connection_dialog_update_widget_values (EditConnectionDialog* self);
static void edit_connection_dialog_update_tabs (EditConnectionDialog* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (Block3Data* _data3_);
static void _lambda3_ (Block3Data* _data3_);
static void __lambda3__gtk_widget_realize (GtkWidget* _sender, gpointer self);
static void edit_connection_dialog_on_button_save_clicked (EditConnectionDialog* self);
static void _edit_connection_dialog_on_button_save_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void edit_connection_dialog_on_button_cancel_clicked (EditConnectionDialog* self);
static void _edit_connection_dialog_on_button_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self);
static void edit_connection_dialog_ipv4_method_changed (EditConnectionDialog* self, GtkComboBox* box);
static void _edit_connection_dialog_ipv4_method_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void edit_connection_dialog_ipv6_method_changed (EditConnectionDialog* self, GtkComboBox* box);
static void _edit_connection_dialog_ipv6_method_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self);
static void edit_connection_dialog_update_mode (EditConnectionDialog* self);
static void edit_connection_dialog_update_name (EditConnectionDialog* self);
static void edit_connection_dialog_update_autoconnect (EditConnectionDialog* self);
static void edit_connection_dialog_save_autoconnect (EditConnectionDialog* self);
static void edit_connection_dialog_update_security (EditConnectionDialog* self);
static void edit_connection_dialog_update_passphrase (EditConnectionDialog* self);
static void edit_connection_dialog_save_passphrase (EditConnectionDialog* self);
static void edit_connection_dialog_update_ipv4 (EditConnectionDialog* self);
static void edit_connection_dialog_save_ipv4 (EditConnectionDialog* self);
static void edit_connection_dialog_update_ipv6 (EditConnectionDialog* self);
static void edit_connection_dialog_save_ipv6 (EditConnectionDialog* self);
static void edit_connection_dialog_update_nameservers (EditConnectionDialog* self);
static void edit_connection_dialog_save_nameservers (EditConnectionDialog* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void edit_connection_dialog_update_domains (EditConnectionDialog* self);
static void edit_connection_dialog_save_domains (EditConnectionDialog* self);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void edit_connection_dialog_save_widget_values (EditConnectionDialog* self);
gint edit_connection_dialog_run (EditConnectionDialog* self);
static void edit_connection_dialog_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GType notebook_page_get_type (void) {
	static volatile gsize notebook_page_type_id__volatile = 0;
	if (g_once_init_enter (&notebook_page_type_id__volatile)) {
		static const GEnumValue values[] = {{NOTEBOOK_PAGE_PAGE_MAIN, "NOTEBOOK_PAGE_PAGE_MAIN", "page-main"}, {NOTEBOOK_PAGE_PAGE_WIRELESS, "NOTEBOOK_PAGE_PAGE_WIRELESS", "page-wireless"}, {NOTEBOOK_PAGE_PAGE_CELLULAR, "NOTEBOOK_PAGE_PAGE_CELLULAR", "page-cellular"}, {NOTEBOOK_PAGE_PAGE_IPV4, "NOTEBOOK_PAGE_PAGE_IPV4", "page-ipv4"}, {NOTEBOOK_PAGE_PAGE_IPV6, "NOTEBOOK_PAGE_PAGE_IPV6", "page-ipv6"}, {NOTEBOOK_PAGE_PAGE_DNS, "NOTEBOOK_PAGE_PAGE_DNS", "page-dns"}, {0, NULL, NULL}};
		GType notebook_page_type_id;
		notebook_page_type_id = g_enum_register_static ("NotebookPage", values);
		g_once_init_leave (&notebook_page_type_id__volatile, notebook_page_type_id);
	}
	return notebook_page_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


EditConnectionDialog* edit_connection_dialog_construct (GType object_type, ConnmanService* connection, const gchar* datadir) {
	EditConnectionDialog * self = NULL;
	ConnmanService* _tmp0_;
	ConnmanService* _tmp1_;
	gchar* _tmp2_;
	GtkBuilder* _tmp3_ = NULL;
	GtkBuilder* _tmp4_;
	g_return_val_if_fail (connection != NULL, NULL);
	g_return_val_if_fail (datadir != NULL, NULL);
	self = (EditConnectionDialog*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (connection);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->connection);
	self->priv->connection = _tmp1_;
	edit_connection_dialog_select_pages (self);
	_tmp2_ = g_strconcat (datadir, "ui/edit_connection_dialog.ui", NULL);
	_tmp3_ = utils_gui_new_builder (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->builder);
	self->priv->builder = _tmp4_;
	_g_free0 (_tmp2_);
	edit_connection_dialog_get_widgets (self);
	edit_connection_dialog_create_extra_widgets (self);
	edit_connection_dialog_connect_signals (self);
	edit_connection_dialog_update_widget_values (self);
	edit_connection_dialog_update_tabs (self);
	return self;
}


EditConnectionDialog* edit_connection_dialog_new (ConnmanService* connection, const gchar* datadir) {
	return edit_connection_dialog_construct (TYPE_EDIT_CONNECTION_DIALOG, connection, datadir);
}


static void edit_connection_dialog_select_pages (EditConnectionDialog* self) {
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* pages;
	ConnmanServiceType _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (TYPE_NOTEBOOK_PAGE, NULL, NULL, NULL);
	pages = _tmp0_;
	_tmp1_ = connman_service_get_service_type (self->priv->connection);
	switch (_tmp1_) {
		case CONNMAN_SERVICE_TYPE_WIFI:
		{
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_MAIN));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_WIRELESS));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV4));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV6));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_DNS));
			break;
		}
		case CONNMAN_SERVICE_TYPE_ETHERNET:
		{
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_MAIN));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV4));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV6));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_DNS));
			break;
		}
		case CONNMAN_SERVICE_TYPE_CELLULAR:
		{
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_MAIN));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_CELLULAR));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV4));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV6));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_DNS));
			break;
		}
		case CONNMAN_SERVICE_TYPE_BLUETOOTH:
		{
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_MAIN));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV4));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV6));
			gee_abstract_collection_add ((GeeAbstractCollection*) pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_DNS));
			break;
		}
		default:
		break;
	}
	_tmp2_ = _g_object_ref0 (pages);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->pages);
	self->priv->pages = _tmp3_;
	_g_object_unref0 (pages);
}


static void edit_connection_dialog_update_tabs (EditConnectionDialog* self) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_DNS));
	if (!_tmp0_) {
		gtk_notebook_remove_page (self->priv->notebook_sections, (gint) NOTEBOOK_PAGE_PAGE_DNS);
	}
	_tmp1_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV6));
	if (!_tmp1_) {
		gtk_notebook_remove_page (self->priv->notebook_sections, (gint) NOTEBOOK_PAGE_PAGE_IPV6);
	}
	_tmp2_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_IPV4));
	if (!_tmp2_) {
		gtk_notebook_remove_page (self->priv->notebook_sections, (gint) NOTEBOOK_PAGE_PAGE_IPV4);
	}
	_tmp3_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_CELLULAR));
	if (!_tmp3_) {
		gtk_notebook_remove_page (self->priv->notebook_sections, (gint) NOTEBOOK_PAGE_PAGE_CELLULAR);
	}
	_tmp4_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_WIRELESS));
	if (!_tmp4_) {
		gtk_notebook_remove_page (self->priv->notebook_sections, (gint) NOTEBOOK_PAGE_PAGE_WIRELESS);
	}
	_tmp5_ = gee_abstract_collection_contains ((GeeAbstractCollection*) self->priv->pages, GINT_TO_POINTER (NOTEBOOK_PAGE_PAGE_MAIN));
	if (!_tmp5_) {
		gtk_notebook_remove_page (self->priv->notebook_sections, (gint) NOTEBOOK_PAGE_PAGE_MAIN);
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}


static void block3_data_unref (Block3Data* _data3_) {
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		_g_object_unref0 (_data3_->self);
		_g_object_unref0 (_data3_->hint_label_widget);
		g_slice_free (Block3Data, _data3_);
	}
}


static void _lambda3_ (Block3Data* _data3_) {
	EditConnectionDialog * self;
	GtkStateType _tmp0_;
	GtkStateType state;
	GtkStyle* _tmp1_ = NULL;
	GdkColor color;
	self = _data3_->self;
	_tmp0_ = gtk_widget_get_state (_data3_->hint_label_widget);
	state = _tmp0_;
	_tmp1_ = gtk_widget_get_style (_data3_->hint_label_widget);
	color = _tmp1_->text_aa[state];
	gtk_widget_modify_fg (_data3_->hint_label_widget, state, &color);
}


static void __lambda3__gtk_widget_realize (GtkWidget* _sender, gpointer self) {
	_lambda3_ (self);
}


static void edit_connection_dialog_create_extra_widgets (EditConnectionDialog* self) {
	GtkListStore* _tmp4_ = NULL;
	GtkListStore* store;
	GtkTreeIter iter = {0};
	GtkCellRendererText* _tmp5_ = NULL;
	GtkCellRendererText* cell;
	GtkTreeIter _tmp6_ = {0};
	GtkTreeIter _tmp7_ = {0};
	GtkTreeIter _tmp8_ = {0};
	GtkListStore* _tmp9_ = NULL;
	GtkListStore* _tmp10_;
	GtkCellRendererText* _tmp11_ = NULL;
	GtkCellRendererText* _tmp12_;
	GtkTreeIter _tmp13_ = {0};
	GtkTreeIter _tmp14_ = {0};
	GtkTreeIter _tmp15_ = {0};
	g_return_if_fail (self != NULL);
	{
		gchar** hint_label_collection;
		int hint_label_collection_length1;
		int hint_label_it;
		hint_label_collection = self->priv->hint_labels;
		hint_label_collection_length1 = self->priv->hint_labels_length1;
		for (hint_label_it = 0; hint_label_it < self->priv->hint_labels_length1; hint_label_it = hint_label_it + 1) {
			gchar* _tmp0_;
			gchar* hint_label;
			_tmp0_ = g_strdup (hint_label_collection[hint_label_it]);
			hint_label = _tmp0_;
			{
				Block3Data* _data3_;
				GObject* _tmp1_ = NULL;
				GObject* _tmp2_;
				GtkWidget* _tmp3_;
				_data3_ = g_slice_new0 (Block3Data);
				_data3_->_ref_count_ = 1;
				_data3_->self = g_object_ref (self);
				_tmp1_ = gtk_builder_get_object (self->priv->builder, hint_label);
				_tmp3_ = _g_object_ref0 ((_tmp2_ = _tmp1_, GTK_IS_WIDGET (_tmp2_) ? ((GtkWidget*) _tmp2_) : NULL));
				_data3_->hint_label_widget = _tmp3_;
				g_signal_connect_data (_data3_->hint_label_widget, "realize", (GCallback) __lambda3__gtk_widget_realize, block3_data_ref (_data3_), (GClosureNotify) block3_data_unref, 0);
				_g_free0 (hint_label);
				block3_data_unref (_data3_);
				_data3_ = NULL;
			}
		}
	}
	_tmp4_ = gtk_list_store_new (2, G_TYPE_INT, G_TYPE_STRING);
	store = _tmp4_;
	gtk_combo_box_set_model (self->priv->combobox_ipv4_method, (GtkTreeModel*) store);
	_tmp5_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	cell = g_object_ref_sink (_tmp5_);
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox_ipv4_method, (GtkCellRenderer*) cell, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox_ipv4_method, (GtkCellRenderer*) cell, "text", 1, NULL);
	gtk_list_store_append (store, &_tmp6_);
	iter = _tmp6_;
	gtk_list_store_set (store, &iter, 0, CONNMAN_IPV4_METHOD_OFF, 1, "Off", -1);
	self->priv->ipv4_off_iter = iter;
	gtk_list_store_append (store, &_tmp7_);
	iter = _tmp7_;
	gtk_list_store_set (store, &iter, 0, CONNMAN_IPV4_METHOD_MANUAL, 1, "Manual", -1);
	self->priv->ipv4_manual_iter = iter;
	gtk_list_store_append (store, &_tmp8_);
	iter = _tmp8_;
	gtk_list_store_set (store, &iter, 0, CONNMAN_IPV4_METHOD_DHCP, 1, "DHCP", -1);
	self->priv->ipv4_dhcp_iter = iter;
	_tmp9_ = gtk_list_store_new (2, G_TYPE_INT, G_TYPE_STRING);
	_tmp10_ = _tmp9_;
	_g_object_unref0 (store);
	store = _tmp10_;
	gtk_combo_box_set_model (self->priv->combobox_ipv6_method, (GtkTreeModel*) store);
	_tmp11_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	_tmp12_ = g_object_ref_sink (_tmp11_);
	_g_object_unref0 (cell);
	cell = _tmp12_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) self->priv->combobox_ipv6_method, (GtkCellRenderer*) cell, FALSE);
	gtk_cell_layout_set_attributes ((GtkCellLayout*) self->priv->combobox_ipv6_method, (GtkCellRenderer*) cell, "text", 1, NULL);
	gtk_list_store_append (store, &_tmp13_);
	iter = _tmp13_;
	gtk_list_store_set (store, &iter, 0, CONNMAN_IPV6_METHOD_OFF, 1, "Off", -1);
	self->priv->ipv6_off_iter = iter;
	gtk_list_store_append (store, &_tmp14_);
	iter = _tmp14_;
	gtk_list_store_set (store, &iter, 0, CONNMAN_IPV6_METHOD_MANUAL, 1, "Manual", -1);
	self->priv->ipv6_manual_iter = iter;
	gtk_list_store_append (store, &_tmp15_);
	iter = _tmp15_;
	gtk_list_store_set (store, &iter, 0, CONNMAN_IPV6_METHOD_AUTO, 1, "Auto", -1);
	self->priv->ipv6_auto_iter = iter;
	_g_object_unref0 (cell);
	_g_object_unref0 (store);
}


static void edit_connection_dialog_get_widgets (EditConnectionDialog* self) {
	GtkBuilder* _tmp0_;
	GtkBuilder* b;
	GObject* _tmp1_ = NULL;
	GObject* _tmp2_;
	GtkWindow* _tmp3_;
	GtkWindow* _tmp4_;
	GObject* _tmp5_ = NULL;
	GObject* _tmp6_;
	GtkTable* _tmp7_;
	GtkTable* _tmp8_;
	GObject* _tmp9_ = NULL;
	GObject* _tmp10_;
	GtkButton* _tmp11_;
	GtkButton* _tmp12_;
	GObject* _tmp13_ = NULL;
	GObject* _tmp14_;
	GtkButton* _tmp15_;
	GtkButton* _tmp16_;
	GObject* _tmp17_ = NULL;
	GObject* _tmp18_;
	GtkLabel* _tmp19_;
	GtkLabel* _tmp20_;
	GObject* _tmp21_ = NULL;
	GObject* _tmp22_;
	GtkCheckButton* _tmp23_;
	GtkCheckButton* _tmp24_;
	GObject* _tmp25_ = NULL;
	GObject* _tmp26_;
	GtkLabel* _tmp27_;
	GtkLabel* _tmp28_;
	GObject* _tmp29_ = NULL;
	GObject* _tmp30_;
	GtkLabel* _tmp31_;
	GtkLabel* _tmp32_;
	GObject* _tmp33_ = NULL;
	GObject* _tmp34_;
	GtkEntry* _tmp35_;
	GtkEntry* _tmp36_;
	GObject* _tmp37_ = NULL;
	GObject* _tmp38_;
	GtkComboBox* _tmp39_;
	GtkComboBox* _tmp40_;
	GObject* _tmp41_ = NULL;
	GObject* _tmp42_;
	GtkEntry* _tmp43_;
	GtkEntry* _tmp44_;
	GObject* _tmp45_ = NULL;
	GObject* _tmp46_;
	GtkEntry* _tmp47_;
	GtkEntry* _tmp48_;
	GObject* _tmp49_ = NULL;
	GObject* _tmp50_;
	GtkEntry* _tmp51_;
	GtkEntry* _tmp52_;
	GObject* _tmp53_ = NULL;
	GObject* _tmp54_;
	GtkComboBox* _tmp55_;
	GtkComboBox* _tmp56_;
	GObject* _tmp57_ = NULL;
	GObject* _tmp58_;
	GtkEntry* _tmp59_;
	GtkEntry* _tmp60_;
	GObject* _tmp61_ = NULL;
	GObject* _tmp62_;
	GtkEntry* _tmp63_;
	GtkEntry* _tmp64_;
	GObject* _tmp65_ = NULL;
	GObject* _tmp66_;
	GtkEntry* _tmp67_;
	GtkEntry* _tmp68_;
	GObject* _tmp69_ = NULL;
	GObject* _tmp70_;
	GtkEntry* _tmp71_;
	GtkEntry* _tmp72_;
	GObject* _tmp73_ = NULL;
	GObject* _tmp74_;
	GtkEntry* _tmp75_;
	GtkEntry* _tmp76_;
	GObject* _tmp77_ = NULL;
	GObject* _tmp78_;
	GtkNotebook* _tmp79_;
	GtkNotebook* _tmp80_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_object_ref0 (self->priv->builder);
	b = _tmp0_;
	_tmp1_ = gtk_builder_get_object (b, "window_main");
	_tmp3_ = _g_object_ref0 ((_tmp2_ = _tmp1_, GTK_IS_WINDOW (_tmp2_) ? ((GtkWindow*) _tmp2_) : NULL));
	_tmp4_ = _tmp3_;
	_g_object_unref0 (self->priv->dialog);
	self->priv->dialog = _tmp4_;
	_tmp5_ = gtk_builder_get_object (b, "table_main");
	_tmp7_ = _g_object_ref0 ((_tmp6_ = _tmp5_, GTK_IS_TABLE (_tmp6_) ? ((GtkTable*) _tmp6_) : NULL));
	_tmp8_ = _tmp7_;
	_g_object_unref0 (self->priv->table_main);
	self->priv->table_main = _tmp8_;
	_tmp9_ = gtk_builder_get_object (b, "button_save");
	_tmp11_ = _g_object_ref0 ((_tmp10_ = _tmp9_, GTK_IS_BUTTON (_tmp10_) ? ((GtkButton*) _tmp10_) : NULL));
	_tmp12_ = _tmp11_;
	_g_object_unref0 (self->priv->button_save);
	self->priv->button_save = _tmp12_;
	_tmp13_ = gtk_builder_get_object (b, "button_cancel");
	_tmp15_ = _g_object_ref0 ((_tmp14_ = _tmp13_, GTK_IS_BUTTON (_tmp14_) ? ((GtkButton*) _tmp14_) : NULL));
	_tmp16_ = _tmp15_;
	_g_object_unref0 (self->priv->button_cancel);
	self->priv->button_cancel = _tmp16_;
	_tmp17_ = gtk_builder_get_object (b, "label_name");
	_tmp19_ = _g_object_ref0 ((_tmp18_ = _tmp17_, GTK_IS_LABEL (_tmp18_) ? ((GtkLabel*) _tmp18_) : NULL));
	_tmp20_ = _tmp19_;
	_g_object_unref0 (self->priv->label_name);
	self->priv->label_name = _tmp20_;
	_tmp21_ = gtk_builder_get_object (b, "checkbutton_autoconnect");
	_tmp23_ = _g_object_ref0 ((_tmp22_ = _tmp21_, GTK_IS_CHECK_BUTTON (_tmp22_) ? ((GtkCheckButton*) _tmp22_) : NULL));
	_tmp24_ = _tmp23_;
	_g_object_unref0 (self->priv->checkbutton_autoconnect);
	self->priv->checkbutton_autoconnect = _tmp24_;
	_tmp25_ = gtk_builder_get_object (b, "label_mode");
	_tmp27_ = _g_object_ref0 ((_tmp26_ = _tmp25_, GTK_IS_LABEL (_tmp26_) ? ((GtkLabel*) _tmp26_) : NULL));
	_tmp28_ = _tmp27_;
	_g_object_unref0 (self->priv->label_mode);
	self->priv->label_mode = _tmp28_;
	_tmp29_ = gtk_builder_get_object (b, "label_security");
	_tmp31_ = _g_object_ref0 ((_tmp30_ = _tmp29_, GTK_IS_LABEL (_tmp30_) ? ((GtkLabel*) _tmp30_) : NULL));
	_tmp32_ = _tmp31_;
	_g_object_unref0 (self->priv->label_security);
	self->priv->label_security = _tmp32_;
	_tmp33_ = gtk_builder_get_object (b, "entry_passphrase");
	_tmp35_ = _g_object_ref0 ((_tmp34_ = _tmp33_, GTK_IS_ENTRY (_tmp34_) ? ((GtkEntry*) _tmp34_) : NULL));
	_tmp36_ = _tmp35_;
	_g_object_unref0 (self->priv->entry_passphrase);
	self->priv->entry_passphrase = _tmp36_;
	_tmp37_ = gtk_builder_get_object (b, "combobox_ipv4_method");
	_tmp39_ = _g_object_ref0 ((_tmp38_ = _tmp37_, GTK_IS_COMBO_BOX (_tmp38_) ? ((GtkComboBox*) _tmp38_) : NULL));
	_tmp40_ = _tmp39_;
	_g_object_unref0 (self->priv->combobox_ipv4_method);
	self->priv->combobox_ipv4_method = _tmp40_;
	_tmp41_ = gtk_builder_get_object (b, "entry_ipv4_address");
	_tmp43_ = _g_object_ref0 ((_tmp42_ = _tmp41_, GTK_IS_ENTRY (_tmp42_) ? ((GtkEntry*) _tmp42_) : NULL));
	_tmp44_ = _tmp43_;
	_g_object_unref0 (self->priv->entry_ipv4_address);
	self->priv->entry_ipv4_address = _tmp44_;
	_tmp45_ = gtk_builder_get_object (b, "entry_ipv4_netmask");
	_tmp47_ = _g_object_ref0 ((_tmp46_ = _tmp45_, GTK_IS_ENTRY (_tmp46_) ? ((GtkEntry*) _tmp46_) : NULL));
	_tmp48_ = _tmp47_;
	_g_object_unref0 (self->priv->entry_ipv4_netmask);
	self->priv->entry_ipv4_netmask = _tmp48_;
	_tmp49_ = gtk_builder_get_object (b, "entry_ipv4_gateway");
	_tmp51_ = _g_object_ref0 ((_tmp50_ = _tmp49_, GTK_IS_ENTRY (_tmp50_) ? ((GtkEntry*) _tmp50_) : NULL));
	_tmp52_ = _tmp51_;
	_g_object_unref0 (self->priv->entry_ipv4_gateway);
	self->priv->entry_ipv4_gateway = _tmp52_;
	_tmp53_ = gtk_builder_get_object (b, "combobox_ipv6_method");
	_tmp55_ = _g_object_ref0 ((_tmp54_ = _tmp53_, GTK_IS_COMBO_BOX (_tmp54_) ? ((GtkComboBox*) _tmp54_) : NULL));
	_tmp56_ = _tmp55_;
	_g_object_unref0 (self->priv->combobox_ipv6_method);
	self->priv->combobox_ipv6_method = _tmp56_;
	_tmp57_ = gtk_builder_get_object (b, "entry_ipv6_address");
	_tmp59_ = _g_object_ref0 ((_tmp58_ = _tmp57_, GTK_IS_ENTRY (_tmp58_) ? ((GtkEntry*) _tmp58_) : NULL));
	_tmp60_ = _tmp59_;
	_g_object_unref0 (self->priv->entry_ipv6_address);
	self->priv->entry_ipv6_address = _tmp60_;
	_tmp61_ = gtk_builder_get_object (b, "entry_ipv6_prefix_length");
	_tmp63_ = _g_object_ref0 ((_tmp62_ = _tmp61_, GTK_IS_ENTRY (_tmp62_) ? ((GtkEntry*) _tmp62_) : NULL));
	_tmp64_ = _tmp63_;
	_g_object_unref0 (self->priv->entry_ipv6_prefix_length);
	self->priv->entry_ipv6_prefix_length = _tmp64_;
	_tmp65_ = gtk_builder_get_object (b, "entry_ipv6_gateway");
	_tmp67_ = _g_object_ref0 ((_tmp66_ = _tmp65_, GTK_IS_ENTRY (_tmp66_) ? ((GtkEntry*) _tmp66_) : NULL));
	_tmp68_ = _tmp67_;
	_g_object_unref0 (self->priv->entry_ipv6_gateway);
	self->priv->entry_ipv6_gateway = _tmp68_;
	_tmp69_ = gtk_builder_get_object (b, "entry_nameservers");
	_tmp71_ = _g_object_ref0 ((_tmp70_ = _tmp69_, GTK_IS_ENTRY (_tmp70_) ? ((GtkEntry*) _tmp70_) : NULL));
	_tmp72_ = _tmp71_;
	_g_object_unref0 (self->priv->entry_nameservers);
	self->priv->entry_nameservers = _tmp72_;
	_tmp73_ = gtk_builder_get_object (b, "entry_domains");
	_tmp75_ = _g_object_ref0 ((_tmp74_ = _tmp73_, GTK_IS_ENTRY (_tmp74_) ? ((GtkEntry*) _tmp74_) : NULL));
	_tmp76_ = _tmp75_;
	_g_object_unref0 (self->priv->entry_domains);
	self->priv->entry_domains = _tmp76_;
	_tmp77_ = gtk_builder_get_object (b, "notebook_sections");
	_tmp79_ = _g_object_ref0 ((_tmp78_ = _tmp77_, GTK_IS_NOTEBOOK (_tmp78_) ? ((GtkNotebook*) _tmp78_) : NULL));
	_tmp80_ = _tmp79_;
	_g_object_unref0 (self->priv->notebook_sections);
	self->priv->notebook_sections = _tmp80_;
	_g_object_unref0 (b);
}


static void _edit_connection_dialog_on_button_save_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	edit_connection_dialog_on_button_save_clicked (self);
}


static void _edit_connection_dialog_on_button_cancel_clicked_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	edit_connection_dialog_on_button_cancel_clicked (self);
}


static void _edit_connection_dialog_ipv4_method_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	edit_connection_dialog_ipv4_method_changed (self, _sender);
}


static void _edit_connection_dialog_ipv6_method_changed_gtk_combo_box_changed (GtkComboBox* _sender, gpointer self) {
	edit_connection_dialog_ipv6_method_changed (self, _sender);
}


static void edit_connection_dialog_connect_signals (EditConnectionDialog* self) {
	g_return_if_fail (self != NULL);
	g_signal_connect_object (self->priv->button_save, "clicked", (GCallback) _edit_connection_dialog_on_button_save_clicked_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->button_cancel, "clicked", (GCallback) _edit_connection_dialog_on_button_cancel_clicked_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->priv->combobox_ipv4_method, "changed", (GCallback) _edit_connection_dialog_ipv4_method_changed_gtk_combo_box_changed, self, 0);
	g_signal_connect_object (self->priv->combobox_ipv6_method, "changed", (GCallback) _edit_connection_dialog_ipv6_method_changed_gtk_combo_box_changed, self, 0);
}


static void edit_connection_dialog_ipv4_method_changed (EditConnectionDialog* self, GtkComboBox* box) {
	GtkTreeIter iter = {0};
	GtkListStore* store = NULL;
	ConnmanIPv4Method method = 0;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_;
	GtkListStore* _tmp4_;
	GtkListStore* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->combobox_ipv4_method, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_ == FALSE) {
		_g_object_unref0 (store);
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (self->priv->combobox_ipv4_method);
	_tmp4_ = _g_object_ref0 ((_tmp3_ = _tmp2_, GTK_IS_LIST_STORE (_tmp3_) ? ((GtkListStore*) _tmp3_) : NULL));
	_tmp5_ = _tmp4_;
	_g_object_unref0 (store);
	store = _tmp5_;
	gtk_tree_model_get ((GtkTreeModel*) store, &iter, 0, &method, -1);
	switch (method) {
		case CONNMAN_IPV4_METHOD_MANUAL:
		{
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv4_address, TRUE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv4_netmask, TRUE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv4_gateway, TRUE);
			break;
		}
		default:
		case CONNMAN_IPV4_METHOD_OFF:
		case CONNMAN_IPV4_METHOD_DHCP:
		{
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv4_address, FALSE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv4_netmask, FALSE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv4_gateway, FALSE);
			break;
		}
	}
	_g_object_unref0 (store);
}


static void edit_connection_dialog_ipv6_method_changed (EditConnectionDialog* self, GtkComboBox* box) {
	GtkTreeIter iter = {0};
	GtkListStore* store = NULL;
	ConnmanIPv6Method method = 0;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_;
	GtkTreeModel* _tmp2_ = NULL;
	GtkTreeModel* _tmp3_;
	GtkListStore* _tmp4_;
	GtkListStore* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (box != NULL);
	_tmp1_ = gtk_combo_box_get_active_iter (self->priv->combobox_ipv6_method, &_tmp0_);
	iter = _tmp0_;
	if (_tmp1_ == FALSE) {
		_g_object_unref0 (store);
		return;
	}
	_tmp2_ = gtk_combo_box_get_model (self->priv->combobox_ipv6_method);
	_tmp4_ = _g_object_ref0 ((_tmp3_ = _tmp2_, GTK_IS_LIST_STORE (_tmp3_) ? ((GtkListStore*) _tmp3_) : NULL));
	_tmp5_ = _tmp4_;
	_g_object_unref0 (store);
	store = _tmp5_;
	gtk_tree_model_get ((GtkTreeModel*) store, &iter, 0, &method, -1);
	switch (method) {
		case CONNMAN_IPV6_METHOD_MANUAL:
		{
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv6_address, TRUE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv6_prefix_length, TRUE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv6_gateway, TRUE);
			break;
		}
		default:
		case CONNMAN_IPV6_METHOD_OFF:
		case CONNMAN_IPV6_METHOD_AUTO:
		{
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv6_address, FALSE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv6_prefix_length, FALSE);
			gtk_widget_set_sensitive ((GtkWidget*) self->priv->entry_ipv6_gateway, FALSE);
			break;
		}
	}
	_g_object_unref0 (store);
}


static void edit_connection_dialog_update_mode (EditConnectionDialog* self) {
	gchar* _tmp0_;
	gchar* mode;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	mode = _tmp0_;
	switch ((g_object_get (self->priv->connection, "mode", &_tmp1_, NULL), _tmp1_)) {
		case CONNMAN_SERVICE_MODE_MANAGED:
		{
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = g_strdup ("Infrastructure");
			_tmp3_ = _tmp2_;
			_g_free0 (mode);
			mode = _tmp3_;
			break;
		}
		case CONNMAN_SERVICE_MODE_ADHOC:
		{
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = g_strdup ("Ad-Hoc");
			_tmp5_ = _tmp4_;
			_g_free0 (mode);
			mode = _tmp5_;
			break;
		}
		default:
		break;
	}
	gtk_label_set_text (self->priv->label_mode, mode);
	_g_free0 (mode);
}


static void edit_connection_dialog_update_name (EditConnectionDialog* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = connman_service_get_name (self->priv->connection);
	gtk_label_set_text (self->priv->label_name, _tmp0_);
}


static void edit_connection_dialog_update_autoconnect (EditConnectionDialog* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connman_service_get_autoconnect (self->priv->connection);
	gtk_toggle_button_set_active ((GtkToggleButton*) self->priv->checkbutton_autoconnect, _tmp0_);
}


static void edit_connection_dialog_save_autoconnect (EditConnectionDialog* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_toggle_button_get_active ((GtkToggleButton*) self->priv->checkbutton_autoconnect);
	connman_service_set_autoconnect (self->priv->connection, _tmp0_);
}


static void edit_connection_dialog_update_security (EditConnectionDialog* self) {
	gchar* _tmp0_;
	gchar* security;
	guint _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup ("");
	security = _tmp0_;
	_tmp1_ = connman_service_get_security (self->priv->connection);
	switch (_tmp1_) {
		case CONNMAN_SERVICE_SECURITY_NONE:
		{
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp2_ = g_strdup ("None");
			_tmp3_ = _tmp2_;
			_g_free0 (security);
			security = _tmp3_;
			break;
		}
		case CONNMAN_SERVICE_SECURITY_WEP:
		{
			gchar* _tmp4_;
			gchar* _tmp5_;
			_tmp4_ = g_strdup ("WEP");
			_tmp5_ = _tmp4_;
			_g_free0 (security);
			security = _tmp5_;
			break;
		}
		case CONNMAN_SERVICE_SECURITY_PSK:
		{
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = g_strdup ("WPA-PSK");
			_tmp7_ = _tmp6_;
			_g_free0 (security);
			security = _tmp7_;
			break;
		}
		case CONNMAN_SERVICE_SECURITY_IEEE8021X:
		{
			gchar* _tmp8_;
			gchar* _tmp9_;
			_tmp8_ = g_strdup ("WPA-Enterprise");
			_tmp9_ = _tmp8_;
			_g_free0 (security);
			security = _tmp9_;
			break;
		}
		default:
		break;
	}
	gtk_label_set_text (self->priv->label_security, security);
	_g_free0 (security);
}


static void edit_connection_dialog_update_passphrase (EditConnectionDialog* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = connman_service_get_passphrase (self->priv->connection);
	gtk_entry_set_text (self->priv->entry_passphrase, _tmp0_);
}


static void edit_connection_dialog_save_passphrase (EditConnectionDialog* self) {
	const gchar* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text (self->priv->entry_passphrase);
	connman_service_set_passphrase (self->priv->connection, _tmp0_);
}


static void edit_connection_dialog_update_ipv4 (EditConnectionDialog* self) {
	ConnmanIPv4* _tmp0_ = NULL;
	ConnmanIPv4* _tmp1_;
	ConnmanIPv4* ipv4;
	GtkTreeIter iter = {0};
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connman_service_get_ipv4_configuration (self->priv->connection);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ipv4 = _tmp1_;
	_tmp2_ = connman_ipv4_get_method (ipv4);
	switch (_tmp2_) {
		case CONNMAN_IPV4_METHOD_OFF:
		{
			iter = self->priv->ipv4_off_iter;
			break;
		}
		case CONNMAN_IPV4_METHOD_MANUAL:
		{
			const gchar* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			const gchar* _tmp5_ = NULL;
			iter = self->priv->ipv4_manual_iter;
			_tmp3_ = connman_ipv4_get_address (ipv4);
			gtk_entry_set_text (self->priv->entry_ipv4_address, _tmp3_);
			_tmp4_ = connman_ipv4_get_netmask (ipv4);
			gtk_entry_set_text (self->priv->entry_ipv4_netmask, _tmp4_);
			_tmp5_ = connman_ipv4_get_gateway (ipv4);
			gtk_entry_set_text (self->priv->entry_ipv4_gateway, _tmp5_);
			break;
		}
		default:
		case CONNMAN_IPV4_METHOD_DHCP:
		{
			iter = self->priv->ipv4_dhcp_iter;
			break;
		}
	}
	gtk_combo_box_set_active_iter (self->priv->combobox_ipv4_method, &iter);
	_g_object_unref0 (ipv4);
}


static void edit_connection_dialog_save_ipv4 (EditConnectionDialog* self) {
	GtkTreeIter iter = {0};
	ConnmanIPv4Method method = 0;
	ConnmanIPv4* ipv4 = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* store;
	GtkTreeIter _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* address;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* netmask;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* gateway;
	ConnmanIPv4* _tmp10_ = NULL;
	ConnmanIPv4* _tmp11_;
	ConnmanIPv4* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_combo_box_get_model (self->priv->combobox_ipv4_method);
	_tmp2_ = _g_object_ref0 ((_tmp1_ = _tmp0_, GTK_IS_LIST_STORE (_tmp1_) ? ((GtkListStore*) _tmp1_) : NULL));
	store = _tmp2_;
	gtk_combo_box_get_active_iter (self->priv->combobox_ipv4_method, &_tmp3_);
	iter = _tmp3_;
	gtk_tree_model_get ((GtkTreeModel*) store, &iter, 0, &method, -1);
	_tmp4_ = gtk_entry_get_text (self->priv->entry_ipv4_address);
	_tmp5_ = g_strdup (_tmp4_);
	address = _tmp5_;
	_tmp6_ = gtk_entry_get_text (self->priv->entry_ipv4_netmask);
	_tmp7_ = g_strdup (_tmp6_);
	netmask = _tmp7_;
	_tmp8_ = gtk_entry_get_text (self->priv->entry_ipv4_gateway);
	_tmp9_ = g_strdup (_tmp8_);
	gateway = _tmp9_;
	_tmp10_ = connman_ipv4_new (method, address, netmask, gateway, &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		goto __catch4_g_error;
	}
	_tmp12_ = _tmp11_;
	_g_object_unref0 (ipv4);
	ipv4 = _tmp12_;
	connman_service_set_ipv4_configuration (self->priv->connection, ipv4);
	goto __finally4;
	__catch4_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Failed to create ipv4 object: %s", e->message);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_g_free0 (gateway);
		_g_free0 (netmask);
		_g_free0 (address);
		_g_object_unref0 (store);
		_g_object_unref0 (ipv4);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (gateway);
	_g_free0 (netmask);
	_g_free0 (address);
	_g_object_unref0 (store);
	_g_object_unref0 (ipv4);
}


static void edit_connection_dialog_update_ipv6 (EditConnectionDialog* self) {
	ConnmanIPv6* _tmp0_ = NULL;
	ConnmanIPv6* _tmp1_;
	ConnmanIPv6* ipv6;
	GtkTreeIter iter = {0};
	guint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connman_service_get_ipv6_configuration (self->priv->connection);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	ipv6 = _tmp1_;
	_tmp2_ = connman_ipv6_get_method (ipv6);
	switch (_tmp2_) {
		case CONNMAN_IPV6_METHOD_OFF:
		{
			iter = self->priv->ipv6_off_iter;
			break;
		}
		case CONNMAN_IPV6_METHOD_MANUAL:
		{
			const gchar* _tmp3_ = NULL;
			guint8 _tmp4_;
			gchar* _tmp5_ = NULL;
			gchar* _tmp6_;
			const gchar* _tmp7_ = NULL;
			iter = self->priv->ipv6_manual_iter;
			_tmp3_ = connman_ipv6_get_address (ipv6);
			gtk_entry_set_text (self->priv->entry_ipv6_address, _tmp3_);
			_tmp4_ = connman_ipv6_get_prefix_length (ipv6);
			_tmp5_ = g_strdup_printf ("%hhu", _tmp4_);
			_tmp6_ = _tmp5_;
			gtk_entry_set_text (self->priv->entry_ipv6_prefix_length, _tmp6_);
			_g_free0 (_tmp6_);
			_tmp7_ = connman_ipv6_get_gateway (ipv6);
			gtk_entry_set_text (self->priv->entry_ipv6_gateway, _tmp7_);
			break;
		}
		default:
		case CONNMAN_IPV6_METHOD_AUTO:
		{
			iter = self->priv->ipv6_auto_iter;
			break;
		}
	}
	gtk_combo_box_set_active_iter (self->priv->combobox_ipv6_method, &iter);
	_g_object_unref0 (ipv6);
}


static guint64 uint64_parse (const gchar* str) {
	guint64 result = 0ULL;
	guint64 _tmp0_;
	g_return_val_if_fail (str != NULL, 0ULL);
	_tmp0_ = g_ascii_strtoull (str, NULL, (guint) 0);
	result = _tmp0_;
	return result;
}


static void edit_connection_dialog_save_ipv6 (EditConnectionDialog* self) {
	GtkTreeIter iter = {0};
	ConnmanIPv6Method method = 0;
	ConnmanIPv6* ipv6 = NULL;
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeModel* _tmp1_;
	GtkListStore* _tmp2_;
	GtkListStore* store;
	GtkTreeIter _tmp3_ = {0};
	const gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	gchar* address;
	const gchar* _tmp6_ = NULL;
	guint64 _tmp7_;
	guint8 prefix_length;
	const gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	gchar* gateway;
	ConnmanIPv6* _tmp10_ = NULL;
	ConnmanIPv6* _tmp11_;
	ConnmanIPv6* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_combo_box_get_model (self->priv->combobox_ipv6_method);
	_tmp2_ = _g_object_ref0 ((_tmp1_ = _tmp0_, GTK_IS_LIST_STORE (_tmp1_) ? ((GtkListStore*) _tmp1_) : NULL));
	store = _tmp2_;
	gtk_combo_box_get_active_iter (self->priv->combobox_ipv6_method, &_tmp3_);
	iter = _tmp3_;
	gtk_tree_model_get ((GtkTreeModel*) store, &iter, 0, &method, -1);
	_tmp4_ = gtk_entry_get_text (self->priv->entry_ipv6_address);
	_tmp5_ = g_strdup (_tmp4_);
	address = _tmp5_;
	_tmp6_ = gtk_entry_get_text (self->priv->entry_ipv6_prefix_length);
	_tmp7_ = uint64_parse (_tmp6_);
	prefix_length = (guint8) _tmp7_;
	_tmp8_ = gtk_entry_get_text (self->priv->entry_ipv6_gateway);
	_tmp9_ = g_strdup (_tmp8_);
	gateway = _tmp9_;
	_tmp10_ = connman_ipv6_new (method, address, prefix_length, gateway, &_inner_error_);
	_tmp11_ = _tmp10_;
	if (_inner_error_ != NULL) {
		goto __catch5_g_error;
	}
	_tmp12_ = _tmp11_;
	_g_object_unref0 (ipv6);
	ipv6 = _tmp12_;
	connman_service_set_ipv6_configuration (self->priv->connection, ipv6);
	goto __finally5;
	__catch5_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		fprintf (stderr, "Failed to create ipv6 object: %s", e->message);
		_g_error_free0 (e);
	}
	__finally5:
	if (_inner_error_ != NULL) {
		_g_free0 (gateway);
		_g_free0 (address);
		_g_object_unref0 (store);
		_g_object_unref0 (ipv6);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (gateway);
	_g_free0 (address);
	_g_object_unref0 (store);
	_g_object_unref0 (ipv6);
}


static void edit_connection_dialog_update_nameservers (EditConnectionDialog* self) {
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* s;
	g_return_if_fail (self != NULL);
	_tmp1_ = _tmp0_ = connman_service_get_nameservers_configuration (self->priv->connection);
	_tmp2_ = g_strjoinv (" ", _tmp1_);
	s = _tmp2_;
	gtk_entry_set_text (self->priv->entry_nameservers, s);
	_g_free0 (s);
}


static gchar* string_strip (const gchar* self) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void edit_connection_dialog_save_nameservers (EditConnectionDialog* self) {
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gchar** servers;
	gint servers_length1;
	gint _servers_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text (self->priv->entry_nameservers);
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
	array = _tmp2_;
	array_length1 = _vala_array_length (_tmp1_);
	_array_size_ = _vala_array_length (_tmp1_);
	servers = NULL;
	servers_length1 = 0;
	_servers_size_ = 0;
	{
		gchar** server_collection;
		int server_collection_length1;
		int server_it;
		server_collection = array;
		server_collection_length1 = array_length1;
		for (server_it = 0; server_it < array_length1; server_it = server_it + 1) {
			gchar* _tmp3_;
			gchar* server;
			_tmp3_ = g_strdup (server_collection[server_it]);
			server = _tmp3_;
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = string_strip (server);
				_vala_array_add1 (&servers, &servers_length1, &_servers_size_, _tmp4_);
				_g_free0 (server);
			}
		}
	}
	connman_service_set_nameservers_configuration (self->priv->connection, servers);
	servers = (_vala_array_free (servers, servers_length1, (GDestroyNotify) g_free), NULL);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}


static void edit_connection_dialog_update_domains (EditConnectionDialog* self) {
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gchar* s;
	g_return_if_fail (self != NULL);
	_tmp1_ = _tmp0_ = connman_service_get_domains_configuration (self->priv->connection);
	_tmp2_ = g_strjoinv (" ", _tmp1_);
	s = _tmp2_;
	gtk_entry_set_text (self->priv->entry_domains, s);
	_g_free0 (s);
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void edit_connection_dialog_save_domains (EditConnectionDialog* self) {
	const gchar* _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_ = NULL;
	gchar** array;
	gint array_length1;
	gint _array_size_;
	gchar** domains;
	gint domains_length1;
	gint _domains_size_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_entry_get_text (self->priv->entry_domains);
	_tmp2_ = _tmp1_ = g_strsplit (_tmp0_, " ", 0);
	array = _tmp2_;
	array_length1 = _vala_array_length (_tmp1_);
	_array_size_ = _vala_array_length (_tmp1_);
	domains = NULL;
	domains_length1 = 0;
	_domains_size_ = 0;
	{
		gchar** server_collection;
		int server_collection_length1;
		int server_it;
		server_collection = array;
		server_collection_length1 = array_length1;
		for (server_it = 0; server_it < array_length1; server_it = server_it + 1) {
			gchar* _tmp3_;
			gchar* server;
			_tmp3_ = g_strdup (server_collection[server_it]);
			server = _tmp3_;
			{
				gchar* _tmp4_ = NULL;
				_tmp4_ = string_strip (server);
				_vala_array_add2 (&domains, &domains_length1, &_domains_size_, _tmp4_);
				_g_free0 (server);
			}
		}
	}
	connman_service_set_domains_configuration (self->priv->connection, domains);
	domains = (_vala_array_free (domains, domains_length1, (GDestroyNotify) g_free), NULL);
	array = (_vala_array_free (array, array_length1, (GDestroyNotify) g_free), NULL);
}


static void edit_connection_dialog_update_widget_values (EditConnectionDialog* self) {
	ConnmanServiceType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connman_service_get_service_type (self->priv->connection);
	switch (_tmp0_) {
		case CONNMAN_SERVICE_TYPE_WIFI:
		{
			edit_connection_dialog_update_name (self);
			edit_connection_dialog_update_autoconnect (self);
			edit_connection_dialog_update_mode (self);
			edit_connection_dialog_update_security (self);
			edit_connection_dialog_update_passphrase (self);
			edit_connection_dialog_update_ipv4 (self);
			edit_connection_dialog_update_ipv6 (self);
			edit_connection_dialog_update_nameservers (self);
			edit_connection_dialog_update_domains (self);
			break;
		}
		case CONNMAN_SERVICE_TYPE_ETHERNET:
		{
			edit_connection_dialog_update_name (self);
			edit_connection_dialog_update_autoconnect (self);
			edit_connection_dialog_update_ipv4 (self);
			edit_connection_dialog_update_ipv6 (self);
			edit_connection_dialog_update_nameservers (self);
			edit_connection_dialog_update_domains (self);
			break;
		}
		case CONNMAN_SERVICE_TYPE_BLUETOOTH:
		{
			edit_connection_dialog_update_name (self);
			edit_connection_dialog_update_autoconnect (self);
			edit_connection_dialog_update_ipv4 (self);
			edit_connection_dialog_update_ipv6 (self);
			edit_connection_dialog_update_nameservers (self);
			edit_connection_dialog_update_domains (self);
			break;
		}
		default:
		break;
	}
}


static void edit_connection_dialog_save_widget_values (EditConnectionDialog* self) {
	ConnmanServiceType _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = connman_service_get_service_type (self->priv->connection);
	switch (_tmp0_) {
		case CONNMAN_SERVICE_TYPE_WIFI:
		{
			edit_connection_dialog_save_autoconnect (self);
			edit_connection_dialog_save_passphrase (self);
			edit_connection_dialog_save_ipv4 (self);
			edit_connection_dialog_save_ipv6 (self);
			edit_connection_dialog_save_nameservers (self);
			edit_connection_dialog_save_domains (self);
			break;
		}
		case CONNMAN_SERVICE_TYPE_ETHERNET:
		{
			edit_connection_dialog_save_autoconnect (self);
			edit_connection_dialog_save_ipv4 (self);
			edit_connection_dialog_save_ipv6 (self);
			edit_connection_dialog_save_nameservers (self);
			edit_connection_dialog_save_domains (self);
			break;
		}
		case CONNMAN_SERVICE_TYPE_BLUETOOTH:
		{
			edit_connection_dialog_save_autoconnect (self);
			edit_connection_dialog_save_ipv4 (self);
			edit_connection_dialog_save_ipv6 (self);
			edit_connection_dialog_save_nameservers (self);
			edit_connection_dialog_save_domains (self);
			break;
		}
		default:
		break;
	}
}


static void edit_connection_dialog_on_button_save_clicked (EditConnectionDialog* self) {
	g_return_if_fail (self != NULL);
	edit_connection_dialog_save_widget_values (self);
	gtk_object_destroy ((GtkObject*) self->priv->dialog);
	g_signal_emit_by_name (self, "response", (gint) GTK_RESPONSE_APPLY);
}


static void edit_connection_dialog_on_button_cancel_clicked (EditConnectionDialog* self) {
	g_return_if_fail (self != NULL);
	gtk_object_destroy ((GtkObject*) self->priv->dialog);
	g_signal_emit_by_name (self, "response", (gint) GTK_RESPONSE_CANCEL);
}


gint edit_connection_dialog_run (EditConnectionDialog* self) {
	gint result = 0;
	g_return_val_if_fail (self != NULL, 0);
	gtk_widget_show_all ((GtkWidget*) self->priv->dialog);
	result = 0;
	return result;
}


static void edit_connection_dialog_class_init (EditConnectionDialogClass * klass) {
	edit_connection_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (EditConnectionDialogPrivate));
	G_OBJECT_CLASS (klass)->finalize = edit_connection_dialog_finalize;
	g_signal_new ("response", TYPE_EDIT_CONNECTION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void edit_connection_dialog_instance_init (EditConnectionDialog * self) {
	gchar* _tmp0_;
	gchar** _tmp1_ = NULL;
	self->priv = EDIT_CONNECTION_DIALOG_GET_PRIVATE (self);
	_tmp0_ = g_strdup ("button_cancel");
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	self->priv->hint_labels = _tmp1_;
	self->priv->hint_labels_length1 = 1;
	self->priv->_hint_labels_size_ = self->priv->hint_labels_length1;
}


static void edit_connection_dialog_finalize (GObject* obj) {
	EditConnectionDialog * self;
	self = EDIT_CONNECTION_DIALOG (obj);
	_g_object_unref0 (self->priv->connection);
	_g_object_unref0 (self->priv->builder);
	_g_object_unref0 (self->priv->dialog);
	_g_object_unref0 (self->priv->table_main);
	_g_object_unref0 (self->priv->button_save);
	_g_object_unref0 (self->priv->button_cancel);
	_g_object_unref0 (self->priv->label_name);
	_g_object_unref0 (self->priv->checkbutton_autoconnect);
	_g_object_unref0 (self->priv->label_mode);
	_g_object_unref0 (self->priv->label_security);
	_g_object_unref0 (self->priv->entry_passphrase);
	_g_object_unref0 (self->priv->combobox_ipv4_method);
	_g_object_unref0 (self->priv->entry_ipv4_address);
	_g_object_unref0 (self->priv->entry_ipv4_netmask);
	_g_object_unref0 (self->priv->entry_ipv4_gateway);
	_g_object_unref0 (self->priv->combobox_ipv6_method);
	_g_object_unref0 (self->priv->entry_ipv6_address);
	_g_object_unref0 (self->priv->entry_ipv6_prefix_length);
	_g_object_unref0 (self->priv->entry_ipv6_gateway);
	_g_object_unref0 (self->priv->entry_nameservers);
	_g_object_unref0 (self->priv->entry_domains);
	_g_object_unref0 (self->priv->notebook_sections);
	_g_object_unref0 (self->priv->pages);
	self->priv->hint_labels = (_vala_array_free (self->priv->hint_labels, self->priv->hint_labels_length1, (GDestroyNotify) g_free), NULL);
	G_OBJECT_CLASS (edit_connection_dialog_parent_class)->finalize (obj);
}


GType edit_connection_dialog_get_type (void) {
	static volatile gsize edit_connection_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&edit_connection_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (EditConnectionDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) edit_connection_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (EditConnectionDialog), 0, (GInstanceInitFunc) edit_connection_dialog_instance_init, NULL };
		GType edit_connection_dialog_type_id;
		edit_connection_dialog_type_id = g_type_register_static (G_TYPE_OBJECT, "EditConnectionDialog", &g_define_type_info, 0);
		g_once_init_leave (&edit_connection_dialog_type_id__volatile, edit_connection_dialog_type_id);
	}
	return edit_connection_dialog_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



